/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  command switch table generator		File: MKPARSE.C		**
   **									**
   **  this is an old, old, old piece of that code that has found	**
   **  its way into way too many programs.  But, it works for me.	**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

/*  *********************************************************************
    *  Constants                                                        *
    ********************************************************************* */

#define TRUE 1
#define FALSE 0
#define MAXCMD 200
#define MAXSWITCH 200

/*  *********************************************************************
    *  Structures                                                       *
    ********************************************************************* */

typedef struct Cons {
        char *str;
        int num;
        } CONS;

typedef struct Command {
        char *symbol;
        char *template;
        int symval;
        int swcount;
        } COMMAND;

/*  *********************************************************************
    *  Globals                                                          *
    ********************************************************************* */

enum {cSWITCHES = 1,cTABNAME,cCOMMANDS,cEND,cDIGITSWITCH};

CONS commands[] = {
        {"tabname",cTABNAME},
        {"digitswitch",cDIGITSWITCH},
        {"switches",cSWITCHES},
        {"commands",cCOMMANDS},
        {"end",cEND},
        {NULL,0}};


enum {pSYMPREFIX = 1,pFUNCPREFIX};

CONS params[] = {
        {"symprefix",pSYMPREFIX},
        {"funcprefix",pFUNCPREFIX},
        {NULL,0}};

COMMAND cmdtab[MAXCMD] = {NULL};

char *switchtab[MAXSWITCH] = {NULL};

char curtabname[100];

int digitmode = FALSE;
char digitswitch[100] = {0};

char temp[200];
char line[200];

FILE *infile;
FILE *outhfile;
FILE *outcfile;

char inname[64];
char outcname[64];
char outhname[64];

char setname[100];

int errorflg = FALSE;


/*  *********************************************************************
    *  Assoc(list,str)                                                  *
    *                                                                   *
    *  Returns matching number from a list of number/string pairs       *
    *                                                                   *
    *  Input Parameters:                                                *
    *      list - list                                                  *
    *      str - string to find                                         *
    *                                                                   *
    *  Return Value:                                                    *
    *      number, or 0 if not found                                    *
    ********************************************************************* */

int assoc(list,str)
CONS *list;
char *str;
{
        while (list->str) {
                if (strcmp(list->str,str) == 0) return list->num;
                list++;
                }
        return 0;
}


/*  *********************************************************************
    *  getline()                                                        *
    *                                                                   *
    *  Read next line from input file                                   *
    *                                                                   *
    *  Input Parameters:                                                *
    *      nothing.                                                     *
    *                                                                   *
    *  Return Value:                                                    *
    *      TRUE if at EOF                                               *
    ********************************************************************* */
int getline(void)
{
        static int ateof = FALSE;
        char *x;

        if (ateof) return TRUE;

        for (;;) {
                if (!fgets(line,sizeof(line),infile)) {
                        ateof = TRUE;
                        return TRUE;
                        }
                if (line[0] == '\n') continue;
                if (line[0] == ';') continue;
                break;
                }

        if (x = strchr(line,'\n')) *x = '\0';

        return FALSE;
}


/*  *********************************************************************
    *  getqstring(inp,outp)                                             *
    *                                                                   *
    *  Read quoted string from input string                             *
    *                                                                   *
    *  Input Parameters:                                                *
    *      inp - input string pointer                                   *
    *      outp - where to put quoted string                            *
    *                                                                   *
    *  Return Value:                                                    *
    *      new input string, or NULL if no quoted string on line        *
    ********************************************************************* */

char *getqstring(inp,outp)
char *inp,*outp;
{
        *outp = '\0';

        while (*inp) {
                if (*inp == '"') break;
                inp++;
                }
        if (!*inp) return NULL;

        *outp++ = *inp++;

        while (*inp) {
                if (*inp == '"') break;
                *outp++ = *inp++;
                }

        *outp = '\0';
        if (!*inp) return NULL;

        *outp++ = *inp++;
        *outp = '\0';

        return inp;
}


/*  *********************************************************************
    *  doswitches(prefix,tabname)                                       *
    *                                                                   *
    *  Generate output for switch table                                 *
    *                                                                   *
    *  Input Parameters:                                                *
    *      prefix - prefix for switch name symbols                      *
    *      tabname - name of switch table                               *
    *                                                                   *
    *  Return Value:                                                    *
    *      nothing.                                                     *
    ********************************************************************* */

void doswitches(prefix,tabname)
char *prefix;
char *tabname;
{
        char *tok;
        char *name;
        int swnum;
        int i;

        swnum = 0;

        for (i=0; i<MAXSWITCH; i++) {
                if (switchtab[i]) free(switchtab[i]);
                }
        memset(&switchtab[0],0,sizeof(switchtab));

        fprintf(outcfile,"PARSESWITCH %sswtab[] = {\n",tabname);

        while (!getline()) {
                if (line[0] == '!') break;

                name = strtok(line," \t");
                if (!name) continue;            /* skip line */

                tok = strtok(NULL," \t");
                if (!tok) continue;
                if (strcmp(tok,"==") != 0) fprintf(stderr,"Unrecognized token: %s\n",tok);

                if (!getqstring(tok+strlen(tok)+1,temp)) {
                        fprintf(stderr,"No switch string, using symbol\n");
                        errorflg = TRUE;
                        strcpy(temp,name);
                        }

                fprintf(outhfile,"#define %s%s %d\n",prefix,name,swnum);
                fprintf(outcfile,"\t{%s},\n",temp);
                sprintf(temp,"%s%s",prefix,name);
                switchtab[swnum] = strdup(temp);
                swnum++;
                }

        fprintf(outcfile,"\t{NULL}};\n\n");
        fprintf(outhfile,"\n\n");
}

/*  *********************************************************************
    *  countcommas(x)                                                   *
    *                                                                   *
    *  Counts the commas in an input string                             *
    *                                                                   *
    *  Input Parameters:                                                *
    *      x - input string                                             *
    *                                                                   *
    *  Return Value:                                                    *
    *      number of commas                                             *
    ********************************************************************* */

int countcommas(x)
char *x;
{
        int num = 0;

        while (*x) {
                if (*x == ',') num++;
                x++;
                }

        return num;
}

/*  *********************************************************************
    *  checkswitches(x)                                                 *
    *                                                                   *
    *  Cehecks the switches passed on the input line                    *
    *                                                                   *
    *  Input Parameters:                                                *
    *      x - input line                                               *
    *                                                                   *
    *  Return Value:                                                    *
    *      nothing.                                                     *
    ********************************************************************* */

void checkswitches(x)
char *x;
{
        int i;

        strcpy(temp,x);

        x = strtok(temp,", ");
        while (x) {
                for (i=0; i<MAXSWITCH; i++) {
                        if (switchtab[i]) {
                                if (strcmp(switchtab[i],x) == 0) break;
                                }
                        }
                if (i == MAXSWITCH) {
                        printf("Error: Switch not defined: %s\n",x);
                        errorflg = TRUE;
                        }
                x = strtok(NULL,", ");
                }
}


/*  *********************************************************************
    *  docommands()                                                     *
    *                                                                   *
    *  Read in command tables                                           *
    *                                                                   *
    *  Input Parameters:                                                *
    *      sprefix - symbol prefix (string to prepend to symbols)       *
    *      fprefix - function prefix (string to prepend ot func names)  *
    *      tabname - name of switch table                               *
    *                                                                   *
    *  Return Value:                                                    *
    *      nothing.                                                     *
    ********************************************************************* */

void docommands(sprefix,fprefix,tabname)
char *sprefix;
char *fprefix;
char *tabname;
{
        char *name;
        char *tok;
        int numcmds = 0;
        int curval = 0;
        int i;
        int repeatflg;
        char cmdname[100];

        for (i=0; i<MAXCMD; i++) {
                if (cmdtab[i].template) free(cmdtab[i].template);
                if (cmdtab[i].symbol) free(cmdtab[i].symbol);
                }

        memset(&cmdtab[0],0,sizeof(cmdtab));

        strcpy(cmdname,"???");

        while (!getline()) {
                if (line[0] == '!') break;
                
                repeatflg = FALSE;

                name = strtok(line," \t");
                if (!name) continue;            /* skip line */

                if (strcmp(name,"==") == 0) {
                        repeatflg = TRUE;
                        tok = name;
                        }
                else {
                        strcpy(cmdname,name);

                        tok = strtok(NULL," \t");
                        if (!tok) continue;
                        if (strcmp(tok,"==") != 0) 
                                fprintf(stderr,"Unrecognized token: %s\n",tok);
                        }

                if (!(tok = getqstring(tok+strlen(tok)+1,temp))) {
                        fprintf(stderr,"No switch string, using symbol\n");
                        errorflg = TRUE;
                        strcpy(temp,cmdname);
                        }

                if (tok) {
                        while (*tok && isspace(*tok)) tok++;
                        if (!*tok) tok = NULL;
                        }

                cmdtab[numcmds].template = strdup(temp);

                if (tok) cmdtab[numcmds].swcount = countcommas(tok)+1;
                else cmdtab[numcmds].swcount = 0;

                cmdtab[numcmds].symbol = strdup(cmdname);
                if (!repeatflg) {
                        cmdtab[numcmds].symval = curval;
                        curval++;
                        }
                else cmdtab[numcmds].symval = -1;

                if (tok) checkswitches(tok);

                if (tok) {
                        fprintf(outcfile,"unsigned int swtab%03d[] = {\n\t%s\n\t};\n\n",
                                        numcmds,tok);
                        }

                numcmds++;

                }

        if (digitmode) {
                fprintf(outcfile,"unsigned int swtabddd[] = {\n\t%s\n\t};\n\n",digitswitch);
                }

        fprintf(outcfile,"PARSEITEM %sitems[] = {\n",tabname);

        if (digitmode) {
                fprintf(outcfile,"\t{-2,NULL,%d,swtabddd},\n",countcommas(digitswitch)+1);
                }

        fprintf(outhfile,"\n\n/* Command equates */\n");
        for (i = 0; i<numcmds; i++) {
                if (cmdtab[i].symval != -1) {
                        fprintf(outhfile,"#define %s%s %d\n",sprefix,cmdtab[i].symbol,
                                        cmdtab[i].symval);
                        }
                if (cmdtab[i].swcount) {
                        fprintf(outcfile,"\t{%s%s,%s,%d,swtab%03d},\n",
                                sprefix,cmdtab[i].symbol,
                                cmdtab[i].template,
                                cmdtab[i].swcount,i);
                        }
                else {
                        fprintf(outcfile,"\t{%s%s,%s,0,NULL},\n",
                                sprefix,cmdtab[i].symbol,
                                cmdtab[i].template);
                        }
                }
        fprintf(outcfile,"\t{0,NULL,0,NULL}};\n\n");
        fprintf(outhfile,"\n\n");

        fprintf(outcfile,"#ifndef TESTPROG\n");
        fprintf(outcfile,"unsigned int (*%sfuncs[])() = {\n",tabname);
        fprintf(outhfile,"\n\n/* Function definitions */\n\n");
        for (i = 0; i<numcmds; i++) {
                if (cmdtab[i].symval == -1) continue;
                fprintf(outcfile,"\t%s%s,\n",fprefix,cmdtab[i].symbol);
                fprintf(outhfile,"extern unsigned int %s%s();\n",fprefix,
                                cmdtab[i].symbol);
                }
        fprintf(outcfile,"\tNULL};\n#else\n\n");
        fprintf(outcfile,"unsigned int (*%sfuncs[])() = {\n",tabname);
        fprintf(outcfile,"\tNULL};\n#endif\n\n");
        fprintf(outhfile,"\n\n");

        fprintf(outcfile,"PARSESET %s = {%d,%sitems,%sswtab,%sfuncs};\n\n",
                                        strlen(setname) ? setname : tabname,
                                        numcmds+1,
                                        tabname,tabname,tabname);

}

/*  *********************************************************************
    *  error(a,b,c,d,e)                                                 *
    *                                                                   *
    *  Fatal error routine                                              *
    *                                                                   *
    *  Input Parameters:                                                *
    *      a,b,c,d,e - parameters                                       *
    *                                                                   *
    *  Return Value:                                                    *
    *      nothing.                                                     *
    ********************************************************************* */

void error(a,b,c,d,e,f,g)
char *a;
int b,c,d,e,f,g;
{
        fprintf(stderr,a,b,c,d,e,f,g);
        exit(1);
}


/*  *********************************************************************
    *  dodirect(lp)                                                     *
    *                                                                   *
    *  Execute a directive (!) line                                     *
    *                                                                   *
    *  Input Parameters:                                                *
    *      lp - command                                                 *
    *                                                                   *
    *  Return Value:                                                    *
    *      TRUE if OK                                                   *
    ********************************************************************* */

int dodirect(linep)
char *linep;
{
        char *cmd;
        char *kname;
        char *kval;
        static char sprefix[20] = "@";
        static char fprefix[20] = "@";
        char *tok;

        cmd = strtok(linep," \t");
        if (!cmd) return TRUE;

        switch (assoc(commands,cmd)) {
                case cTABNAME: tok = strtok(NULL," \t");
                                if (tok) strcpy(curtabname,tok);
                                tok = strtok(NULL," \t");
                                if (tok) strcpy(setname,tok);
                                getline();
                                return TRUE;
                case cDIGITSWITCH : tok = strtok(NULL," \t");
                                if (tok) {
                                        strcpy(digitswitch,tok);
                                        digitmode = TRUE;
                                        }
                                getline();
                                return TRUE;
                                break;
                }

        kname = strtok(NULL," \t");
        while (kname) {
                kval = strchr(kname,'=');

                if (!kval) {
                        fprintf(stderr,"Value missing for keyword: %s\n",kname);
                        errorflg = TRUE;
                        }
                else {
                        *kval = '\0';
                        kval++;
                        switch (assoc(params,kname)) {
                                case 0: printf("Invalid keyword: %s\n",kname);
                                        errorflg = TRUE;
                                        break;
                                case pSYMPREFIX:
                                        strcpy(sprefix,kval);
                                        break;
                                case pFUNCPREFIX:
                                        strcpy(fprefix,kval);
                                        break;
                                }
                        }
                kname = strtok(NULL," \t");
                }

        switch (assoc(commands,cmd)) {
                case 0: fprintf(stderr,"Invalid directive: !%s\n",cmd);
                        errorflg = TRUE;
                        break;
                case cEND: return FALSE;
                case cSWITCHES: doswitches(sprefix,curtabname);
                        break;
                case cCOMMANDS: docommands(sprefix,fprefix,curtabname);
                        break;
                }

        return TRUE;
}

        

/*  *********************************************************************
    *  main(argc,argv)                                                  *
    *                                                                   *
    *  It's gotta start somewhere...                                    *
    *                                                                   *
    *  Input Parameters:                                                *
    *      argc,argv - guess.                                           *
    *                                                                   *
    *  Return Value:                                                    *
    *      nothing.                                                     *
    ********************************************************************* */

void main(argc,argv)
int argc;
char *argv[];
{
        char *x;

        printf("MKPARSE - command table generator, version 1.00\n\n");

        if (argc < 2) {
                fprintf(stderr,"Usage: mkparse filename.cfg\n");
                exit(255);
                }

        strcpy(inname,argv[1]);
        if (x = strchr(inname,'.')) *x = '\0';

        strcpy(outcname,inname);
        strcpy(outhname,inname);

        strcat(inname,".cfg");
        strcat(outcname,".c");
        strcat(outhname,".h");

        infile = fopen(inname,"rt");
        if (!infile) error("Could not open input file %s\n",inname);

        outcfile = fopen(outcname,"wt");
        if (!outcfile) error("Could not open output file %s\n",outcfile); 

        outhfile = fopen(outhname,"wt");
        if (!outhfile) error("Could not open output file %s\n",outhfile); 

        printf("Reading:    %s\n",inname);
        printf("Writing:    %s\n",outhname);
        printf("Writing:    %s\n",outcname);

        printf("\n");

        fprintf(outcfile,"/*\n * File: %s, generated from %s\n */\n\n",
                                outcname,inname);
        fprintf(outhfile,"/*\n * File: %s, generated from %s\n */\n\n",
                                outhname,inname);

        fprintf(outcfile,"#include \"swparse.h\"\n");
        fprintf(outcfile,"#include \"%s\"\n",outhname);
        fprintf(outcfile,"#define NULL 0L\n");

        strcpy(curtabname,"???");
        strcpy(setname,"");

        if (!getline()) {
                if (line[0] != '!') {
                        error("Unrecognized command: %s\n",line);
                        }
                }

        for (;;) {
                if (!dodirect(line+1)) break;
                }

        fclose(infile);
        fclose(outcfile);
        fclose(outhfile);

        printf("Done.\n");

        exit(errorflg);
}


