/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  CRC Generator definitions		File: CKSUM.H		**
   **									**
   **  prototypes and constants for the cksum generator			**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/
void cksum (void *buf, int numbytes, /*VARINOUT*/unsigned char value[4]);
/* If the string A has checksum "value[0,..,3]", and the string B starts
   at address "buf" and is "numbytes" bytes long, then at the end of this
   call, "value[0,..,3]" contains the checksum of the string AB (that is,
   A immediately followed by B).  The checksum of the empty string is
   all zeroes.
   Only the least significant byte of each element of "value" is significant. */
