/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  USB "Control" module                    File: USBCTL.C           **
   **									**
   **  This module provides a "multiplex" interface for the USB         **
   **  protocol used in the Personal Jukebox.  At present, we only      **
   **  one type of packet through this interface, but should we add     **
   **  more types in the future (perhaps for different services) then   **
   **  this would be the place to do it.                                **
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#ifndef _USBCTL_H
#define _USBCTL_H


/*  *********************************************************************
    *  Constants related to our headers                                 *
    ********************************************************************* */

#define USB_PKT_HDRLEN	10		/* 10 bytes of header info */

/*  *********************************************************************
    *  USB device data							*
    ********************************************************************* */

#define USB_VENDOR_ID  	1183		/* "COMPAQ" */
#define USB_PRODUCT_ID  0x504A          /* "Personal Jukebox" */
#define USB_DEVICE_ID 	0x100

/*  *********************************************************************
    *  Constants							*
    ********************************************************************* */

#define USB_MAX_PORTS		2

#define USB_ENDPOINT_MAIN	0	/* for usb_open() */
#define USB_ENDPOINT_ALTERNATE	1

#define USB_PJB_PROTOCOL_PORT	0	/* for PJB protocol data */
#define USB_PJB_DEBUG_PORT	1	/* for PJBTERM data */

#define USB_PJB_PROTOCOL_ENDPOINT USB_ENDPOINT_MAIN
#define USB_PJB_DEBUG_ENDPOINT	USB_ENDPOINT_ALTERNATE

/*  *********************************************************************
    *  Prototypes							*
    ********************************************************************* */

int usb_init(u8 *pool,int poolsize);
void usb_uninit(void);
int usb_setmode(int mode);
int usb_getmode(void);
int usb_linktest();
int usb_open(int protocol,int endpoint,int (*func)(EBUF *));
int usb_close(int port);
EBUF *usb_allocbuf(int port);
void usb_freebuf(EBUF *buf);
int usb_transmit(int port,PJBCOMMHANDLE *h,EBUF *buf);
int usb_buflen(EBUF *buf);
void usb_initbuf(EBUF *buf);
int usb_flush(int port);
EBUF *usb_receive(int port,PJBCOMMHANDLE *h,int timeout);

#endif
