/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  Doubly-linked queue routines		File: QUEUE.H		**
   **									**
   **  This module contains routines to manipulate doubly-linked 	**
   **  queues.                                                          **
   **									**
   **  Important note:  These queues don't provide any sort of          **
   **  multi-thread support, but you can easily provide it here.        **
   **                                                                   **
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#ifndef _PW_QUE_H
#define _PW_QUE_H

#ifdef __cplusplus
extern "C" {
#endif

/*  *********************************************************************
    *  Macros								*
    ********************************************************************* */

#define q_init(q) (q)->q_prev = (q), (q)->q_next = (q)
#define q_isempty(q) ((q)->q_next == (q))
#define q_getfirst(q) ((q)->q_next)
#define q_getlast(q) ((q)->q_prev)

/*  *********************************************************************
    *  Types								*
    ********************************************************************* */


typedef struct QBlock {			/* queue block */
	struct QBlock *q_next;
	struct QBlock *q_prev;
	} QBLOCK, *PQBLOCK;


/*  *********************************************************************
    *  Prototypes							*
    ********************************************************************* */

void q_enqueue(QBLOCK *,QBLOCK *);
void q_dequeue(QBLOCK *);
QBLOCK *q_deqnext(QBLOCK *);

unsigned int q_map(QBLOCK *qb,unsigned int (*func)(QBLOCK *,unsigned int,unsigned int),unsigned int a,unsigned int b);

int q_count(QBLOCK *);

int q_find(QBLOCK *,QBLOCK *);

#ifdef __cplusplus
};
#endif

#endif

