/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  PJB Low-level communications defs	File: PJBDEV.H		**
   **									**
   **  This module contains definitions for the interface		**
   **  between the USB module and the low-level USB drivers.		**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#ifndef _PJBCOMMHANDLE_
typedef void * PJBCOMMHANDLE;
#define _PJBCOMMHANDLE_
#endif

typedef struct PjbCommDev {
    PJBCOMMHANDLE * (*pcd_open)(PJB_ID *id);
    void (*pcd_close)(PJBCOMMHANDLE *info);
    int (*pcd_enumerate)(PJB_INFO *ids,int maxids);
    int (*pcd_receive)(PJBCOMMHANDLE *info,unsigned char *buf,int len,int timeout);
    int (*pcd_transmit)(PJBCOMMHANDLE *info,unsigned char *buf,int len);
    long (*pcd_getticks)(void);
    void (*pcd_sleep)(int sec);
    int pcd_debug;
} PJBCOMMDEV;

typedef struct PjbHandleInfo {
    struct PjbInfo *next;
    PJB_ID id;
    PJBCOMMDEV *device;
    PJBCOMMHANDLE *devhandle;
} PJBHANDLEINFO;


extern PJBCOMMDEV *pjbdev;

#define PJBCOMM_OPEN(id) (*pjbdev->pcd_open)(id)
#define PJBCOMM_CLOSE(h) (*pjbdev->pcd_close)(h)
#define PJBCOMM_ENUM(ids,maxids) (*pjbdev->pcd_enumerate)(ids,maxids)
#define PJBCOMM_RECEIVE(h,b,l,t) (*pjbdev->pcd_receive)(h,b,l,t)
#define PJBCOMM_TRANSMIT(h,b,l) (*pjbdev->pcd_transmit)(h,b,l)
#define PJBCOMM_TICKCOUNT() (*pjbdev->pcd_getticks)()
#define PJBCOMM_SLEEP(sec) (*pjbdev->pcd_sleep)(sec)

#define PJBCOMM_TIMEOUT	-1
#define PJBCOMM_DEVERR	-2

