/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  Personal Jukebox RPC API implementation	File: PJBAPI.C		**
   **									**
   **  This module contains most of the "administrative" functions	**
   **  for the Personal Jukebox API.                                    **
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pjbtypes.h"
#include "queue.h"
#include "ebuf.h"
#include "pjbapi.h"
#include "pjbdev.h"
#include "usbctl.h"
#include <malloc.h>
#include <sys/types.h>


/*  *********************************************************************
    *  Statics								*
    ********************************************************************* */

#define BUFPOOLSIZE 16384
static u8 *PJB_bufpool = NULL;

extern int pcli_init(void);

/*  *********************************************************************
    *  PJB_InitLib()							*
    *  									*
    *  Initialize this library.						*
    *  									*
    *  Input parameters: 						*
    *  	   nothing							*
    *  	   								*
    *  Return value:							*
    *  	   TRUE if we're ok, FALSE if not.                              *
    ********************************************************************* */

PJB_DLLEXPORT int PJB_InitLib(void)
{
    int res;

    //
    // If we're asking for USB devices...
    //

    if (PJB_bufpool == NULL) {
        PJB_bufpool = (u8 *) malloc(BUFPOOLSIZE);
        if (!PJB_bufpool) return PJB_ERR_NO_RESOURCES;
        res = usb_init(PJB_bufpool,BUFPOOLSIZE);
	    if (res != 0) {
		free(PJB_bufpool);
		PJB_bufpool = NULL;
		return FALSE;
		}
        }


    //
    // In the case of USB, we don't need to bind
    // before sending packets, so just initialize the
    // client here.
    //

    pcli_init();

    return TRUE;
}


/*  *********************************************************************
    *  PJB_UninitLib()							*
    *  									*
    *  De-initialize this library					*
    *  									*
    *  Input parameters: 						*
    *  	   nothing							*
    *  	   								*
    *  Return value:							*
    *  	   nothing							*
    ********************************************************************* */

PJB_DLLEXPORT void PJB_UninitLib(void)
{

}



/*  *********************************************************************
    *  PJB_GetID(pjb)							*
    *  									*
    *  Given a handle, return the PJB_ID structure that goes		*
    *  with it.								*
    *  									*
    *  Input parameters: 						*
    *  	   pjb - handle							*
    *  	   								*
    *  Return value:							*
    *  	   ID pointer							*
    ********************************************************************* */

PJB_DLLEXPORT PJB_ID *PJB_GetID(PJB_HANDLE pjb)
{
    PJBHANDLEINFO *info = (PJBHANDLEINFO *) pjb;

    return &(info->id);
}



/*  *********************************************************************
    *  PJB_Open(id)							*
    *  									*
    *  Given an ID, return a handle for communication with the		*
    *  specified ID.							*
    *  									*
    *  Input parameters: 						*
    *  	   id - PJB_ID							*
    *  	   								*
    *  Return value:							*
    *  	   PJB_HANDLE, or NULL if the pjb could not be opened		*
    ********************************************************************* */

PJB_DLLEXPORT int PJB_Open(PJB_ID *id,PJB_HANDLE *h)
{
    PJBHANDLEINFO *info;
    int res;

    *h = NULL;

    info = malloc(sizeof(PJBHANDLEINFO));
    if (info == NULL) {
	return PJB_ERR_NO_RESOURCES;
	}

    /* Clear out the info structure */

    memset(info,0,sizeof(PJBHANDLEINFO));

    /* Fill in the 'id' fields */

    memcpy(&(info->id),id,sizeof(PJB_ID));

    /* Try to open usb device. */

    info->devhandle = PJBCOMM_OPEN(id);

    if (info->devhandle == NULL) return PJB_ERR_COMM;

    /* Try to ping the pjb to see if it is alive. */
   
    res = PJB_Ping((PJB_HANDLE) info,32,0);
    if (res == 0) {
	*h = (PJB_HANDLE) info;
	return 0;
	}

    PJBCOMM_CLOSE(info->devhandle);

    free(info);
    return PJB_ERR_COMM;
}


/*  *********************************************************************
    *  PJB_Close(handle)						*
    *  									*
    *  Close a handle to the specified PJB				*
    *  									*
    *  Input parameters: 						*
    *  	   pjb - handle							*
    *  	   								*
    *  Return value:							*
    *  	   nothing							*
    ********************************************************************* */

PJB_DLLEXPORT int PJB_Close(PJB_HANDLE pjb)
{
    PJBHANDLEINFO *info = (PJBHANDLEINFO *) pjb;


    PJBCOMM_CLOSE(info->devhandle);
    free(info);

    return 0;
}

PJB_DLLEXPORT int PJB_SetDebugMode(int mode)
{
    int oldmode = pjbdev->pcd_debug;
    pjbdev->pcd_debug = mode;
    return oldmode;
}
