/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  Routines to manipulate EBUFs		File: EBUF.C		**
   **									**
   **  These routines muck with EBUFs, named so for their ancient	**
   **  Ethernet heritage.  We do most of our communications with	**
   **  the PJB in an EBUF.						**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#include <stdio.h>
#include <sys/types.h>
#include "pjbtypes.h"
#include "queue.h"
#include "ebuf.h"


#ifndef EBUF_MACROS

/*  *********************************************************************
    *  EBUF_ADD_U8(buf,b)						*
    *  									*
    *  Add a byte to an EBUF, incrementing the length			*
    *  									*
    *  Input parameters: 						*
    *  	   ebuf - buffer 						*
    *  	   b - byte to add						*
    * 									*
    *  Return value:							*
    *  	   nothing							*
    ********************************************************************* */

void ebuf_add_u8(EBUF *buf,u8 b)
{
    *(buf->eb_ptr) = b;
    buf->eb_ptr++;
    buf->eb_length++;
}

/*  *********************************************************************
    *  EBUF_ADD_U16(buf,w)						*
    *  									*
    *  Add a 16-bit word to an EBUF, incrementing the length		*
    *  									*
    *  Input parameters: 						*
    *  	   buf - ebuf							*
    *  	   w - word to add						*
    *  	   								*
    *  Return value:							*
    *  	   nothing							*
    ********************************************************************* */

void ebuf_add_u16(EBUF *buf,u16 w)
{
    *(buf->eb_ptr) = w & 0xFF;
    buf->eb_ptr++;
    *(buf->eb_ptr) = (w >> 8) & 0xFF;
    buf->eb_ptr++;
    buf->eb_length += 2;
}

/*  *********************************************************************
    *  EBUF_ADD_U32							*
    *  									*
    *  Add a 32-bit word to teh ebuf, incrementing the length		*
    *  									*
    *  Input parameters: 						*
    *  	   buf - ebuf							*
    *  	   w - dword to add						*
    *  	   								*
    *  Return value:							*
    *  	   nothing							*
    ********************************************************************* */

void ebuf_add_u32(EBUF *buf,u32 w)
{
    *(buf->eb_ptr++) = (u8) (w & 0xFF);
    w >>= 8;
    *(buf->eb_ptr++) = (u8) (w & 0xFF);
    w >>= 8;
    *(buf->eb_ptr++) = (u8) (w & 0xFF);
    w >>= 8;
    *(buf->eb_ptr++) = (u8) (w & 0xFF);
    buf->eb_length += 4;
}
#endif
