/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  Basic type definitions		File: PJBTYPES.H		**
   **									**
   **  This file contains some basic data types used throughout the	**
   **  PJB library code							**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#ifndef _PJBTYPES_H
#define _PJBTYPES_H

#ifdef __cplusplus
extern "C" {
#endif

/*  *********************************************************************
    *  Constants							*
    ********************************************************************* */

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif
#ifndef NULL
#define NULL 0
#endif

#if 0

#ifdef _X86_
#define BITS_PER_CHAR   8
#else
#define BITS_PER_CHAR	24
#endif
#define BITS_PER_BYTE	8
#define BYTES_PER_CHAR  (BITS_PER_CHAR/BITS_PER_BYTE)

/*  *********************************************************************
    *  Macros								*
    ********************************************************************* */

/*  *********************************************************************
    *  Macros								*
    ********************************************************************* */

#define PRIVATE
#define MAKEU16(b1,b2) (((u16)(b1) << 8) | ((u16)(b2)))
#define HIGH_BYTE(x) (((x)>>8) & 0xFF)
#define LOW_BYTE(x)  ((x) & 0xFF)
#define BSWAP(x) ( (((x) & 0xFF) << 8) | (((x) >> 8) & 0xFF))


/* 
 * Extract a byte or a 16-bit word from a packed packet
 */

#define EXTBYTE(buf,offset) ((u_int)( \
    (((buf)[(offset)/BYTES_PER_CHAR]) >>  \
    ((BYTES_PER_CHAR - ((offset)%BYTES_PER_CHAR))*BITS_PER_BYTE)) & 0xFF))

#define EXTWORD16_LOHI(buf,offset) (EXTBYTE(buf,offset) |  \
    (EXTBYTE(buf,(offset)+1)<<BITS_PER_BYTE))
#define EXTWORD16_HILO(buf,offset) ((EXTBYTE(buf,offset)<<BITS_PER_BYTE) |  \
    EXTBYTE(buf,(offset)+1))

#endif

/*  *********************************************************************
    *  Basic types							*
    ********************************************************************* */


typedef unsigned short u16;
typedef unsigned long u32;
typedef unsigned char u8;
#ifndef __linux__
  /*typedef unsigned int u_int;*/
#endif

#ifdef __cplusplus
};
#endif
#endif
