/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  PJB TOC API definitions			File: PJBTOC.H		**
   **									**
   **  constants and definitions for the high-level interface		**
   **  to the PJB's file system.					**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#ifndef _PJBTOC_H
#define _PJBTOC_H

#include "pjbapi.h"
#include "toc.h"
#include "cksum.h"
#include "allocblock.h"

#include "ptrarray.h"
#include "allocmap.h"
#include "mp3reader.h"

typedef struct PjbToc {
    PJB_HANDLE pjb;                   /* Handle to actual PJB */
    PJB_INFO  info;
    PJB_DiskInfo diskinfo;
    TOC_Ctx *toc;
    ALLOCMAP *allocmap;
    int modified;
} PJBTOC;

/* Note: specify TRUE for 'readtoc' except for flash update mode */
int PJBTOC_OpenPjb(int idx,PJBTOC **tptr,int readtoc);
void PJBTOC_Close(PJBTOC *t);
int PJBTOC_WalkTree(PJBTOC *t,int (*func)(PJBTOC *t,JNode n,void *arg),
		    void *arg);
int PJBTOC_DeleteNode(PJBTOC *t,JNode node);
JNode PJBTOC_CreateSet(PJBTOC *t,JInsertPt *ins,char *text);
JNode PJBTOC_CreateDisc(PJBTOC *t,JInsertPt *ins,char *text);
int PJBTOC_WriteTrack(PJBTOC *t,JNode n,JInsertPt *ins,
		      int (*readfunc)(PJBTOC *t,u8 *buffer,long len,
				      long *numread,void *arg),
		      void *arg,
		      char *id3Tag);
JNode PJBTOC_FindDisc(PJBTOC *t,JNode setnode,char *text,int create);
JNode PJBTOC_FindSet(PJBTOC *t,char *text,int create);
int PJBTOC_FlushJukebox(PJBTOC *t);

int PJBTOC_UpdateFlash(PJBTOC *t,char *filename,int execute);
int PJBTOC_Reboot(PJBTOC *t,int maincode);




#endif
