/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  MP3 File Reader definitions		File: MP3READER.H	**
   **									**
   **  This library file contains routines to walk through MP3 files 	**
   **  and extract key information such as ID3 tags, bitrate, etc.	**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/



/*  *********************************************************************
    *  Constants							*
    ********************************************************************* */

#define MAX_TAG_SIZE 128

#define MP3TAG_ID3V1	1
#define MP3TAG_ID3V2	2

#ifndef MP3READER_ERR_FORMAT
// MP3 file errors
#define MP3READER_ERR_FORMAT		60
#define MP3READER_ERR_VBR			61
#define MP3READER_ERR_LAYER		62
#define MP3READER_ERR_MALFORMED	63
#define MP3READER_ERR_OPEN	64
#endif



/*  *********************************************************************
    *  Structures							*
    ********************************************************************* */

typedef struct MP3Reader {

    u8 id3v1tag[129];
    char *tag_genre;
    char *tag_album;
    char *tag_artist;
    char *tag_title;

#ifdef __WIN32__
    void *filehandle;
    void *maphandle;
#else
    int filehandle;
#endif

    u8 *membase;
    int open;
    unsigned long filelength;

    u8 *mp3start;
    u8 *mp3end;
    unsigned long mp3length;
    u8 *mp3ptr;

    unsigned int tagtypes;

    unsigned long playtime75;
    unsigned long totalframes;
    int bitRate;
    int vbr;
} MP3READER;


/*  *********************************************************************
    *  Prototypes							*
    ********************************************************************* */


MP3READER *MP3Create(void);
void MP3Destroy(MP3READER *);

int MP3Open(MP3READER *,char *filename, int noparse);
void MP3Close(MP3READER *);
int MP3Read(MP3READER *,u8 *buf,int length);
int MP3ParseMP3(MP3READER *);

#define MP3IsVBR(rdr) ((rdr)->vbr)
#define MP3GetBitRate(rdr) ((rdr)->bitRate*1000)
#define MP3GetPlayTime(rdr) ((rdr)->playtime75/75)
#define MP3GetPlayTime75(rdr) ((rdr)->playtime75)
#define MP3GetFileLength(rdr) ((rdr)->mp3length)
#define MP3GetTag(rdr) ((rdr)->id3v1tag)
#define MP3IsTagged(rdr) ((rdr)->tagtypes)
#define MP3GetID3Tag(rdr) ((rdr)->id3v1tag)
#define MP3GetGenre(rdr) ((rdr)->tag_genre)
#define MP3GetAlbum(rdr) ((rdr)->tag_album)
#define MP3GetArtist(rdr) ((rdr)->tag_artist)
#define MP3GetTitle(rdr) ((rdr)->tag_title)
