/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  Definitions for the bitmap class		File: BITMAP.H		**
   **									**
   **  Constants and structures for the bitmap class 			**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#ifndef __TOCBITMAP_H__
#define __TOCBITMAP_H__

typedef unsigned long TocBitmapElem;

#define BITS_PER_ELEM   (8 * sizeof(TocBitmapElem))

typedef struct TocBitmap {

	TocBitmapElem	*map;
	int		nMaxBits;
	int		nElems;
	int		allocHint;
} TOCBITMAP;


TOCBITMAP *TocBitmapCreate(int nbits);
void TocBitmapDestroy(TOCBITMAP *bitmap);
void TocBitmapReset(TOCBITMAP *);
int TocBitmapAlloc(TOCBITMAP *);
void TocBitmapSet(TOCBITMAP *,int);
void TocBitmapClear(TOCBITMAP *,int);
int TocBitmapIsSet(TOCBITMAP *,int);

#endif
