/*
   ***********************************************************************
   **  Compaq Personal Jukebox						**
   **									**
   **  Allocation Map constants and defs  	File: ALLOCMAP.H	**
   **									**
   **  Constants and structures for the Allocation Map class, which	**
   **  describes the allocated space in the PJB's file system		**
   **									**
   **  Authors: Compaq Corporate Research                               **
   **									**
   ***********************************************************************
   **                                                                   **
   ** Copyright (C) 2000 by Compaq Computer Corporation                 **
   **                                                                   **
   ** This program is free software; you can redistribute it and/or     **
   ** modify it under the terms of the GNU General Public License       **
   ** as published by the Free Software Foundation; either version 2    **
   ** of the License, or (at your option) any later version.            **
   **                                                                   **
   ** This program is distributed in the hope that it will be useful,   **
   ** but WITHOUT ANY WARRANTY; without even the implied warranty of    **
   ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     **
   ** GNU General Public License for more details.                      **
   **                                                                   **
   ** You should have received a copy of the GNU General Public License **
   ** along with this program; if not, write to the Free Software       **
   ** Foundation, Inc., 59 Temple Place - Suite 330,                    **
   ** Boston, MA  02111-1307, USA.                                      **
   **                                                                   **
   ***********************************************************************
*/

#ifndef __ALLOCMAP_H
#define __ALLOCMAP_H	1

#include "bitmap.h"

typedef long AllocMap_Block;

// Each newly allocated block is linked via an in-memory
// data structure so that a previously allocated block can
// always be found from its successor (given that its successor
// has not been freed).

// These chains of allocations could be made transaction-specific,
// allowing or multi-threading, but we don't need that.

typedef struct _ChainSegment {
	AllocMap_Block	start;
	int				nblocks;
	AllocMap_Block	link;		// backwards to next elem in chain
} ChainSegment;


typedef struct AllocMap {
	int	exists;
	long	nFreeBlocks;
	long	nTotalBlocks;
	PTRARRAY *chain;
	TOCBITMAP *bitmap;
	ChainSegment *lastSeg;
} ALLOCMAP;


void AMapReset(ALLOCMAP *);
int AMapRebuild(ALLOCMAP *,AllocMap_Block start,
		int n,AllocMap_Block prev);
void AMapFinishRebuild(ALLOCMAP *);
int AMapInput(ALLOCMAP *,TOC_IOBuf *bf);
void AMapOutput(ALLOCMAP *,TOC_IOBuf *bf);
AllocMap_Block AMapAlloc(ALLOCMAP *);
int AMapFollowChain(ALLOCMAP *,
		    AllocMap_Block blk,
		    AllocMap_Block* startBlock,
		    AllocMap_Block* nextSegTail);

int  AMapFreeChain(ALLOCMAP *a,
		   AllocMap_Block end,
		   AllocMap_Block start,
		   int free_end,
		   int free_start);

ALLOCMAP *AMapCreate(long nblocks);
void AMapDestroy(ALLOCMAP *);


#endif
