unit xqueryip;
(* With this unit, TxQuery can be used with InfoPower.
You need to have InfoPower 3.01 or later (tested with InfoPower 4)
download from Woll2Woll website at http://www.woll2woll.com
New: Infopower 2000 doesn't need this *)

Interface

uses
  SysUtils,
  WinTypes,
  WinProcs,
  Classes,
  wwtypes,
  xquery;

Type
  TwwXQuery =  class( TxQuery )
    Private
      FControlType    : TStrings;
      FPictureMasks   : TStrings;
      FUsePictureMask : boolean;
      FOnInvalidValue : TwwInvalidValueEvent;

      Function GetControlType : TStrings;
      Procedure SetControlType( sel : TStrings );
      Function GetPictureMasks : TStrings;
      Procedure SetPictureMasks( sel : TStrings );

    Protected
      Procedure DoBeforePost; Override; { For picture support }

    Public
      Constructor Create( AOwner : TComponent ); Override;
      Destructor Destroy; Override;

    Published
      Property ControlType : TStrings Read  GetControlType Write setControltype;
      Property PictureMasks: TStrings Read GetPictureMasks Write SetPictureMasks;
      Property ValidateWithMask : boolean Read FUsePictureMask Write FUsePictureMask;
      Property OnInvalidValue: TwwInvalidValueEvent Read FOnInvalidValue Write FOnInvalidValue;
  end;

Procedure Register;

implementation
uses
  wwcommon, dbconsts;


Constructor TwwXQuery.create( AOwner : TComponent );
begin
  inherited Create( AOwner );
  FControlType    := TStringList.create;
  FPictureMasks   := TStringList.create;
  FUsePictureMask := True;
end;


Destructor TwwXQuery.Destroy;
begin
  FControlType.Free;
  FPictureMasks.Free;
  FPictureMasks:= NIL;
  Inherited Destroy;
end;


Function TwwXQuery.GetControltype : TStrings;
begin
  Result := FControlType;
end;


Procedure TwwXQuery.SetControlType( sel : TStrings );
begin
  FControlType.Assign( sel );
end;


Function TwwXQuery.GetPictureMasks : TStrings;
begin
  Result:= FPictureMasks
end;


Procedure TwwXQuery.SetPictureMasks( sel : TStrings );
begin
  FPictureMasks.Assign( sel );
end;

Procedure TwwXQuery.DoBeforePost;
begin
  Inherited DoBeforePost;
  if FUsePictureMask then
     wwValidatePictureFields( self, FOnInvalidValue );
end;


Procedure Register;
begin
  RegisterComponents('IP Access', [TwwXQuery] );
end;

end.



