// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'prExprQ.pas' rev: 4.00

#ifndef prExprQHPP
#define prExprQHPP

#pragma delphiheader begin
#pragma option push -w-
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Prexprq
{
//-- type declarations -------------------------------------------------------
typedef int prInteger;

#pragma option push -b-
enum TExprType { ttString, ttFloat, ttInteger, ttBoolean, ttUnknown };
#pragma option pop

class DELPHICLASS TExpression;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TExpression : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	virtual AnsiString __fastcall GetAsString();
	virtual double __fastcall GetAsFloat(void);
	virtual int __fastcall GetAsInteger(void);
	virtual bool __fastcall GetAsBoolean(void);
	virtual TExprType __fastcall GetExprType(void) = 0 ;
	
public:
	__property AnsiString AsString = {read=GetAsString};
	__property double AsFloat = {read=GetAsFloat};
	__property int AsInteger = {read=GetAsInteger, nodefault};
	__property bool AsBoolean = {read=GetAsBoolean, nodefault};
	__property TExprType ExprType = {read=GetExprType, nodefault};
	bool __fastcall CanReadAs(TExprType aExprType);
	__fastcall TExpression(void);
	__fastcall virtual ~TExpression(void);
};

#pragma pack(pop)

class DELPHICLASS TStringLiteral;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TStringLiteral : public TExpression 
{
	typedef TExpression inherited;
	
private:
	AnsiString FAsString;
	
protected:
	virtual AnsiString __fastcall GetAsString();
	virtual TExprType __fastcall GetExprType(void);
	
public:
	__fastcall TStringLiteral(AnsiString aAsString);
public:
	#pragma option push -w-inl
	/* TExpression.Destroy */ inline __fastcall virtual ~TStringLiteral(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TFloatLiteral;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TFloatLiteral : public TExpression 
{
	typedef TExpression inherited;
	
private:
	double FAsFloat;
	
protected:
	virtual AnsiString __fastcall GetAsString();
	virtual double __fastcall GetAsFloat(void);
	virtual TExprType __fastcall GetExprType(void);
	
public:
	__fastcall TFloatLiteral(double aAsFloat);
public:
	#pragma option push -w-inl
	/* TExpression.Destroy */ inline __fastcall virtual ~TFloatLiteral(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TIntegerLiteral;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TIntegerLiteral : public TExpression 
{
	typedef TExpression inherited;
	
private:
	int FAsInteger;
	
protected:
	virtual AnsiString __fastcall GetAsString();
	virtual double __fastcall GetAsFloat(void);
	virtual int __fastcall GetAsInteger(void);
	virtual TExprType __fastcall GetExprType(void);
	
public:
	__fastcall TIntegerLiteral(int aAsInteger);
public:
	#pragma option push -w-inl
	/* TExpression.Destroy */ inline __fastcall virtual ~TIntegerLiteral(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TBooleanLiteral;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TBooleanLiteral : public TExpression 
{
	typedef TExpression inherited;
	
private:
	bool FAsBoolean;
	
protected:
	virtual AnsiString __fastcall GetAsString();
	virtual double __fastcall GetAsFloat(void);
	virtual int __fastcall GetAsInteger(void);
	virtual bool __fastcall GetAsBoolean(void);
	virtual TExprType __fastcall GetExprType(void);
	
public:
	__fastcall TBooleanLiteral(bool aAsBoolean);
public:
	#pragma option push -w-inl
	/* TExpression.Destroy */ inline __fastcall virtual ~TBooleanLiteral(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TParameterList;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TParameterList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	AnsiString __fastcall GetAsString(int i);
	double __fastcall GetAsFloat(int i);
	int __fastcall GetAsInteger(int i);
	bool __fastcall GetAsBoolean(int i);
	TExprType __fastcall GetExprType(int i);
	TExpression* __fastcall GetParam(int i);
	
public:
	__fastcall virtual ~TParameterList(void);
	__property TExpression* Param[int i] = {read=GetParam};
	__property TExprType ExprType[int i] = {read=GetExprType};
	__property AnsiString AsString[int i] = {read=GetAsString};
	__property double AsFloat[int i] = {read=GetAsFloat};
	__property int AsInteger[int i] = {read=GetAsInteger};
	__property bool AsBoolean[int i] = {read=GetAsBoolean};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TParameterList(void) : Classes::TList() { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TFunction;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TFunction : public TExpression 
{
	typedef TExpression inherited;
	
private:
	TParameterList* FParameterList;
	TExpression* __fastcall GetParam(int n);
	
public:
	__fastcall TFunction(TParameterList* aParameterList);
	__fastcall virtual ~TFunction(void);
	int __fastcall ParameterCount(void);
	__property TExpression* Param[int n] = {read=GetParam};
};

#pragma pack(pop)

class DELPHICLASS EExpression;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION EExpression : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EExpression(const AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EExpression(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EExpression(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EExpression(int Ident, const System::TVarRec * Args, 
		const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EExpression(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EExpression(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EExpression(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EExpression(int Ident, const System::TVarRec * Args
		, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EExpression(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

typedef TExpression* __fastcall (__closure *TIdentifierFunction)(const AnsiString Identifier, TParameterList* 
	ParameterList);

typedef AnsiString prExprQ__9[5];

//-- var, const, procedure ---------------------------------------------------
static const Byte MaxStringLength = 0xff;
extern PACKAGE AnsiString NExprType[5];
extern PACKAGE int InstanceCount;
extern PACKAGE bool HasFunctions;
extern PACKAGE TExpression* __fastcall CreateExpression(const AnsiString S, TIdentifierFunction IdentifierFunction
	);

}	/* namespace Prexprq */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Prexprq;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// prExprQ
