
unit YacclibQ;

(* Yacc Library Unit for TP Yacc Version 3.0, 6-17-91 AG *)
(* adapted to Delphi 3 by Thierry Coq, 20/9/97 *)

{$I XQ_FLAG.INC}
interface

uses Classes, Dialogs, LexLibQ;

const yymaxdepth = 2048;
  (* default stack size of parser *)

type
  YYSType = Integer;
  TYYFlag = ( yyfnone, yyfaccept, yyfabort, yyferror );

  (* default value type, may be redefined in Yacc output file *)
  TCustomParser = Class( TObject )
    public
      yychar    : Integer; (* current lookahead character *)
      yynerrs   : Integer; (* current number of syntax errors reported by the
                             parser *)
      yydebug   : Boolean; (* set to true to enable debugging output of parser *)

      // The parser is not responsible for the Lexer's construction/destruction :
      yyLexer   : TCustomLexer; (* Lexer used to lex input *)

      yyerrormsg: String;        (* Last error message in string format *)

      procedure yyerror ( const msg : String ); virtual;
        (* error message printing routine used by the parser *)

      procedure yyclearin;
        (* delete the current lookahead token *)

      procedure yyaccept;
        (* trigger accept action of the parser; yyparse accepts returning 0, as if
           it reached end of input *)

      procedure yyabort;
        (* like yyaccept, but causes parser to return with value 1, as if an
           unrecoverable syntax error had been encountered *)

      procedure yyerrlab;
        (* causes error recovery to be started, as if a syntax error had been
           encountered *)

      procedure yyerrok;
        (* when in error mode, resets the parser to its normal mode of
           operation *)

      function yyparse : integer; virtual; abstract;

      (* Flags used internally by the parser routine: *)

    protected
      yyerrflag : Integer;
      yyflag    : TYYFlag;
  end; (* TCustomParser *)

implementation

uses
   xqMiscel;

procedure TCustomParser.yyerror ( const msg : String );
begin
    yyerrormsg := msg;
    //MessageToUser( msg, mtError );
end;

procedure TCustomParser.yyclearin;
begin
   yychar := -1;
end(*yyclearin*);

procedure TCustomParser.yyaccept;
begin
  yyflag := yyfaccept;
end(*yyaccept*);

procedure TCustomParser.yyabort;
begin
  yyflag := yyfabort;
end(*yyabort*);

procedure TCustomParser.yyerrlab;
begin
  yyflag := yyferror;
end(*yyerrlab*);

procedure TCustomParser.yyerrok;
begin
  yyerrflag := 0;
end(*yyerrork*);

end(*YaccLib*).
