#ifndef _gwmail32h_
#define _gwmail32h_

//
// C/C++ include file for Greyware Mail DLL
//

#define     ERROR_SMTP_RCPT_REJECTED        970001
#define     ERROR_SMTP_HOST_UNAVAIL         970002
#define     ERROR_SMTP_GREETING_REJECTED    970003
#define     ERROR_SMTP_MAILFROM_REJECTED    970004
#define     ERROR_SMTP_DATA_REJECTED        970005
#define     ERROR_SMTP_LOST_CONNECTION      970006
#define     ERROR_SMTP_QUIT_REJECTED        970007

#define     ERROR_POP3_CONNECT_ERROR        980001
#define     ERROR_POP3_USER_REJECTED        980002
#define     ERROR_POP3_PASSWORD_REJECTED    980003
#define     ERROR_POP3_NO_MAIL              980004
#define     ERROR_POP3_DELETE_REJECTED      980005
#define     ERROR_POP3_LOST_CONNECTION      980006
#define     ERROR_POP3_QUIT_REJECTED        980007

//
// Valid settings for the dwEncoding parameter in
// SendSMTPEx.  Downsized versions of SendSMTPEx
// always use ENCODING_AUTO.
//

#define     ENCODING_AUTO       0       // to let DLL determine encoding
#define     ENCODING_DEFAULT    0       // synonym
#define     ENCODING_TEXT       1       // to force plain text (no encoding)
#define     ENCODING_UUENCODE   2       // to force UUENCODE
#define     ENCODING_BASE64     3       // to force MIME Base64 encoding
#define     ENCODING_MIME       3       // synonym

/*
    
    Explanation of parameters for POP3 functions
    
    LPSTR szPOP3Host
    
        Name or IP address of POP3 host from which
        to retrieve mail.  Format may be "machine.domain.dom"
        or "123.123.123.123"  Required.

    LPSTR szUsername

        Pointer to POP3 account username.  Required.

    LPSTR szPassword

        Pointer to POP3 account password.  Required.
        May be blank (but not NULL).

    LPSTR szFilename

        Pointer to full path and filename of file to
        receive POP3 mail.  File is overwritten if it
        already exists, or created otherwise.  File is
        deleted if errors are encountered during the
        retrieval.

    BOOL bDelete

        TRUE if mail should be deleted after being
        successfully retrieved.  FALSE if mail is to be
        left on server.  (Note:  Some servers automatically
        delete mail after it is retrieved; this parm
        cannot change that behavior).


    Explanation of parameters for SMTP functions

    LPSTR szSMTPHost

        Name or IP address of SMTP host used to send
        the mail.  Format may be "machine.domain.dom"
        or "123.123.123.123"  Required.

    LPSTR szFrom
    
        Email address of originator.  Required.

    LPSTR szTo
    
        Email address of recipient.  Required.  May
        include multiple addresses separated by commas.

    LPSTR szCC

        Email address of CC recipient.  May be NULL.
        May include multiple addresses separated by
        commas.

    LPSTR szBCC
        
        Email address of BCC recipient.  May be NULL.
        May include multiple addresses separated by
        commas.

    LPSTR szSubject

        Subject of the email.  May be NULL.  If NULL
        and a file is attached, the subject will
        reflect the filename.  If no file is attached
        and szSubject is NULL, the subject will
        read "(no subject)".

    LPSTR szErrorsTo

        Email address for SMTP "Errors-To" header.
        If NULL, this header defaults to szFrom.

    LPSTR szReplyTo
    
        Email address for SMTP "Reply-To" header.
        If NULL, this header defaults to szFrom.

    LPSTR szMessage

        Body of the letter.  Required unless a file
        will be attached (see the szFilename parm).

    LPSTR szFilename

        Full path of file to be attached to the
        letter.  If NULL, no file is attached and
        szMessage must be non-NULL.

    BOOL  bUseDOSName

        If TRUE and szFilename is non-NULL, the
        attachment's file name will be truncated
        and upper-cased for 8.3 compatibility.
        If FALSE, the attachment's file name
        will be the same as szFilename.
        
    DWORD dwEncoding

        Ignored if szFilename is NULL.  If szFilename is
        non-NULL, this value must be one of the following
        constants (as defined above):

        ENCODING_AUTO lets the DLL determine the appropriate
        encoding method to use.  If the file appears to be
        plain text, the file is appended to the body of the
        letter as plain text.  If the file appears to be
        binary, it is UUENCODED and appended as an attachment.
        
        ENCODING_TEXT forces the DLL to append the contents
        of the file as plain text, regardless of the contents.

        ENCODING_UUENCODE forces the DLL to UUENCODE the file
        and append it as an attachment, regardless of the
        contents.

        ENCODING_BASE64 forces the DLL to encode the file
        using MIME/Base64 encoding and append it as an
        attachment, regardless of the contents.

*/


//
// This is the main function exported by the DLL.
// Use it when you need complete control over every
// option
//

DWORD WINAPI SendSMTPEx (
    LPSTR   szSMTPHost,         // required
    LPSTR   szFrom,             // required
    LPSTR   szTo,               // required
    LPSTR   szCC,               // optional
    LPSTR   szBCC,              // optional
    LPSTR   szSubject,          // optional
    LPSTR   szErrorsTo,         // optional
    LPSTR   szReplyTo,          // optional
    LPSTR   szMessage,          // required for text letters
    LPSTR   szFilename,         // required for attached files
    BOOL    bUseDOSName,        // 
    DWORD   dwEncoding);        // 


//
// This is a downsized version of SendSMTPEx,
// useful for sending messages or files with
// intelligent defaults
//

DWORD WINAPI SendSMTP(
    LPSTR   szSMTPHost,
    LPSTR   szFrom,
    LPSTR   szTo,
    LPSTR   szSubject,
    LPSTR   szMessage,
    LPSTR   szFilename);

//
// This is a downsized version of SendSMTPEx,
// useful for sending just messages.
//

DWORD WINAPI SendSMTPMessage(
    LPSTR   szSMTPHost,
    LPSTR   szFrom,
    LPSTR   szTo,
    LPSTR   szSubject,
    LPSTR   szMessage);

//
// This is a downsized version of SendSMTPEx,
// useful for sending just files.
//

DWORD WINAPI SendSMTPFile(
    LPSTR   szSMTPHost,
    LPSTR   szFrom,
    LPSTR   szTo,
    LPSTR   szFilename);

//
// This routine formats an error code into an error
// message.  Provide a buffer of at least 128 characters.
//

BOOL WINAPI GWMailFormatMessage(
    DWORD   dwErrorCode,        // error code to be translated
    LPSTR   szResult,           // buffer for result string
    DWORD   dwResultLength);    // size of szResult buffer


//
// This routine retrieves the first available POP3 message
//

DWORD WINAPI GetPOP3
(
    LPSTR       szPOP3Host,
    LPSTR       szUsername,
    LPSTR       szPassword,
    BOOL        bDelete,
    LPSTR       szFilename);

#endif

//
// end of GWMail32 include file
//
