<tame library_payment_method: DMRPAY>
<tame define_pay:: payment_text DMR CREDIT CARD SERVICE>
<tame define_pay:: payment_libraries ~ecs/paycards.lib ~libdir/dmrpay.lib>
<tame> define_pay:: initialize_payment
	<tame>
	standard_initialize_payment;
	card_initialize_payment;
	</tame>
</tame>
<tame> define_pay:: verify_payment
	<tame>
	dmr_verify;
	when: {&dmr_return == 1} {paymsg: DMR payment processing center offline};
	when: {&dmr_return == 2} {paymsg: Information invalid};
	when: {&dmr_return == 3} {paymsg: The request was declined};
	when: {&dmr_return == 5} {paymsg: Duplicate login};
	when: {&dmr_return == 6} {paymsg: Invalid credit card number};
	when: {&dmr_return == 7} {paymsg: Invalid credit card expiration date};
	when: {&dmr_return == 8} {paymsg: The request was declined because credit card account is overlimit};
   when: {&dmr_return == 9} {paymsg: The credit card bank is temporarily out of service};
	when: {&dmr_return == 10} {paymsg: The request was declined because the credit card number does not match the address};
	when: {&dmr_return == 202} {paymsg: Invalid command};
	when: {&dmr_return == 203} {paymsg: Invalid login};
	when: {&dmr_return == 204} {paymsg: Invalid country name};
	when: {&dmr_return == 205} {paymsg: Invalid service ID};
	when: {&dmr_return == 206} {paymsg: Invalid credit card number};
	when: {&dmr_return == 207} {paymsg: Invalid credit card expiration date};
	when: {&dmr_return == 208} {paymsg: Invalid telephone number};
	when: {&dmr_return == 209} {paymsg: Invalid name};
	when: {&dmr_return == 210} {paymsg: Invalid street address};
	when: {&dmr_return == 211} {paymsg: Invalid city};
	when: {&dmr_return == 212} {paymsg: Invalid state};
	when: {&dmr_return == 213} {paymsg: Invalid zip/postal code};
	when: {&dmr_return == 214} {paymsg: Invalid password};
	when: {&dmr_return == 215} {paymsg: Invalid e-mail address};
	when: {&dmr_return == 216} {paymsg: Invalid age};
	when: {&dmr_return == 217} {paymsg: Invalid membership type};
	when: {&dmr_return == 300} {paymsg: Invalid response from WEB800 server};
	when: {&dmr_return == 800} {paymsg: Processing system failure};
	when: {&dmr_return >= 900 and <= 908} {paymsg: Unable to connect to WEB800 server};
	</tame>
</tame>

<tamecase main>
<tame when_payment_failed:: {show_panel: payfail.pan}<p>>
<tame>
when_allow_tables::
<tame form>
<center>
<table border={panel_border} width=95%>
<TR><TH colspan=3 bgcolor="#C0D0C0">PAY BY CREDIT CARD <i>with</i> WEB800{*tm*} Payment Service</TH></TR>
<TR><TH colspan=2>Cardholder Information</TH><TH>Cards Accepted</TH></TR>
<tame> when:: {&email}
<TR><TD align=center>Name</TD><TD>{text: p_name 35}</TD><TD align=center rowspan=2><b><font face="Arial">Visa<br>MasterCard<br>American Express</font></b></TD></TR>
<TR><TD align=center>Address</TD><TD>{text: p_addr 35}</TD></TR>
</tame>
<tame> when_not:: {&email}
<TR><TD align=center>Email</TD><TD>{text: email 35}</TD><TD align=center>{select: p_cardtype {&card_types}}</TD></TR>
<TR><TD align=center>Name</TD><TD>{text: p_name 35}</TD><TD align=center rowspan=5><b>TOTAL<br>CHARGE<br>{cur. &total}</b></TD></TR>
<TR><TD align=center>Address</TD><TD>{text: p_addr 35}</TD></TR>
</tame>
<TR><TD align=center>City</TD><TD>{text: p_city 35}</TD><TD align=center rowspan=3><b>TOTAL<br>CHARGE<br>{cur. &total}</b></TD></TR>
<TR><TD align=center>State/Province</TD><TD>{text: p_state 35}</TD></TR>
<TR><TD align=center>Zip/Postal Code</TD><TD>{text: p_zip 35}</TD></TR>
<TR><TD align=center>Phone</TD><TD>{text: p_phone 35}</TD><TD align=center>Age {text: p_age 3}</TD></TR>
<TR><TD align=center>
Card Number</TD><TD colspan=2>{text: p_card_txt 21} Exp: {select: p_month_txt {&card_months}} / {select: p_year_txt {&card_years}}<br>
</TD></TR>
<TR><TD align=center colspan=3>
<font face="Arial"><b><i>Your charge will appear as</i> Dakota Mktng<i> on your statement.</i></b></font>
</TD></TR>
<TR><TD colspan=3 bgcolor="#6070F0" align=center>
{tb: {^pay: I authorize this charge to my credit card.}}
</TD></TR>
</table></center>
<tame /form>
</tame>

<tame>
when_not_allow_tables::
{form}
<center>PAY BY CREDIT CARD</center>
<pre><br>
      Card type {select: p_cardtype {&card_types}} TOTAL CHARGE {cur. &total}
           Name {text: p_name 35}
        Address {text: p_addr 35}
           City {text: p_city 35}
          State {text: p_state 35}
Zip/Postal Code {text: p_zip 35}
    Card Number {text: p_card_txt 21} Exp: {select: p_month_txt {&card_months}} / {select: p_year_txt {&card_years}}
</pre>
<center>{^pay: I authorize this charge to my credit card.}</center>
{/form}
</tame>
</tamecase>

<tamecase wait>
</tamecase>
