{; ---------------------------------------------------------------------------
; This is an example payment panel that can be shown using show_panel.  It
; covers making a credit card payment panel which is one of the most complex
; types.  Other payment methods are made similarly by eliminating unneeded
; features.
;
;
; The payment process has five (5) basic steps.
;
; 1) Initialize information that will be shown on the panel.
;
; 2) Show the payment panel.
;
; 3) Validate information submitted from the panel.
;
; 4) Log the order, send out emails, and clear the cart.
;
; 5) Show the receipt.
;
; When validation in step 3 fails, a reason message is printed and the
; process returns to step 2.
;
; ---------------------------------------------------------------------------- }

{; ---------------------------------------------------------------------------
; Every payment method has a method name used to make all it's processing unique
; to that method.  The first tag in a payment method is the library_payment_method
; tag which sets up the method name for the payment method. The method name must
; be a single word without spaces inside it.
;
; Syntax: library_payment_method: METHOD-NAME
; ---------------------------------------------------------------------------- }

<tame> library_payment_method: CREDIT_CARD </tame>

{; ---------------------------------------------------------------------------
; Next, the define_pay tag is used to define the actions for steps 1, 2, 3, and
; 4.
;
; Syntax: define_pay:: PAYMENT-ACTION HTML-AREA
;
;	PAYMENT-ACTION = The name of the payment action step to define.
;	HTML-AREA = An area to place the actions. The actions are usually inside
;		tame code areas inside the HTML-AREA.
;
; This example uses all of the define_pay definitions.  For simpler payment
; methods such as "pay by mail" any unnecessary definitions can be left out.
; ---------------------------------------------------------------------------- }

{; ---------------------------------------------------------------------------
; The "payment_text" definition defines the text that will appear on the
; receipt to identify the payment method.
; ---------------------------------------------------------------------------- }

<tame> define_pay:: payment_text CREDIT CARD </tame>

{; ---------------------------------------------------------------------------
; The "payment_libraries" definition accepts a list of libraries that will
; be included for the payment method.  The ~ecs/paycards.lib contains
; routines to validate credit card checksum's, expiration dates, etc.
; ---------------------------------------------------------------------------- }

<tame> define_pay:: payment_libraries ~ecs/paycards.lib </tame>

{; ---------------------------------------------------------------------------
; The "initialize_payment" definition performs initialization for the payment
; method.
;
; standard_initialize_payment is a routine that transfers the values from the
; normal customer variables to the payment customer variables so that the
; payment can be made by a different person than the order if desired.
; Specifically, these variables are transferred.
;	&p_email = &email
;	&p_name = &name
;	&p_addr = &addr
;	&p_addr2 = &addr2
;	&p_city = &city
;	&p_state = &state
;	&p_zip = &zip
;	&p_country = &country
;	&p_phone = &phone
;
;
; card_initialize_payment is in the paycards.lib and performs these actions:
; * Relink to this page using SSL if the webserver and browser can do SSL.
; * Put the credit card number in the variable &p_card_text
; * Set &card_types from payments.tag or to the defaults.
; * Set &card_years from payments.tag or to the defaults.
; * Set &card_months from payments.tag or to the defaults.
; ---------------------------------------------------------------------------- }

<tame> define_pay:: initialize_payment
	<tame> standard_initialize_payment </tame>
	<tame> card_initialize_payment </tame>
</tame>

{; ---------------------------------------------------------------------------
; The "verify_payment" definition defines the validation for the payment method.
;
; The when and when_not tags are general tame tags that do action when a
; tested condition is true.
;
; Syntax: when: {TEST} HTML-AREA
;
; The paymsg tag puts the given message in the list of messages to be displayed
; if any of the validations fail.
;
; valid_checksum checks the checksum on a card for validity, puts the pure card
; number (without spaces, dashes, etc) into &p_number, and puts a validation
; failure message in &ccvmsg.
;
; valid_expire translates the month text and the year text into numbers and
; checks that the number is a valid expiration date.
;
; You can add as many different validations on the payment method here as
; needed.  There must be a paymsg for every possible validation failure in
; order for the panel logic to cycle correctly on a failure.
;
; ---------------------------------------------------------------------------- }

<tame> define_pay:: verify_payment
	<tame> when_not: {valid_checksum: {&p_card_txt}} {paymsg: {&ccvmsg}} </tame>
	<tame> when_not: {valid_expire: {&p_month_txt} {&p_year_txt}} {paymsg: invalid or missing expiration date} </tame>
	<tame> when_not: {&p_name}   {paymsg: missing name on account} </tame>
	<tame> when_not: {&p_addr}   {paymsg: missing street address} </tame>
	<tame> when_not: {&p_city}   {paymsg: missing city} </tame>
	<tame> when_not: {&p_state}  {paymsg: missing state} </tame>
	<tame> when_not: {&p_zip}    {paymsg: missing zip code} </tame>
</tame>

{; ---------------------------------------------------------------------------
; The "complete_payment" definition defines the action that is taken to
; complete the payment when no validations fail.  If a validation fails,
; the page reloads and displays the failure reasons give in verify_payment.
;
; log_card_receipt is in paycards.lib and creates a payment record in the shop
; mirror file invpmt.tab.
;
; send_card_receipt creates the credit card receipt email and sends it.  Also
; puts a copy of the receipt in the mirror/orders directory if configured to
; do so in the shop payments admin.
;
; The cart is cleared and invoice emails are sent automatically in this step
; as they are configured in the shop payments admin.
;
; The default receipt screen is receipt.pan shown by the ~ecs/receipt.tam page.
; To specify a different receipt for the payment method, use the set_receipt
; tag inside the complete_payment definition.
;
; Example:  <tame> set_receipt: myreceipt.tam </tame>
; ---------------------------------------------------------------------------- }

<tame> define_pay:: complete_payment
	<tame> log_card_receipt </tame>
	<tame> send_card_receipt </tame>
</tame>

{; ---------------------------------------------------------------------------
; The following line is the first line in the this payment method panel that
; is actually displayed.
; The payment_failed_message displays the payfail.pan when one or more
; validations fail showing the reasons for failure.  When the panel displays,
; the HTML-AREA argument is also displayed giving a place to put spacing etc.
; ---------------------------------------------------------------------------- }

<tame> payment_failed_message: <p> </tame>

{; ---------------------------------------------------------------------------
;
; Here follows the actual panel that is displayed as the payment method.
;
; Payment methods must be inside tame form areas.
; The submit button of a payment method must always be the ^pay button.
;
; Syntax: ^pay: BUTTON-FACE-AREA
;
; ---------------------------------------------------------------------------- }

<tame form>

<h2>PAY BY CREDIT CARD</h2>

<pre>
           <b>Name</b> {text: p_name 35} {select: p_cardtype {&card_types}}
        <b>Address</b> {text: p_addr 35} TOTAL {cur. &total}
           <b>City</b> {text: p_city 35}
 <b>State/Province</b> {text: p_state 35}
<b>Zip/Postal Code</b> {text: p_zip 35}
    <b>Card Number</b> {text: p_card_txt 21} <b>Exp</b> {select: p_month_txt {&card_months}} / {select: p_year_txt {&card_years}}
</pre>
<blockquote>
	{^pay: I authorize this charge to my credit card}
</blockquote>
</table>

<tame /form>
