# SMTP mail sending perl script 
# Fill in SMTP mail sever.

$input{'mailserver'} = 'mailhost.worldnet.att.net';

#######################################################################

$SIG{'INT'} = 'close_socket';

# becomes 0 when an error occurs.
$status = 1;

$input{'file'} = $ENV{'TAMEEMFILE'};
$input{'email'} = $ENV{'TAMEEMFROM'};
$input{'send_to'} = $ENV{'TAMEEMTO'};
$input{'subject'} = $ENV{'TAMEEMSUBJ'};

&send_mail;		#send the mail
if ($status)	#return result text
{
	&respond_sent;
} 
else
{
	&respond_failed;
}

############################################################
sub send_mail
{
	$status = 0;
	if ($input{'mailserver'} && 
	$input{'email'} &&
	$input{'send_to'} &&
	$input{'file'} &&
	$input{'subject'})  
	{
		$mailserver = $input{'mailserver'};
		$status = &connect_socket();
		if ($status)
		{
			$status = &talk_smtp;
			shutdown (S, 2);
			close S;
		}
#		else
#		{
#			print "Error: $errstring\r\n";
#		}
	}
	else
	{
		$status = 0;
		$errstring = "<b>mailserver</b>, <b>email</b>, <b>send_to</b>, or <b>subject</b> field is blank";
		$errstring .= "<br> mailserver = $input{'mailserver'}";
		$errstring .= "<br> file = $input{'file'}";
		$errstring .= "<br> email = $input{'email'}";
		$errstring .= "<br> send_to = $input{'send_to'}";
		$errstring .= "<br> subject = $input{'subject'}";
	}
	return ($status);
}
############################################################
sub get_reply
# get a response from the mail server. Return true if it's in the 
# range 200-399 (good returns), otherwise return false, and set $status
# to 0.
{
	local ($retcode,$junk,$buffer);
	recv(S,$buffer,200,0);
	($retcode,$junk) = split(' ',$buffer);
	($retcode,$junk) = split('-',$retcode);
	if (($retcode >= 200) && ($retcode < 400))
	{
		return (1);
	}
	else
	{
		$status = 0;
		$errstring = $buffer;
		return (0);
	}
}
############################################################
sub talk_smtp
# talk SMTP to the mail server. Fail if anything goes wrong.
	{
	if (&get_reply()){
		send (S,"HELO mailer\r\n",0);
		if (&get_reply()){
			send (S,"MAIL From: <$input{'email'}> \r\n",0);
			if (&get_reply()){
				send (S,"RCPT To: <$input{'send_to'}> \r\n",0);
				if (&get_reply()){
					send (S,"DATA\r\n",0);
					send (S,"From: <$input{'email'}>\r\n",0);
					send (S,"To: $input{'send_to'}\r\n",0);
					send (S,"Subject: $input{'subject'}\r\n\r\n",0);
					open (INFILE, $input{'file'});
					read(INFILE,$mailbuffer,5000000);
					send (S,"$mailbuffer",0);
					send (S,"\r\n.\r\n",0);
					if (&get_reply()){
						send(S,"QUIT\r\n",0);
						if (&get_reply())
	      				{ 
		      			$status = 1;
		      			}
				    }
					close (INFILE);
					unlink ("$input{'file'}");
		  		}
			}
		}
	}
	return($status);
}
############################################################
sub respond_sent
{
	print "<H2>Mail sent.</H2>\r\n";  
	print "Your mail has been sent to\r\n";
	print "<I> $input{'send_to'}</I> via the mail server\r\n";
	print " <I>$input{'mailserver'}</I>.\r\n";
}
############################################################
sub respond_failed
{
	print "<H2>Failed to send mail.</H2>\r\n";
	print "A problem has occured in sending your mail. \r\n";
	print "<P><font size=+1><i><b>Error</b></i> : </font> $errstring\r\n";
}  
############################################################
sub trace
{
	local ($s) = @_;
	printf("%s\r\n",$s);
}
############################################################
sub close_socket
{
	close S;
	die "Socket closed on signal interrupt\r\n";
}

############################################################
sub connect_socket
# set up the connection to smtp service on the mailhost.
{
	$service = 'smtp';

	$AF_INET = 2;
	$SOCK_STREAM = 1;
	$IPPROTO_TCP = 6;
	$status = 1;
	$length = 0;

	$sockaddr = 'S n a4 x8';

	$serverhost = $mailserver;
	($name, $aliases, $proto) = getprotobyname('tcp');

	($name, $aliases, $port, $foo) = getservbyname($service,'tcp' );

	if ($port)
	{
		($name, $aliases, $adrtype, $length, @serveraddr) = gethostbyname($serverhost);
	}
	else
	{
		$status = 0;
		$errstring = "Failed to locate SMTP mail service on $serverhost .";
	}

	if ($length)
	{
		($a, $b, $c, $d) = unpack('C4', $serveraddr[0]);
		unless (socket(S, $AF_INET, $SOCK_STREAM, $proto))
		{
			($!) = ($!, close(S));
			$status = 0;
			$errstring = "Open socket failed.";
		}
		if ($status)
		{	
			$serverproc = pack($sockaddr, $AF_INET, $port, $serveraddr[0]);
			unless (connect(S, $serverproc)) 
			{
				($!) = ($!, close(S)); # close S while saving $!
				$status = 0;
				$errstring = "Failed to connect to mail server $mailserver.";
			}
		}
	}
	else
	{
		$status = 0;
		$errstring = "gethostbyname on $mailserver failed.<br>\r\n";
		$errstring .= "SMTP port = $port<br>\r\n";
		$errstring .= "$name, $aliases, $adrtype, $length, @serveraddr";
	}
	return ($status);
}






