{define! build_shop
	'build_name = .#1;
	'build_email = .#2;
	admin-make-shop.. 'build_name 'build_email;
	'opsys ~= "MSDOS" then make-index-cgi. 'build_name;
	make-new-door.. 'build_name "index.tam";
	make-new-proddb.. 'build_name "product.tdb";
	admin-add-shop.. 'build_name 'build_email;
}

{define! make-index-cgi
	'opsys == "MSDOS" then ex;
	.#1 == "" then ex;
	'idp = path. {"/tameweb/" .#1 "/index.cgi"};
	'door = vo.. .#2 "index.tam";
	{@'idp and @'idp,\#door not} then ex;
	@'idp = [#!/bin/csh{nl}#door {'door}{nl}echo Location: /{cgi-bin/}{tame/}{.#1}/{'door}{nl}echo ""{nl}echo ""{nl}];
	flush. 'idp;
	'opsys ~= "MSDOS" then dos: chmod ugo+rx {'idp}}

{define! make-new-door
	.#1 == "" then ex;
	'idp = path. {"/tameweb/" .#1 "/" .#2};
	dosexists. 'idp then ex;
	@'idp = new_door_text; flush. 'idp}

{define! make-new-proddb
	.#1 == "" then ex;
	'idp = path. {"/tameweb/" .#1 "/" .#2};
	dosexists. 'idp then ex;
	@'idp = new_proddb_text; flush. 'idp}

{define! remove-shop-db @~mall/shops.tdb,.#1 = ""}

{define! remove-each
	eachrecord!! .#1 @, = {@,,#1 " " eachfield!! %,,#2 @,, ~= .#2 then ["{@,,}" ]}}

{define! if-value {eachfield!! .#1 @,, == .#2 then ex}; fail}
{define! add-adm-owner exists. @~mall/allowed.tdb,{.#1}
	then {
		if-value.. %~mall/allowed.tdb,{.#1} .#2
		else @~mall/allowed.tdb,{.#1} = @~mall/allowed.tdb,{.#1} " ".#2};
	else @~mall/allowed.tdb = @~mall/allowed.tdb nl ["{.#1}" "{.#2}"]}

{define! admin-add-shop
	'shop = .#1;
	'shop-owner = .#2;
	'ecs-name = std-ecs;
	'version = std-release;
	'last-revised = utc;
	'last-time = time;
	'last-editor = 'email;
	db_update.. %~mall/shops.tdb,\{.#1},#1 [shop ecs-name version last-revised last-time shop-owner last-editor];
}

{define! admin-make-shop
	'shop-dir = .#1;
	'owner-id = .#2;
	'shop-dir else ex;
	'shop-path = path. {"/tameweb/" 'shop-dir};
	'shop-mirror = path. {/mirror/ 'shop-dir};
	'shop-config = 'shop-mirror "/" n_config;
	'shop-custom = 'shop-mirror "/" n_custom;
	'shop-invoice = 'shop-mirror "/" n_payments;
	dosexists. 'shop-path else mkdir! 'shop-path;
	dosexists. 'shop-mirror else mkdir. 'shop-mirror;
	dosexists. 'shop-config else cp: {path. "!data/config.new"} {'shop-config};
	dosexists. 'shop-custom else cp: {path. "!data/custom.new"} {'shop-custom};
	dosexists. 'shop-invoice else cp: {path. "!data/payments.new"} {'shop-invoice};
	'owner-id then add-adm-owner.. 'owner-id 'shop-dir;
	}

{define! admin-delete-shop
	'shop-dir = .#1;
	'shop-dir else ex;
	'shop-path = path. {"/tameweb/" 'shop-dir};
	'shop-mirror = path. {/mirror/ 'shop-dir};
	dosexists. 'shop-path then rmdir! 'shop-path;
	dosexists. 'shop-mirror then rmdir! 'shop-mirror;
	exists. @~mall/shops.tdb,\'shop-dir then remove-shop-db. 'shop-dir;
	remove-each.. %~mall/allowed.tdb 'shop-dir;
}

{define! grpdos :#1 ex}
{;--------------------------------------------------------------------
                 N E W   D O O R . T A M   T E X T
----------------------------------------------------------------------}
{define! new_door_text
"<tame tamepage: " date " by " 'customer ">" nl;
"<tame title: New shop door page>" nl;
[<h1>New shop door for {'shop-dir}</h1>] nl;
"<p>" nl;
"<i>Modify this page to be your own shop door</i>" nl;
"<tame /tamepage>" nl;
}
{;--------------------------------------------------------------------
              N E W   P R O D U C T . T D B   T E X T
----------------------------------------------------------------------}
{define! new_proddb_text
";fields item price descrip weight url keywords" nl;
[example 2.95 "This is an example product" 1.5 "" ""] nl;
}
