;tovna auto load
(defun tovna_autoload (app cmdliste app_path main_file)
  (_tovna_autoqload "" app cmdliste app_path main_file)
)

(defun tovna_autoarxload (app cmdliste app_path main_file)
  (_tovna_autoqload "arx" app cmdliste app_path main_file)
)


(defun _tovna_autoqload (quoi app cmdliste app_path main_file / qapp symnam qapp_path qmain_file)
  (setq qapp (strcat "\"" app "\""))
  (setq qapp_path (string2string app_path))
  (setq qmain_file (string2string main_file))
  (setq initstring "\nInitializing...")
  (mapcar
   '(lambda (cmd / nom_cmd)
      (progn
        (setq nom_cmd (strcat "C:" cmd))
        (if (not (eval (read nom_cmd)))
            (eval
             (read (strcat
                    "(defun " nom_cmd "( / rtn)"
                    "(setq m:err *error* *error* *merrmsg*)"
					"(append_path "	qapp_path " " qmain_file ")"
                    "(if (ai_ffile " qapp ")"
                    "(progn (princ initstring)"
                    "(_auto" quoi "load " qapp ") (setq rtn (" nom_cmd ")))"
                    "(ai_nofile " qapp "))"
                    "(setq *error* m:err m:err nil)"
                    "rtn)"
                    ))))))
   cmdliste)
  nil
)
(defun append_path(new_path main_file / acad_pref a_app a_pref p_files f_sup s_path)
	(setq
		acad_pref (strcat (getvar "ACADPREFIX") ";")
	)
	(if
		(null (wcmatch acad_pref (strcat "*" new_path ";*")))
		(progn
			(Vl-Load-Com)
			(if
				(vl-directory-files new_path main_file 1)
				(progn
					(setq 
						a_app  (vlax-get-acad-object)
						a_pref (vla-get-Preferences a_app)
						p_files(vla-get-files a_pref)
						f_sup  (vla-get-SupportPath p_files)
						s_path (strcat new_path ";" f_sup)
					)
					(vla-put-SupportPath p_files s_path)
				)
			)
		)
	)
)
(defun RemoveLastSlash(str1 / strl)
	(if
		(and
			str1
			(/= (setq strl (strlen str1)) 0)
			(or
				(= (substr str1 strl 1) "\\")
				(= (substr str1 strl 1) "/")
			)
		)
		(setq
			str1 (substr str1 1 (1- strl))
		)
	)
	str1
)
(defun string2string(str1 / str2 int chr1)
	(setq
		str2 "\""
		int 0
	)
	(while
		(< int (strlen str1))
		(setq
			int (1+ int)
			chr1 (substr str1 int 1)
		)
		(if
			(or
				(= chr1 "\\")
				(= chr1 "/")
			)
			(setq chr1 "\\\\")
		)
		(setq
			str2 (strcat str2 chr1)
		)
	)
	(setq
		str2 (strcat str2 "\"")
	)
	str2
)
(defun C:TOVNAMENU( / cmd)
	(setq
		cmd (getvar "CMDECHO")
	)
	(if
		(findfile "ac_tovna.mnu")
		(progn
			(setvar "CMDECHO" 0)
			(if
				(null (menugroup "AC_TOVNA"))
			    (command "_.menuload" "ac_tovna")
			)
			(setvar "CMDECHO" cmd)
			(PlaceTovnaMenu)
		)
	)
	(prin1)
)
(defun PlaceTovnaMenu (/ CNT)
  (setq CNT 1)
  (while (< CNT 24)
    (if (menucmd (strcat "P" (itoa CNT) ".1=?"))
      (setq CNT (1+ CNT))
      (progn
        (if (> CNT 2)
          (setq CNT (1- CNT))
          (setq CNT 2)
        )
        (menucmd (strcat "p" (itoa CNT) "=+AC_TOVNA.pop1"))
        (setq CNT 25)
      )
    )
  )
)

(defun TovnaStartup()
	(if
		(and
			(findfile "ac_tovna.mnu")
			(null (findfile "ac_tovna.mnc"))
		)
		(C:TOVNAMENU)
		(if
			(findfile "ac_tovna.mnl")
			(load "ac_tovna.mnl")
		)
	)
	(prompt "Type TOVNAMENU for reload TOVNA Applications Menu.") 
	(prin1)
)
(TovnaStartup)

