set ncver "Nukecheck Library 2.9s for EuroStat 2.9.8s by Adam of iPO (01/29/00)"
# 
# this tcl is external so that it can be altered or replaced 
# with a newer version and no settings will require changing
# 

proc nukecheck {ucpath0 ucpath1} {
  global newk autonukebeta autonukebuild autonukegroup autonukeold autonukepda autonukebados autonukenoneng reautonuke
  set dupe 0
  set dupe [dupecheck $ucpath1]
  if {$dupe == 1} {
    set newk "dupe"
    putlog ">>>>>> $ucpath1 <<<<<<"
    if {[regexp "done" $ucpath1] || [regexp "finished" $ucpath1]} {
      set newk "."
    } elseif {[regexp "complete" $ucpath1]} {
      set newk "."
    } elseif {[string length $ucpath1] < 5 && [regexp "cd" [string range $ucpath1 0 1]]} {
      set newk "."
    }
    prenukedcheck $reautonuke $ucpath1
  } else {
    if {[regexp "nuked" $ucpath1]} {set newk "prenuked"
    } elseif {[regexp "cyrix" $ucpath1]} {set newk "cyrix=shit"
    } elseif {[regexp "clipart" $ucpath1]} {set newk "crap"
    } elseif {[regexp "vagina" $ucpath1]} {set newk "eat.this"
    } elseif {[regexp "penis" $ucpath1]} {set newk "suck.it"
    } elseif {[regexp "sdk" $ucpath1]} {set newk "lame"
    } elseif {[regexp "ddk" $ucpath1]} {set newk "lame"
    } elseif {[regexp "review" $ucpath1]} {set newk "lame"
    } elseif {[regexp "n64" $ucpath1]} {set newk "read.rules"
    } else {set newk "."
    }
    if {$newk != "." && $newk != "warning"} {return 0}

    if {$autonukegroup == 1} {
      set newk "banned.group"
     } elseif {$autonukegroup == 2} {
      set newk "warning"
     } else {
      set newk "."
    }
    if {[regexp -- "-owi" $ucpath1]} {
     } elseif {[regexp -- "-skl" $ucpath1] || [regexp -- "-skeleton" $ucpath1]} {
     } elseif {[regexp -- "-gcg" $ucpath1] || [regexp "_gcg" $ucpath1]} {
     } elseif {[regexp -- "-esquire" $ucpath1]} {
     } elseif {[regexp -- "-etoile" $ucpath1]} {
     } elseif {[regexp -- "-arcane" $ucpath1]} {
     } elseif {[regexp -- "-paragrine" $ucpath1]} {
     } elseif {[regexp -- "-food" $ucpath1]} {
     } elseif {[regexp -- "-mom" $ucpath1]} {
     } elseif {[regexp -- "-atomic" $ucpath1]} {
     } elseif {[regexp -- "-nordic" $ucpath1]} {
     } elseif {[regexp -- "-fatbastards" $ucpath1]} {
     } elseif {[regexp -- "-rough" $ucpath1]} {
     } elseif {[regexp -- "-hummerz" $ucpath1]} {
     } elseif {[regexp -- "-jewz" $ucpath1]} {
     } elseif {[regexp -- "-dechine" $ucpath1]} {
     } elseif {[regexp -- "-demolitionwarez" $ucpath1]} {
     } else {set newk "."
    }
    if {$newk != "." && $newk != "warning"} {return 0}

    if {$autonukebuild == 1} {
      set newk "build"
     } elseif {$autonukebuild == 2} {
      set newk "warning"
     } else {
      set newk "."
    }
    if {[regexp "b1" $ucpath1] || [regexp "b2" $ucpath1]} {
     } elseif {[regexp "b3" $ucpath1] || [regexp "b4" $ucpath1]} {
     } elseif {[regexp "b5" $ucpath1] || [regexp "b6" $ucpath1]} {
     } elseif {![regexp "builder" $ucpath1] && [regexp "build" $ucpath1]} {
     } else {set newk "."
    }
    if {$newk != "." && $newk != "warning"} {return 0}

    if {$autonukebeta == 1} {
      set newk "beta"
     } elseif {$autonukebeta == 2} {
      set newk "warning"
     } else {
      set newk "."
    }
    if {[regexp "rc1" $ucpath1] || [regexp "rc2" $ucpath1]} {
     } elseif {[regexp "rc3" $ucpath1] || [regexp "rc4" $ucpath1]} {
     } elseif {[regexp "pre-rel" $ucpath1] || [regexp "prerel" $ucpath1]} {
     } elseif {[regexp "candidate" $ucpath1] && [regexp "release" $ucpath1]} {
     } elseif {[regexp "beta" $ucpath1]} {
     } else {set newk "."
    }
    if {$newk != "." && $newk != "warning"} {return 0}

    if {$autonukebados == 1} {
      set newk "bad.os"
     } elseif {$autonukebados == 2} {
      set newk "warning"
     } else {
      set newk "."
    }
    if {[regexp "netware" $ucpath1] && ![regexp "win" $ucpath1]} {
    } elseif {[regexp "novell" $ucpath1] && ![regexp "win" $ucpath1]} {
    } elseif {[regexp ".os2" $ucpath1] || [regexp "_os2" $ucpath1]} {
    } elseif {[regexp "as400" $ucpath1]} {
    } elseif {[regexp "beos" $ucpath1]} {
    } elseif {[regexp "sunos" $ucpath1]} {
    } elseif {[regexp "sparc" $ucpath1]} {
    } elseif {[regexp "solaris" $ucpath1]} {
    } else {set newk "."
    }
    if {$newk != "." && $newk != "WARNING"} {return 0}

    if {$autonukepda == 1} {
      set newk "handheld"
     } elseif {$autonukepda == 2} {
      set newk "warning"
     } else {
      set newk "."
    }
    if {[regexp "wince" $ucpath1] && [regexp "visual" $ucpath1]} {set newk "."
    } elseif {[regexp "wince" $ucpath1] && [regexp "vcpp" $ucpath1]} {set newk "."
    } elseif {[regexp "wince" $ucpath1]} {
    } elseif {[regexp "apple" $ucpath1] && [regexp "newton" $ucpath1]} {
    } elseif {[regexp "palmpilot" $ucpath1]} {
    } else {set newk "."
    }
    if {$newk != "." && $newk != "warning"} {return 0}

    if {$autonukenoneng == 1} {
      set newk "foreign"
     } elseif {$autonukenoneng == 2} {
      set newk "warning"
     } else {
      set newk "."
    }
    if {[regexp "jwin" $ucpath1]} {set newk "foreign"
    } elseif {[regexp "crpg" $ucpath1]} {set newk "foreign"
    } elseif {[regexp "french" $ucpath1]} {set newk "foreign"
    } elseif {[regexp "dutch" $ucpath1]} {set newk "foreign"
    } elseif {[regexp "finnish" $ucpath1]} {set newk "foreign"
    } elseif {[regexp "swedish" $ucpath1]} {set newk "foreign"
    } elseif {[regexp "german" $ucpath1] && [regexp "english" $ucpath1]} {set newk "."
    } elseif {[regexp "german" $ucpath1] && [regexp "campaign" $ucpath1]} {set newk "."
    } elseif {[regexp "german" $ucpath1] && [regexp "germany" $ucpath1]} {set newk "."
    } elseif {[regexp "german" $ucpath1] && [regexp "invasion" $ucpath1]} {set newk "."
    } elseif {[regexp "german" $ucpath1]} {set newk "foreign"
    } elseif {[regexp "russian" $ucpath1] && [regexp "english" $ucpath1]} {set newk "."
    } elseif {[regexp "russian" $ucpath1] && [regexp "campaign" $ucpath1]} {set newk "."
    } elseif {[regexp "russian" $ucpath1]} {set newk "foreign"
    } else {set newk "."
    }
    if {$newk != "." && $newk != "warning"} {return 0}

    if {$autonukeold == 1} {
      set newk "backfilling"
     } elseif {$autonukeold == 2} {
      set newk "warning"
     } else {
      set newk "."
    }
    if {[regexp "/" $ucpath0]} { set grab [string range $ucpath0 0 [string first "/" $ucpath0]] } else { set grab "" }
    if {[string length $grab] == 5 && [regexp -- "-" [string index $grab 2]]} {
      set lda [ssc "CURDATE" "GET"]
      set outcome [string compare $lda grab]
      if {$outcome == 0} {set $newk "."}
    } else {
      set $newk "."
    }
    if {$newk != "." && $newk != "warning"} {return 0}

    if {[regexp "16.bit" $ucpath1]} {set newk "16bit"
    } elseif {[regexp "16bit" $ucpath1]} {set newk "16bit"
    } elseif {[regexp "16-bit" $ucpath1]} {set newk "16bit"
    } elseif {[regexp "16_bit" $ucpath1]} {set newk "16bit"
    } elseif {[regexp "win31" $ucpath1]} {set newk "16bit"
    } elseif {[regexp "win3." $ucpath1]} {set newk "16bit"
    } elseif {[regexp "win.3" $ucpath1]} {set newk "16bit"
    } elseif {[regexp "windows" $ucpath1] && ![regexp "windowsnt" $ucpath1]} {set newk "16bit"
    } elseif {[regexp "win3" $ucpath1]} {set newk "16bit"
    } elseif {[regexp "win_3" $ucpath1]} {set newk "16bit"
    } else {set newk "."
    }
    if {$newk == "16BIT=SHIT"} {
      if {[regexp "9x" $ucpath1]} {set newk "."
      } elseif {[regexp "95" $ucpath1]} {set newk "."
      } elseif {[regexp "98" $ucpath1]} {set newk "."
      } elseif {[regexp "9x" $ucpath1]} {set newk "."
      } elseif {[regexp "_nt" $ucpath1]} {set newk "."
      } elseif {[regexp ".nt" $ucpath1]} {set newk "."
      } elseif {[regexp "32&" $ucpath1]} {set newk "."
      } elseif {[regexp "32bit" $ucpath1]} {set newk "."
      } elseif {[regexp "32_" $ucpath1]} {set newk "."
      } elseif {[regexp "32." $ucpath1]} {set newk "."
      } 
    }
  }
}

proc dupecheck {upload} {
  global uploadsdb
  if {[catch {set of [open $uploadsdb r]}] != 0} {return 0}
  set filerfix [tlow [fixstr $upload]]
  while {![eof $of]} {
    set curline [gets $of]
    set filesfix [fixstr [string range [lindex $curline 0] [string last "/" $curline] end]]
    if {[string match $filerfix $filesfix] == 1} {
      close $of ; putlog "dupecheck completed." ; return 1 
    }
  }
  close $of ; putlog "dupecheck completed." ; return 0
}

proc nukerecord {nuker nukee path type reason amount} {
  global nukesdb
  set reason [tup $reason]
  if {$reason == "empty" || $reason == "incomplete"} {
    return 0
  } elseif {$reason == "delete" || [regexp "WRONG" $reason]} {
    return 0
  }
  set timestamp [clock format [expr [unixtime]] -format "%y%m%d"]
  set of1 [open $nukesdb a]
  puts $of1 "$timestamp \[ Nukee: $nukee [fixsee $amount] \]\[ $path $type \]\[ Nuker: $nuker $reason \]"
  close $of1
}

proc prenukedcheck {act path} {
  global uploadsdb type1 type2 nukesdb newk
  set path [fixstr $path]
  if {![file readable $nukesdb]} { return 0 }
  catch {set of [open $nukesdb r]}
  while {![eof $of]} {
    set curline [gets $of]
    if {[lsearch $curline $type1] == -1} {
      set typel [expr [string length $type2] + 2]
    } elseif {[lsearch $curline $type2] == -1} {
      set typel [expr [string length $type1] + 2]
    }
    set fpath [string range $curline [expr [string first "\]\[" $curline] + 2] [expr [string last "\]\[" $curline] - $typel]]
    set prenuker [tlow [lrange $curline [expr [lsearch $curline "Nuker:"] + 1] [expr [llength $curline] - 1]]]
    if {[regexp "/" $fpath]} {set fpath [string range $fpath [expr [string last "/" $fpath] + 1] end]}
    set fpath [fixstr $fpath] 
    if {[string match $fpath $path] == 1} {
      if {$prenuker != "empty" && $prenuker != "incomplete"} {
        if {![regexp "wrong" $prenuker] && ![regexp "dir" $prenuker]} {
          if {$act == "1"} {
            putlog "DUPE was previously NUKED"
            set newk "prenuked"
          }
          close $of
          return 1 
        } 
      }
    }
  }
  if {$act == "1"} {
    putlog "DUPE was not previously NUKED" 
  }
  close $of
  return 0
}

proc dupestat {upload} {
  global uploadsdb
  set filerfix [tlow $upload]
  set of [open $uploadsdb r]
  set dupevalue "0"
  while {![eof $of]} {
    set curline [gets $of]
    set filesfix [lindex $curline 0]
    if {[string match $filerfix $filesfix] == 1} {
      set dupevalue $curline
    }
  }
  close $of ; putlog "dupestat completed." ; return $dupevalue
}

proc ztrimmult {num mult} {
  if {$num != "0"} {
    while {[string index $num 0] == "0"} {
      if {[string length $num] > 2} {
        set num [string range $num 1 end]
      } else {
        set num [string index $num 1]
      }
    }
  }
  if {$num != 0} {set num [expr $num * $mult]}
  return $num
}

proc ztrimadd {num add} {
  if {$num != "0"} {
    while {[string index $num 0] == "0"} {
      if {[string length $num] > 2} {
        set num [string range $num 1 end]
      } else {
        set num [string index $num 1]
      }
    }
  }
  if {$num == 0} {set num $add} else {set num [expr $num + $add]}
  return $num
}

proc ztrimmin {num min} {
  if {$num != "0"} {
    while {[string index $num 0] == "0"} {
      if {[string length $num] > 2} {
        set num [string range $num 1 end]
      } else {
        set num [string index $num 1]
      }
    }
  }
  if {$num == 0} {set num -$min} else {set num [expr $num - $min]}
  return $num
}

proc mtclean {} { 
 global uploadsdb type1 type2 warinc1 warinc2 mtfreeact deletes mtfree
 if {[catch {set f1 [open $uploadsdb r]}] != 0} {timer $mtfree mtclean ; return 0}
 putlog "empty directory scanning in progress..."
 set curline [gets $f1]
 set deletes "" ; set lnum 0
 set tim [time]
 set cvalue [ztrimmult [string range $tim 0 1] 60]
 set tvalue [string range $tim 3 4]
 set cvalue [ztrimadd $tvalue $cvalue]
 set loffset [ssc "LASTMTF" "GET"]
 while {![eof $f1]} {
   set curline [gets $f1]
   if {$loffset <= $lnum} {
     if {$curline != ""} {
       set path [lindex $curline 0]
       set uper [lindex $curline 1]
       set timestamp [lindex $curline 3]
       set type [lindex $curline 4]

       set uvalue [ztrimmult [string range [lindex $timestamp 1] 0 1] 60]
       set uvalue [ztrimadd [string range [lindex $timestamp 1] 3 4] $uvalue]
       if {$uvalue > $cvalue} {set rvalue [ztrimadd $cvalue 1440]} else {set rvalue $cvalue}
       if {[expr $rvalue - $uvalue] >= $mtfree} {
         if {$type == $type1} {
           set fullpath $warinc1$path
         } elseif {$type == $type2} {
           set fullpath $warinc2$path
         }
         set size [deltree "0" $fullpath]
         if {$size == 0} {lappend deletes "\{$path\} $type $uper"}
       }
     }
   }
   incr lnum
 }
 close $f1
 if {![regexp "mtclean" [timers]]} {
   timer $mtfree mtclean
 }
 if {$deletes != ""} {
   mtnuke
 } else {
   putlog "none found"
 }
}

proc mtnuke {} {
  global deletes mtfreeact type1 type2 pubchans1 
  putlog "nuking empty directories..."
  for {set x 0} {$x < [llength $deletes]} {incr x} {
    set mnv [lindex $deletes $x]
    set path [lindex $mnv 0]
    set type [lindex $mnv 1]
    set uper [lindex $mnv 2]
    putlog "1. $path  2. $type  3. $uper"
    if {$mtfreeact != 3} {
      manualnuke "Autodeleter" [lindex $pubchans1 0] "DELETE" "0" [tlow $type] $path 
    } else {
      manualnuke "Autodeleter" [lindex $pubchans1 0] "EMPTY" "1" [tlow $type] $path 
    }
  }
  upclean
}

proc upclean {} {
  global uploadsdb udbmonths type1 type2 warinc1 warinc2 deletes mtfree lastmtf
  putlog "uploads database cleaning started..."
  if {[catch {[set f1 [open $uploadsdb r]]}] != 0} {return 0}
  if {[catch {[set f2 [open "filebase.tmp" w]]}] != 0} {close $f1 ; return 0}
  putlog "uploads database cleaning in progress..."
  set curline [gets $f1]
  puts $f2 $curline
  if {$udbmonths != 0} {
    set cty [clock format [expr [unixtime]] -format "%y"]
    set ctm [clock format [expr [unixtime]] -format "%m"]
    set ctd [clock format [expr [unixtime]] -format "%d"]
  }
  set lnum 0 ; set bnum 0
  while {![eof $f1]} {
    set curline [gets $f1]
    if {$curline != ""} {
      set path [lindex $curline 0]
      if {[regexp "/" $path]} {set path [string range $path [string first "/" $path] end]}
      set go 0
      if {$udbmonths != 0} {
        set tsy [string range [lindex $curline 3] 0 1]
        set tsm [string range [lindex $curline 3] 2 3]
        set tsd [string range [lindex $curline 3] 4 5]
        if {[ztrimmin $cty $tsy] > 0} {set ctm [ztrimadd $ctm 12]}
        if {[ztrimmin $ctm $tsm] > $udbmonths} {
          set go 1
        } elseif {[ztrimmin $ctm $tsm] == $udbmonths && $ctd < $tsd} {
          set go 1
        } elseif {$ctd <= $tsd} {
          set go 1
        }      
      } 
      if {$go == 0} { 
        if {[lsearch $deletes [lindex $curline 0]] != -1} {set go 1 ; putlog "[lindex $curline 0] removed from filebase"} 
      }
      if {$go == 0} {set go [prenukedcheck "0" $path]}
      if {$go == 0} {puts $f2 $curline ; incr lnum} else {incr bnum}
    }
  }
  close $f1
  close $f2
  if {[catch {[file delete $uploadsdb]}] == 0} {catch {file rename "filebase.tmp" $uploadsdb}}
  set deletes ""
  putlog "good: $lnum  bad: $bnum"
  ssc "LASTMTF" "$lnum"
  if {$mtfree == 0} {
    timer 360 upclean
  }
}

putlog "$ncver loaded"