set fover "FileOut Library Customized 2.8s for EuroStat 2.9.8s by Adam of iPO  (01/29/00)"
#
#   Adds the site's utop/dtop and group utop/dtop to the 
#   WAR-FTPD after login message. Creates a last uploads
#   file to be used as the change dir message in uploads.
#
bind pub - [set cmdpre]onel woneline

proc woneline {nick uhost hand chan args} {
  global sitename pubcmd onelines footer
  set args [lindex $args 0]
  set act [tup [lindex $args 0]]
  if {$hand == "*"} {set hand $nick}
  if {$pubcmd == "off"} {
    putserv "PRIVMSG $chan :[b]\[[b]$nick[b]\][b] Public commands are [b]$pubcmd"
  } elseif {$onelines == "0"} {
    putserv "PRIVMSG $chan :[b]\[[b]$nick[b]\][b] One-liner command is disabled" 
  } elseif {$act == ""} {
    putserv "PRIVMSG $chan :[b]\[[b]$nick[b]\][b] This commands requires [u]ADD[u] and the message, or [u]READ[u]" 
    return 0
  } 
  if {[llength $args] == 1 && $act == "READ"} {
    if {[catch {set of [open $footer r]}] == 0} { 
      putserv "PRIVMSG $nick :$sitename One-liners"
      while {![eof $of]} {
        set curline [gets $of]
        if {$curline != ""} {putserv "PRIVMSG $nick :[lindex $curline 0] [b]\[[b] [lindex $curline 2] [b]\]\[[b] [lindex $curline 1] [b]\][b]"}
      }
      close $of
    }  
  } elseif {[llength $args] >= 2 && $act == "ADD"} {
    set message [lrange $args 1 end]
    set ols ""
    if {[file exist $footer]} {
      if {[catch {set of [open $footer r]}] == 0} { 
        while {![eof $of]} {
          set curline [gets $of]
          if {$curline != ""} {lappend ols $curline}
        }
        close $of
      }
      if {[llength $ols] >= $onelines} {set $ols [lrange $ols 1 end]}
    }
    lappend ols "\{[date] [time]\} $hand \{$message\}"
    if {[catch {set of [open $footer w]}] == 0} { 
      set maxol 0
      while {$maxol != [llength $ols]} {
        puts $of "[lindex $ols $maxol]" ; incr maxol
      }
      close $of
      putserv "PRIVMSG $chan :[b]\[[b]$nick[b]\][b] One-liner added"
    }
  }
}

proc writestat {} {
  global userdb utop dtop usgroup dsgroup gutop gdtop showuon wardir header footer issitestat isgroupstat islastups islastnks islastdps isuserstat ssconfig fout2 onelines
  putlog "Writestat invoking..."
  set usum 0;set dsum 0;set utime 0;set dtime 0;set utop "";set dtop "";set aspeed 0;set atimes 0;set topspeed "0 noone";set gdtop "";set gutop ""
  set ufout "$wardir$fout2"
  set filee "sysmsg1.txt"
  set foutput $wardir$filee
  if {[catch {set fout [open $foutput w]}] != 0} {return 0}
  if {[catch {set of [open $userdb r]}] != 0} {return 0}
  while {![eof $of]} {
     set curline [gets $of]
     if {$curline == ""} {continue}
     set user [lindex $curline 0]
     set speed [lindex $curline 2]
     set times [lindex $curline 3]
     set size [expr [lindex $curline 4] + 0.0]
     set lspeed [lindex $curline 5]
     set dupesize [lindex $curline 6]
     if {[getgroup $user] == "ign"} {continue}
     if {[lindex $topspeed 0] < $speed} {set topspeed "$speed $user"}
     if {[lindex $curline 1] == 1} {
        foreach group [split [getgroup $user] /] {
          chgustat $group $speed $size
        }
        set usum [expr $size + $usum]
        makeutop $user $size [round $speed 1] $lspeed
     } elseif {[lindex $curline 1] == 0} {
        foreach group [split [getgroup $user] /] {
          chgdstat $group $speed $size 
        }
        set dsum [expr $size + $dsum]
        makedtop $user $size [round $speed 1] $lspeed
     }
     if {$speed != ""} {
        set aspeed [expr $aspeed + [adds $speed $times]]
        set atimes [expr $atimes + $times]
     }
  }
  close $of
  foreach ca [array names usgroup] {
    set group $ca
    set size [lindex $usgroup($group) 2]
    set speed [round [lindex $usgroup($group) 0] 1]
    makegutop $group $size $speed
  }
  foreach ca [array names dsgroup] {
    set group $ca
    set size [lindex $dsgroup($group) 2]
    set speed [round [lindex $dsgroup($group) 0] 1]
    makegdtop $group $size $speed
  }
  foreach auser $utop {
    set auser [lindex $auser 0]
    lappend ausers $auser
  }
  foreach auser $dtop {
   set auser [lindex $auser 0]
    if {[lsearch $ausers $auser] == -1} {lappend ausers $auser}
  }
  foreach agroup $gutop {
    set agroup [lindex $agroup 0]
    lappend agroups $agroup
  }
  foreach agroup $gdtop {
    set agroup [lindex $agroup 0]
    if {[lsearch $agroups $agroup] == -1} {lappend agroups $agroup}
  }
  if {[catch {set of [open $header r]}] == 0} {
    while {![eof $of]} {puts $fout [gets $of]}
    close $of
  }
  if {$issitestat == 1} {
    puts $fout "-=| Site Totals |=----------------------------------------------------"
    puts $fout "Total Uploads:     [fixsee $usum]"
    puts $fout "Total Downloads:   [fixsee $dsum]"
    puts $fout "Active Users:      [llength $ausers]"
    puts $fout "Active Groups:     [llength $agroups]"
    puts $fout "Average Speed:     [round [expr $aspeed / $atimes] 2]K/s"
    puts $fout "Top Average Speed: [lindex $topspeed 0]K/s set by [lindex $topspeed 1]"
    puts $fout "__|"
  }
  if {$isuserstat == 1} {
    puts $fout ""
    puts $fout "------=| Top Individual U/Lers |=-----------=| Top Individual D/Lers |=-------"
    set list 10
    set tnum 0
    set statu ""
    set statd ""
    foreach cinfo $utop { set statu "$statu [lrange $cinfo 0 2]" }
    foreach cinfo $dtop { set statd "$statd [lrange $cinfo 0 2]" }
    while {$tnum != $list} {
      incr tnum
      if {$tnum < 10} {set cnum 0$tnum} else {set cnum $tnum}
      set twonum [expr $tnum * 2]
      set threenum [expr $tnum * 3]
      puts $fout "$cnum| [fixlenf [lindex $statu [expr $threenum - 3]] 13] [fixlenf [fixsee [lindex $statu [expr $threenum - 2]]] 8] [fixlenf [lindex $statu [expr $threenum - 1]] 6]K/s [fixlenf [lindex $statd [expr $threenum - 3]] 13] [fixlenf [fixsee [lindex $statd [expr $threenum - 2]]] 8] [fixlenf [lindex $statd [expr $threenum - 1]] 6]K/s"
    }
    puts $fout "__|"
  }
  if {$isgroupstat == 1} {
    puts $fout "------=| Top Group U/Lers |=----------------=| Top Group D/Lers |=------------"
    set list 10
    set tnum 0
    set statu ""
    set statd ""
    foreach cinfo $gutop { set statu "$statu [lrange $cinfo 0 2]" }
    foreach cinfo $gdtop { set statd "$statd [lrange $cinfo 0 2]" }
    while {$tnum != $list} {
      incr tnum
      if {$tnum < 10} {set cnum 0$tnum} else {set cnum $tnum}
      set twonum [expr $tnum * 2]
      set threenum [expr $tnum * 3]
      puts $fout "$cnum| [fixlenf [lindex $statu [expr $threenum - 3]] 13] [fixlenf [fixsee [lindex $statu [expr $threenum - 2]]] 8] [fixlenf [lindex $statu [expr $threenum - 1]] 6]K/s [fixlenf [lindex $statd [expr $threenum - 3]] 13] [fixlenf [fixsee [lindex $statd [expr $threenum - 2]]] 8] [fixlenf [lindex $statd [expr $threenum - 1]] 6]K/s"
    }
    puts $fout "__|"
  }
  if {$onelines != 0 && [file readable $footer]} {
    catch {set of1 [open $footer r]}
    puts $fout "-=| One-Liners |=----------------------------------------------------" 
    while {![eof $of1]} {
      set curline [gets $of1]
      if {$curline == ""} {continue}
      puts $fout "[fixlen [lindex $curline 1] 12] : [fixlen [lindex $curline 2] 60]"
    } 
    close $of1
  }
  close $fout
  catch {unset usgroup ; unset dsgroup}

 if {[catch {set uft [open $ufout w]}] == 0} {
   putlog "creating last uploads $ufout \($uft\)"
   set lasty [ssc "LASTUPS" "GET"]
   if {$islastups == 1 && [llength $lasty] > 0} {
    set lastsep "---=|   Date & Time   |   Last 0 Uploads   |=---------------------------"
    set lfh [string first "0" $lastsep]
    puts $uft "[string range $lastsep 0 [expr $lfh - 1]][llength $lasty][string range $lastsep [expr $lfh + 1] end]"
    for {set x 0} {$x < [llength $lasty]} {incr x} {
	set y [expr $x + 1]
    	if {$y < 10} {set num 0$y} else {set num $y}
	set lastup [lindex $lasty $x]
	set age [lindex $lastup 2]
	set lastor [lindex $lastup 0]
    	puts $uft "\[$num\] $age [fixlen $lastor 50] \[[lindex $lastup 1]\]" 
    }
    puts $uft ""
   }
   set lasty [ssc "LASTDPS" "GET"]
   if {$islastdps == 1 && [llength $lasty] > 0} {
    set lastsep "-=|   Time   |  Last 0 Dupes  |=-----------------------------"
    set lfh [string first "0" $lastsep]
    puts $uft "[string range $lastsep 0 [expr $lfh - 1]][llength $lasty][string range $lastsep [expr $lfh + 1] end]"
    for {set x 0} {$x < [llength $lasty]} {incr x} {
	set y [expr $x + 1]
    	if {$y < 10} {set num 0$y} else {set num $y}
	set lastup [lindex $lasty $x]
	set age [lindex $lastup 2]
	set lastor [lindex $lastup 0]
    	puts $uft "\[$num\] $age [fixlen $lastor 50] \[[lindex $lastup 1]\]" 
    }
    puts $uft ""
   }

   set lasty [ssc "LASTNKS" "GET"]
   if {$islastnks == 1 && [llength $lasty] > 0} {
    set lastsep "-=|   Time   |  Last 0 Nukes  |=-----------------------------"
    set lfh [string first "0" $lastsep]
    puts $uft "[string range $lastsep 0 [expr $lfh - 1]][llength $lasty][string range $lastsep [expr $lfh + 1] end]"
    for {set x 0} {$x < [llength $lasty]} {incr x} {
	set y [expr $x + 1]
    	if {$y < 10} {set num 0$y} else {set num $y}
	set lastup [lindex $lasty $x]
	set age [lindex $lastup 2]
	set lastor [lindex $lastup 0]
    	puts $uft "\[$num\] $age [fixlen $lastor 50] \[[lindex $lastup 1]\]" 
	}
	puts $uft ""
    }
 }
 close $uft
 putlog "Writestat done."
}

putlog "$fover loaded"