// MuTraceI.h: interface for the Mu-Trace debug tracing tool from Image-Integration
//
//////////////////////////////////////////////////////////////////////
#if !defined(_MU_TRACEI_)
#define _MU_TRACEI_

#ifdef MUTRACE_EXPORTS
#define MUTRACE_API __declspec(dllexport)
#else
#define MUTRACE_API __declspec(dllimport)
// include the MUTrace library for the linker
#pragma comment(lib,"MuTrace.lib")
#endif

//////////////////////////////////////////////////////////////////////
//
// define MU_USER in your project, this should be the unique number 
// which the Adminstrator assigned to you in the MU-Trace application!
//
//////////////////////////////////////////////////////////////////////

MUTRACE_API void WINAPI muPrintf(BYTE uUser, BYTE uLevel, LPCTSTR lpformat, ...);

//////////////////////////////////////////////////////////////////////

#ifndef MU_USER
#pragma message("*** MU-Trace Warning: no user defined ***")
    #define MUTRACE0(level,sz)
    #define MUTRACE1(level,sz, p1)
    #define MUTRACE2(level,sz, p1, p2)
    #define MUTRACE3(level,sz, p1, p2, p3)
#else
    #define MUTRACE0(level,sz)              muPrintf(MU_USER,level,_T("%s"), _T(sz))
    #define MUTRACE1(level,sz, p1)          muPrintf(MU_USER,level,_T(sz), p1)
    #define MUTRACE2(level,sz, p1, p2)      muPrintf(MU_USER,level,_T(sz), p1, p2)
    #define MUTRACE3(level,sz, p1, p2, p3)  muPrintf(MU_USER,level,_T(sz), p1, p2, p3)
#endif
//////////////////////////////////////////////////////////////////////

#endif // !defined(_MU_TRACEI_)
