<html>
<head>
<title>E-Mail Validation</title>
</head>
<body>
<blockquote>
<blockquote>
<h2 align="center">E-Mail Validation</h2>
<blockquote>
<p>Note: You may want to come back later and attempt to validate only failed 
addresses since DNS servers or IP routes are down from time to time.</p>

<!-- #include virtual="/AspSamp/Samples/adovbs.inc" -->

<%
  rem **********************************************
  rem   Set a long timeout for the script
  rem **********************************************
  Server.ScriptTimeout = 999999

  Dim rsEMail, MXRecs

  rem **********************************************
  rem   IsValidFormat makes sure that there's a
  rem     '.' & '@' in the email address
  rem **********************************************
  function IsValidFormat(strEMail)
    dim iPPos, iAPos
    IsValidFormat = false
    iAPos = InStr(strEMail, "@")
    iPPos = InStr(strEMail, ".")
    if ((iAPos > 1) and (iPPos > 1)) then
      IsValidFormat = true
    end if
  end function
  
  rem **********************************************
  rem   IsValidDomain makes sure the domain exists
  rem    and that there are MX (mail) records in 
  rem    the DNS for the domain
  rem **********************************************
  function IsValidDomain(strEMail)
    IsValidDomain = false
    MXRecs.Domain = Right(strEMail, Len(strEMail) - InStr(strEMail, "@"))
    if (MXRecs.DoLookup) and (MXRecs.MXRecords > 0) then
      IsValidDomain = true
   end if
  end function

  rem **********************************************
  rem   Calls IsValidFormat and IsValidDomain
  rem     We could add other validation calls here.
  rem **********************************************
  function ValidEMailAddress (strEMail)
    ValidEMailAddress = false
    if IsValidFormat(strEMail) then
      if IsValidDomain(strEMail) then ValidEMailAddress = true
    end if
  end function


  rem **********************************************
  rem   Create the MX lookup object
  rem **********************************************
  Set MXRecs = Server.CreateObject ("AspMX.Lookup")
  MXRecs.DNS = "206.161.239.53"


  rem **********************************************
  rem   Open our database
  rem **********************************************
  set rsEMail = Server.CreateObject ("ADODB.Recordset")
  rsEMail.Open "Customers", "Customers", adOpenKeySet, adLockPessimistic, adCmdTable
  rsEMail.MoveFirst



  rem **********************************************
  rem   Loop through the DB and validate the addresses
  rem **********************************************
  do while not rsEMail.Eof
    Response.Write rsEMail.Fields.Item("EMail") & ": "
    if ValidEMailAddress(Trim(rsEMail.Fields.Item("EMail"))) then
      rem ******************************
      rem  Mark a field name bEMailValid
      rem   as true and output result
      rem ******************************
      rsEMail.Fields.Item("bEMailValid") = true
      Response.Write "valid<br>"
    else
      rem ******************************
      rem  Mark a field name bEMailValid
      rem   as false and output result
      rem ******************************
      rsEMail.Fields.Item("bEMailValid") = false
      Response.Write "invalid."
      if MXRecs.MXRecords = 0 then Response.Write " No MX records found."
      if MXRecs.Error <> "" then Response.Write " " & MXRecs.Error
      Response.Write "<br>"
    end if
    rsEMail.Update
    rsEMail.MoveNext
  loop

  rem **********************************************
  rem   Close and cleanup
  rem **********************************************
  rsEMail.Close
  set rsEMail = nothing
  set MXRecs = nothing

%>
<p>Done with validation...</p>
</blockquote>
</blockquote>
</body>
</html>