<html>
<head><title>AspLib - File Library Examples</title></head>
<body bgcolor=white>
<blockquote>

<%
  cReadOnly = &h1
  cHidden   = &h2
  cSysFile  = &h4
  cVolumeID = &h8
  cDirectory = &h10
  cArchive  = &h20
  cAnyFile  = &h3F

  Function GetAttrs(intAttrs)
    strAttrs = ""
    if cReadOnly and intAttrs then strAttrs = strAttrs  & "R"
    if cHidden and intAttrs then strAttrs = strAttrs  & "H"
    if cSysFile and intAttrs then strAttrs = strAttrs  & "S"
    if cVolumeID and intAttrs then strAttrs = strAttrs  & "V"
    if cDirectory and intAttrs then strAttrs = strAttrs  & "D"
    if cArchive and intAttrs then strAttrs = strAttrs  & "A"
    GetAttrs = strAttrs
  End Function

  Sub ShowFiles (strTitle, strPath, strMask)
    aryFileList = FileObj.GetFileList(strPath, strMask, true)
    if VarType(aryFileList) <> vbNull And IsEmpty(aryFileList) <>  True then
      Response.Write "<p><table border=1 width=500>"
      Response.Write "<tr><td colspan=5 align=center><font size=+1>" & strTitle & "</font></td></tr>"
      Response.Write "<tr><td>File</td><td>Name</td><td>Date</td><td>Size</td><td>Attributes</td></tr>" & vbCrLf
      intArrayLimit = UBound(aryFileList)
      for intCount = 0 to intArrayLimit -1
        Response.Write "<tr><td align=left>" & intCount + 1 & "</td><td align=left>" & _
                       aryFileList(intCount)(0) & "</td><td align=left>" & _
                       aryFileList(intCount)(1) & "</td><td align=left>" & _
                       aryFileList(intCount)(2) & "</td><td align=left>" & _
                       GetAttrs(aryFileList(intCount)(3)) & "</td></tr>" & vbCrLf
      next
      Response.Write "</table>"
    end if
  End Sub

  rem *****************************************************************
  rem * Instantiate the object
  rem *****************************************************************
  Set FileObj = Server.CreateObject("AspFile.FileObj")


  rem *****************************************************************
  rem * Get the Win32 Temp Path and create an empty file of 10212 bytes
  rem * If file creation is succesful then check the file's date/time
  rem *****************************************************************
  strTempFile1 = lcase(FileObj.GetTempPath & "aspfltst.txt")
  Response.Write "Attempting to create temp file " & strTempFile1 & "<br>"
  if FileObj.CreateFileOfSize(strTempFile1, 10212) then
    Response.Write "The file was created.<br>The file's date/time is " & FileObj.GetFileDateTime(strTempFile1, "mm/dd/yy 'at' hh:mm am/pm") & "<br>"
  else
    Response.Write "<p>Unable to create temporary file.<br>"
  end if

  rem *****************************************************************
  rem * Copy our temporary file to another and then delete both of them
  rem *****************************************************************
  if FileObj.FileExists (strTempFile1) then
    strTempFile2 = lcase(FileObj.GetTempPath & "aspfltst2.txt")
    if FileObj.CopyFile (strTempFile1, strTempFile2) then
      Response.Write "File was successfully copied to " & strTempFile2 & "<br>"
    end if
    if FileObj.DeleteFile(strTempFile1) then
      Response.Write "The file " & strTempFile1 & " was deleted.<br>"
    end if
    if FileObj.DeleteFile(strTempFile2) then
      Response.Write "The file " & strTempFile2 & " was deleted.<br>"
    end if
  end if

  rem *****************************************************************
  rem * Dump a couple of directory listings to the client
  rem *****************************************************************
  ShowFiles "All Files", "C:\", "*.*"
  ShowFiles "Text Files", "C:\", "*.txt"


  Set FileObj = nothing
%>

</blockquote>
</body>
</html>
