/**********************************************************************
 *<
	FILE: stdmtl.h

	DESCRIPTION:

	CREATED BY: Dan Silva

	HISTORY:

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/

#ifndef __STDMTL__H
#define __STDMTL__H

#include "stdmat.h"

// StdMtl flags values
#define STDMTL_ADD_TRANSP   (1<<0)
#define STDMTL_FALLOFF_OUT  (1<<1)
#define STDMTL_WIRE		  	(1<<2)
#define STDMTL_2SIDE		(1<<3)
#define STDMTL_SOFTEN       (1<<4)
#define STDMTL_FILT_TRANSP 	(1<<5)
#define STDMTL_WIRE_UNITS	(1<<6)
#define STDMTL_LOCK_AD      (1<<8)
#define STDMTL_LOCK_DS      (1<<9)
#define STDMTL_UNUSED1		(1<<10)
#define STDMTL_LOCK_ADTEX   (1<<11)
#define STDMTL_FACEMAP		(1<<12)

#define STDMTL_ROLLUP1_OPEN  (1<<28)
#define STDMTL_ROLLUP2_OPEN  (1<<29)
#define STDMTL_ROLLUP3_OPEN  (1<<30)

#define STDMTL_ROLLUP_FLAGS (STDMTL_ROLLUP1_OPEN|STDMTL_ROLLUP1_OPEN|STDMTL_ROLLUP1_OPEN)

class StdMtlDlg;


#define MAPACTIVE(i) ((*maps)[i].IsActive())

class TexmapSlot {
	public:
		float amount;
		Control *amtCtrl;  // ref to controller
		Texmap *map;       // ref to map
		BOOL mapOn;
		TexmapSlot();
		RGBA Eval(ShadeContext& sc) { 
			return amount*map->EvalColor(sc); 
			}
		float EvalMono(ShadeContext& sc) { 
			return amount*map->EvalMono(sc); 
			}
		Point3 EvalNormalPerturb(ShadeContext &sc) {
			return amount*map->EvalNormalPerturb(sc); 
			}
		BOOL IsActive() { return (map&&mapOn&&(amtCtrl||amount!=0.0f)); }
		void Update(TimeValue t, Interval &ivalid);				
		float GetAmount(TimeValue t);
	};

class Texmaps: public ReferenceTarget {
	public:  
		MtlBase *client;
		TexmapSlot txmap[NTEXMAPS];
		BOOL loadingOld;

		Texmaps();
		Texmaps(MtlBase *mb);
		void SetClientPtr(MtlBase *mb) { client = mb; }
		TexmapSlot& operator[](int i) { return txmap[i]; }

		Class_ID ClassID();
		SClass_ID SuperClassID() { return REF_MAKER_CLASS_ID; }

		void DeleteThis();
		RefTargetHandle Clone(RemapDir &remap);	
		RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message );

		BOOL AssignController(Animatable *control,int subAnim) {
			ReplaceReference(SubNumToRefNum(subAnim),(ReferenceTarget *)control);
			return TRUE;
			}

		int NumSubs();
	    Animatable* SubAnim(int i);
		TSTR SubAnimName(int i);
		int SubNumToRefNum(int subNum) {return subNum; }
		
		int NumRefs() { return NTEXMAPS*2; }
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);

		// IO
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);
	};

class StdMtl: public StdMat {
	// Animatable parameters
	public:
		IParamBlock *pblock;   // ref 0
		Texmaps* maps;         // ref 1
		Interval ivalid;
		StdMtlDlg *paramDlg;
		ULONG flags;
		int rollScroll;
		int shading;

		// Cache values: must call Update() when change frame.
		Color ambient;
		Color diffuse;
		Color specular;
		Color filter;
		float shininess;  
		float shine_str;  
		float self_illum;	
		float opacity;	
		float opfall;
		float phongexp;
		float wireSize;
		float ioRefract;

		void SetFlag(ULONG f, ULONG val);
	 	void SetShading(int s);
		void EnableMap(int i, BOOL onoff);
		BOOL IsMapEnabled(int i) { return (*maps)[i].mapOn; }

		void SetAmbient(Color c, TimeValue t);		
		void SetDiffuse(Color c, TimeValue t);		
		void SetSpecular(Color c, TimeValue t);
		void SetFilter(Color c, TimeValue t);
		void SetShininess(float v, TimeValue t);		
		void SetShinStr(float v, TimeValue t);		
		void SetSelfIllum(float v, TimeValue t);		
		void SetTexmapAmt(int imap, float amt, TimeValue t);
		void SetWireSize(float s, TimeValue t);
		
		void SetSoften(BOOL onoff) { SetFlag(STDMTL_SOFTEN,onoff); }
		void SetFaceMap(BOOL onoff) { SetFlag(STDMTL_FACEMAP,onoff); }
		void SetTwoSided(BOOL onoff) { SetFlag(STDMTL_2SIDE,onoff); }
		void SetWire(BOOL onoff){ SetFlag(STDMTL_WIRE,onoff); }
		void SetWireUnits(BOOL onoff) { SetFlag(STDMTL_WIRE_UNITS,onoff); }
		void SetFalloffOut(BOOL onoff) { SetFlag(STDMTL_FALLOFF_OUT,onoff); }
		void SetTransparencyType(int type);
		void LockAmbDiffTex(BOOL onoff) { SetFlag(STDMTL_LOCK_ADTEX,onoff); }
		void SetOpacity(float v, TimeValue t);		
		void SetOpacFalloff(float v, TimeValue t);		
		void SetIOR(float v, TimeValue t);
		
	    int GetFlag(ULONG f) { return (flags&f)?1:0; }


		// from Mtl
		Color GetAmbient(int mtlNum=0, BOOL backFace=FALSE);		
	    Color GetDiffuse(int mtlNum=0, BOOL backFace=FALSE);		
		Color GetSpecular(int mtlNum=0, BOOL backFace=FALSE);
		float GetShininess(int mtlNum=0, BOOL backFace=FALSE) { return shininess; }		
		float GetShinStr(int mtlNum=0, BOOL backFace=FALSE) { return shine_str;  }
		float GetXParency(int mtlNum=0, BOOL backFace=FALSE) { if(opacity>0.9f && opfall>0.0f) return 0.1f; return 1.0f-opacity; }
		float WireSize(int mtlNum=0, BOOL backFace=FALSE) { return wireSize; }

		// from StdMat
	 	int GetShading();
		BOOL GetSoften() { return GetFlag(STDMTL_SOFTEN); }
		BOOL GetFaceMap() { return GetFlag(STDMTL_FACEMAP); }
		BOOL GetTwoSided() { return GetFlag(STDMTL_2SIDE); }
		BOOL GetWire() { return GetFlag(STDMTL_WIRE); }
		BOOL GetWireUnits() { return GetFlag(STDMTL_WIRE_UNITS); }
		BOOL GetFalloffOut() { return GetFlag(STDMTL_FALLOFF_OUT); }  // 1: out, 0: in
		BOOL GetAmbDiffTexLock(){ return GetFlag(STDMTL_LOCK_ADTEX); } 
		int GetTransparencyType() {
			return (flags&STDMTL_FILT_TRANSP)?TRANSP_FILTER:
				flags&STDMTL_ADD_TRANSP ? TRANSP_ADDITIVE: TRANSP_SUBTRACTIVE;
			}
		Color GetAmbient(TimeValue t);		
		Color GetDiffuse(TimeValue t);		
		Color GetSpecular(TimeValue t);
		Color GetFilter(TimeValue t);
		float GetShininess( TimeValue t);		
		float GetShinStr(TimeValue t);		
		float GetSelfIllum(TimeValue t);		
		float GetOpacity( TimeValue t);		
		float GetOpacFalloff(TimeValue t);		
		float GetWireSize(TimeValue t);
		float GetIOR( TimeValue t);
		BOOL MapEnabled(int i);
		float GetTexmapAmt(int imap, TimeValue t);

		// internal
		float GetSelfIllum() { return self_illum; }		
		float GetOpacity() { return opacity; }		
		float GetOpacFalloff() { return opfall; }		
		float GetTexmapAmt(int imap);
		Color GetFilter();
		float GetIOR() { return ioRefract; }
		StdMtl(BOOL loading = FALSE);
		void SetParamDlg( StdMtlDlg *pd) {	paramDlg = pd; }
		BOOL ParamWndProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
		ParamDlg* CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp);
		Color TranspColor(ShadeContext& sc, float opac, Color& diff);
		void Shade(ShadeContext& sc);
		void Update(TimeValue t, Interval& validr);
		void Reset();
		Interval Validity(TimeValue t);
		void NotifyChanged();


		// Requirements
		ULONG Requirements(int subMtlNum);

		// Methods to access texture maps of material
		int NumSubTexmaps() { return NTEXMAPS; }
		Texmap* GetSubTexmap(int i) { return (*maps)[i].map; }
		int MapSlotType(int i) { return (i==ID_RL||i==ID_RR)?MAPSLOT_ENVIRON:MAPSLOT_TEXTURE; }
		void SetSubTexmap(int i, Texmap *m);
		TSTR GetSubTexmapSlotName(int i);
		int SubTexmapOn(int i) { return  MAPACTIVE(i); } 

		Class_ID ClassID();
		SClass_ID SuperClassID() { return MATERIAL_CLASS_ID; }
		void GetClassName(TSTR& s) { s = GetString(IDS_DS_STANDARD); }  

		void DeleteThis();

		int NumSubs() { return 2; }  
	    Animatable* SubAnim(int i);
		TSTR SubAnimName(int i);
		int SubNumToRefNum(int subNum) {return subNum;	}

		// From ref
 		int NumRefs() { return 2; }
		RefTargetHandle GetReference(int i);
		void SetReference(int i, RefTargetHandle rtarg);

		RefTargetHandle Clone(RemapDir &remap = NoRemap());
		RefResult NotifyRefChanged( Interval changeInt, RefTargetHandle hTarget, 
		   PartID& partID, RefMessage message );

		// IO
		IOResult Save(ISave *isave);
		IOResult Load(ILoad *iload);

	};

Mtl* CreateStdMtl();

#endif
