/**********************************************************************
 *<
	FILE: namesel.h

	DESCRIPTION:  A named sel set class for sub-object named selections ets

	CREATED BY: Rolf Berteig

	HISTORY: 3/18/96

 *>	Copyright (c) 1994, All Rights Reserved.
 **********************************************************************/

#ifndef __NAMEDSEL__
#define __NAMEDSEL__


class NamedSelSetList {
	public:
		Tab<BitArray*> sets;
		
		~NamedSelSetList();
		BitArray &operator[](int i) {return *sets[i];}
		int Count() {return sets.Count();}
		void AppendSet(BitArray &nset);
		void DeleteSet(int i);
		IOResult Load(ILoad *iload);
		IOResult Save(ISave *isave);
		void SetSize(int size);
		NamedSelSetList& operator=(NamedSelSetList& from);
		void DeleteSetElements(BitArray &set,int m=1);
	};

// RB: note these methods are implemented in editmesh.cpp.
// This class is used by the edit mesh and edit patch modifiers.

#endif

