AplacVar  C1=0.69  OPT  Min=0.1 Max=2
AplacVar  C7=0.76  OPT  Min=0.1 Max=2
AplacVar  L2=1.6  OPT  Min=0.1 Max=4
AplacVar  L3=5.6  OPT  Min=1 Max=10
AplacVar  L5=5.7  OPT  Min=1 Max=15
AplacVar  L6=1.2  OPT  Min=0.1 Max=4

AplacVar  Cbe=0.82 $ OPT  Min=0.2 Max=2
AplacVar  Le=0.01 $ OPT  Min=0.001 Max=1
AplacVar  Rpgk=410  OPT  Min=300 Max=3000
AplacVar  Gm=0.16 $ OPT  Min=0.1 Max=0.2

$ Charecteristic impedance Zo=50.00Ohm
Cap C1 1 0 1p C=C1 L=0.10n R=12.00
Ind L2 1 2 1n L=L2 R=0.10 C=10.00f
Ind L3 2 0 1n L=L3 R=95.00 C=10.00f

DefModel Transistor4
 +2 1 2
 +PARAM 4 Cbe Rpgk Gm Le
    Default Cbe=0.82
    Default Rpgk=1k
    Default Gm=160m
    Default Le=0.001
Cap Zpgk 1 2 10U R=Rpgk L=1.000P
Ind Zsgk 0 E 1.000N G=1.000K C=1.000F
Res Rx 1 B 5.500 L=10.000P
Res Rc Ci 2 1.000M L=10.000P
Res Re E Ei 1.000M L=Le*1N
Cap Cr B Ci 0.200P
Cap Cin B Ei 1p C=Cbe G=3m
Res Rout Ci Ei 7.2K
Gm Vccs Ci Ei B Ei Gm
DefEnd

Transistor4 Q4 2 3  Cbe=Cbe Rpgk=Rpgk Gm=Gm Le=Le

Ind L5 3 0 1n L=L5 R=95.00 C=10.00f
Ind L6 3 4 1n L=L6 R=0.10 C=10.00f
Cap C7 4 0 1p C=C7 L=0.10n R=0.10
DefNPort Nport 2
+ 1 0 (50.00,0) 4 0 (50.00,0)

Sweep "S-Parameters"
+ LOOP 201 FREQ LIN 100.00M 4G
+ Window 0 smith
+ Window 1 polar autoscale
+ Window 2 autoscale grid
Show Window 0 RI S(1,1)
Show Window 0 RI S(2,2)
Show Window 1 RI S(2,1)
Show Window 1 RI S(1,2)
Show Window 2 Y MagdB(S(2,1))
Show Window 2 Y MagdB(S(1,2))
EndSweep

OptimMethod=Gradient OPT_FTOL=0.0001u OPT_XTOL=0.0001m
Sweep "Gradient Optimization"
+ LOOP 51 FREQ LIN 0.1g 5g
  Goal MagdB(S(2,1)) EQ 12 Weight=2
  Goal MagdB(S(2,2)) LT -10
  Goal MagdB(S(1,1)) LT -10
EndSweep

$ Print optimization variables
Print OPTIMIZE

Sweep "S-Parameters optimized"
+ LOOP 201 FREQ LIN 100.00M 5G
+ Window 0 smith
+ Window 1 polar autoscale
+ Window 2 autoscale grid
+ Window 3 autoscale grid
+ Window 4 autoscale grid
+ Window 5 autoscale grid
Show Window 0 RI S(1,1)
Show Window 0 RI S(2,2)
Show Window 1 RI S(2,1)
Show Window 1 RI S(1,2)
Show Window 2 Y MagdB(S(2,1))
Show Window 2 Y MagdB(S(1,2))
Show Window 3 Y MagdB(S(1,1))
Show Window 3 Y MagdB(S(2,2))
Show Window 4 Y MagdB(S(2,1))
Show Window 5 Y S_K
EndSweep
