#include <stdio.h>
#include <glob.h>
#include <sys/vfs.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include "pmcparse.h"

#define NUKELOGFILE "/ftp-data/logs/nukelog"

#define HEAD "                           ________ 
                           \\       \\       _______________
    _____         _____ ____\\___    \\_____/__   _        /___
  _/     \\ ______/____  \\       \\  _       _/_  /       /  __)_________
 (_______\\\\          _)__________)__\\_________)_ ______/________       )
//--------\\_________/--------------------------(__/-----,-----(_______/-/
  nuker.time| dir.nukees                                | reason
 -----------|-------------------------------------------|---------------
"

#define FOOT "/-----------|-------------------------------------------|---------------/
            |           < muggi-nukes C cyberkid/f00d > |
 -----------'-------------------------------------------'---------------
"

#define EXTRALINE "            |   + @-37.37NUKEE |
"
#define SHOWLINE  "  @9.9NUKER | @-41.41DIR | @-15.15REASON1
  @9.9AGE |   + @-37.37NUKEE | @-15.15REASON2
"
#define DELIM "/-----------|-------------------------------------------|---------------/
"
#define NUKEELINE "@NUKEE (x@RATIO) @BYTESMb"

struct nukelog {
	ushort status;
        time_t nuketime;
        char   nuker[12];
	char   unnuker[12];
        char   nukee[12];
        ushort mult;
        float  bytes;
	char   reason[30];
        char   dirname[255];
        struct nukelog *nxt;
        struct nukelog *prv;
};

struct strlist {
	char s[1024];
	struct strlist *next;
};

struct nukelist {
	double bytes;
	struct nukelog nuke;
	struct nukelist *sub;
	struct nukelist *next;
};

char *makeage(long t) {
	long age=time(0)-t;
	char *buf=(char*)malloc(1024);
	long days,hours,mins;

	days=age/(3600*24);
	age-=days*3600*24;
	hours=age/3600;
	age-=hours*3600;
	mins=age/60;

	if (days)
		sprintf(buf,"%dd %dh",days,hours);
	else
		sprintf(buf,"%dh %dm",hours,mins);

	return buf;
}

char *getdir(char *d) {
	char *o,*t;

	o=t=d;
	while (*t) {
		if (*t=='/'&&*(t+1))
			o=t+1;
		t++;
	}
	return o;
}

void main(int argc,char *argv[]) {
	char pwd[1024],*t,buf[1024],tmpbuf[300],repmac[35];
	FILE *f;
	struct nukelog l,last;
	int len,show,c=0,didreplace=1,first=1;
	struct nukelist *sl=NULL,*tmpsl,*tmpsls;
	struct strlist *strl=NULL,*tmpstrl;

	if (argc==2&&!strcasecmp(argv[1],"help")) {
		printf("Usage: SITE NUKES [#]\n");
		exit(0);
	}
	show=(argv[1])?atoi(argv[1]):5;

	// read in the nukelog.
	f=fopen(NUKELOGFILE,"rb");
	while (fread(&l,sizeof(struct nukelog),1,f)) {
		tmpsl=(struct nukelist*)malloc(sizeof(struct nukelist));
		memcpy(&tmpsl->nuke,&l,sizeof(struct nukelog));
		if (!strcmp(tmpsl->nuke.dirname,last.dirname)) {
			tmpsl->next=sl->sub;
			sl->sub=tmpsl;
		} else {
			memcpy(&last,&l,sizeof(struct nukelog));
			tmpsl->sub=NULL;
			tmpsl->next=sl;
			sl=tmpsl;
		}
		sl->bytes+=tmpsl->nuke.bytes;
	}
	fclose(f);


	while (sl&&(c<show)) {
		tmpstrl=(struct strlist*)malloc(sizeof(struct strlist));
		tmpstrl->s[0]=0;
		tmpsl=sl;
		strcpy(tmpbuf,NUKEELINE);
		pmcparse2(tmpbuf,'@',"NUKEE",tmpsl->nuke.nukee);
		sprintf(repmac,"%d",tmpsl->nuke.mult);
		pmcparse2(tmpbuf,'@',"RATIO",repmac);
		sprintf(repmac,"%.1f",tmpsl->nuke.bytes);
		pmcparse2(tmpbuf,'@',"BYTES",repmac);
		strcpy(buf,SHOWLINE);
		pmcparse2(buf,'@',"NUKER",tmpsl->nuke.nuker);
		pmcparse2(buf,'@',"NUKEE",tmpbuf);
		sprintf(tmpbuf,"%s (x%d) %.1fMb",getdir(tmpsl->nuke.dirname),tmpsl->nuke.mult,tmpsl->bytes);
		pmcparse2(buf,'@',"DIR",tmpbuf);
		sprintf(repmac,"%-15.15s",tmpsl->nuke.reason);
		pmcparse2(buf,'@',"REASON1",repmac);
		pmcparse2(buf,'@',"AGE",makeage(tmpsl->nuke.nuketime));
		if (strlen(tmpsl->nuke.reason)>15)
			pmcparse2(buf,'@',"REASON2",tmpsl->nuke.reason+15);
		else
			pmcparse2(buf,'@',"REASON2"," ");
		
		strcat(tmpstrl->s,buf);

		while (tmpsl->sub) {
			strcpy(tmpbuf,NUKEELINE);
			pmcparse2(tmpbuf,'@',"NUKEE",tmpsl->sub->nuke.nukee);
			sprintf(repmac,"%d",tmpsl->sub->nuke.mult);
			pmcparse2(tmpbuf,'@',"RATIO",repmac);
			sprintf(repmac,"%.1f",tmpsl->sub->nuke.bytes);
			pmcparse2(tmpbuf,'@',"BYTES",repmac);
			strcpy(buf,EXTRALINE);
			pmcparse2(buf,'@',"NUKEE",tmpbuf);
			strcat(tmpstrl->s,buf);

			tmpsl->sub=tmpsl->sub->next;
		}
		tmpstrl->next=strl;
		strl=tmpstrl;

		c++;
		sl=sl->next;
	}

/*	free sl
	while (sl)


	}
*/
	printf(HEAD);

	while (strl) {
		tmpstrl=strl;
		strl=strl->next;
		if (!first)
			printf(DELIM);
		else
			first=0;

		printf(tmpstrl->s);
		free(tmpstrl);
	}

	printf(FOOT);

	fclose(f);
}

/*

			strcpy(buf,NUKEELINE);
			pmcparse2(buf,'@',"NUKEE",l.nukee);
			sprintf(tmpbuf,"%d",l.mult);
			pmcparse2(buf,'@',"RATIO",tmpbuf);
			sprintf(tmpbuf,"%.1f",l.bytes);
			pmcparse2(buf,'@',"BYTES",tmpbuf);
			strcpy(tmpsl->s,EXTRALINE);
			pmcparse2(tmpsl->s,'@',"NUKEE",buf);
			tmpsl->next=sl->sub;
			sl->sub=tmpsl;
		} else {
			strcpy(buf,NUKEELINE);
			pmcparse2(buf,'@',"NUKEE",l.nukee);
			sprintf(tmpbuf,"%d",l.mult);
			pmcparse2(buf,'@',"RATIO",tmpbuf);
			sprintf(tmpbuf,"%.1f",l.bytes);
			pmcparse2(buf,'@',"BYTES",tmpbuf);
			strcpy(tmpsl->s,SHOWLINE);
			pmcparse2(tmpsl->s,'@',"NUKER",l.nuker);
			pmcparse2(tmpsl->s,'@',"NUKEE",buf);
			pmcparse2(tmpsl->s,'@',"DIR",getdir(l.dirname));
			sprintf(tmpbuf,"%-15.15s",l.reason);
			pmcparse2(tmpsl->s,'@',"REASON1",tmpbuf);
			pmcparse2(tmpsl->s,'@',"AGE",makeage(l.nuketime));
			if (strlen(l.reason)>15)
				pmcparse2(tmpsl->s,'@',"REASON2",l.reason+15);
			else
				pmcparse2(tmpsl->s,'@',"REASON2"," ");

*/

