#!/usr/bin/perl
require 'CGI_LIB.pl';
require 'MAIL_LIB.pl';
print "Content-Type: text/html\n\n";

####################################################################
#  FILENAME - "mail_a_file.pl"                                     #
####################################################################
#                                                                  #
#  MAIL-A-FILE BY CGI CITY IS A SIMPLE FORM-BASED MAILING SCRIPT   #
#  WITH FILE ATTACHMENT FEATURES. THIS ALLOWS SENDERS TO ATTACH    #
#  A FILE TO THE MESSAGE HE/SHE WISHES TO SEND. THE SCRIPT USES    #
#  THE FOLLOWING LIBRARIES/MODULES:                                #
#                                                                  #
#  - CGI_LIB.PL - (c) by Simon Tneoh Chee-Boon                     #
#    Email: tneohcb@pc.jaring.my                                   #
#    URL:   http://www.tneoh.zoneit.com/perl/CGI_LIB/              #
#                                                                  #
#  - MAIL_LIB.PL (slightly revised version of MIME Lite.pm)        #
#    MIME Lite originally developed and (c) by Eryq                #
#    Email: eryq@enteract.com                                      #
#    URL:   http://enteract.com/~eryq                              #
#                                                                  #
#  CGI CITY'S MAIL-A-FILE IS NOT FREE AND THEREFORE MAY NOT BE     #
#  DISTRIBUTED FREELY.                                             #
#                                                                  #
#  CGI CITY'S MAIL-A-FILE                                          #
#  Copyright (c) 1998-1999 - CGI City - All rights reserved        #
#  Author: Peter N. Go - cgicity@icthus.net                        #
#                                                                  #
####################################################################
#                                                                  #
#  DISCLAIMER:                                                     #
#  In no event will CGI City be liable to the user of this script  #
#  or any third party for any damages, including any lost profits, #
#  lost savings or other incidental, consequential or special      #
#  damages arising out of the operation of or inability to operate #
#  this script, even if user has been advised of the possibility   #
#  of such damages.                                                #
#                                                                  #
####################################################################
#                                                                  #
#  INSTRUCTIONS:                                                   #
#  1.  Modify the first line of this file to point to your         #
#      server's Perl interpreter.                                  #
#  2.  Modify the variables under the "ASSIGN THESE VARIABLES"     #
#      section. There are 5 variables to assgn in this file.       #
#  3.  Upload this file to your cgi-bin directory and chmod to 755 #
#  4.  View the README.TXT file for complete instructions.         #
#                                                                  #
####################################################################

##############################
##  ASSIGN THESE VARIABLES  ##
##############################
##
##  1. SPECIFY THE AGGREGATE MAXIMUM FILE SIZE (IN BYTES) YOU WISH TO ALLOW FOR ATTACHMENTS.
##     REMEMBER, THIS IS AN AGGREGATE FILE SIZE. IF YOU SPECIFY 100000 BYTES AS THE MAX, THE
##     SENDER CAN ONLY SEND 100000 BYTES OF DATA, WHETHER 1 OR 5 FILES ARE ATTACHED. 

$max_upload_size = 100000;

##
##  2. SPECIFY THE PARAMETERS YOU WISH TO USE FOR THE <BODY> TAG. THIS WILL BE USED ON 
##     THE <BODY> TAGS OF ALL THE HTML PAGES GENERATED BY THE SCRIPT.
##     REMEMBER TO PREFIX ALL DOUBLE-QUOTES (") WITH A BACK-SLASH (\).

$body_specs = " BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#000099\" VLINK=\"990000\" " ;

##
##  3. ASSIGN THE PATH TO YOUR TEMPORARY DIRECTORY. MAIL-A-FILE NEEDS A DIRECTORY
##     TO HOLD THE ATTACHED FILES TEMPORARILY. DO NOT PUT A TRAILING SLASH AT THE END.

$temp_directory = "/path/to/mail_a_file/temp" ;

##
##  4. SPECIFY A TITLE FOR YOUR MAIL-A-FILE PAGE. THE TITLE YOU SPECIFY WILL ALSO APPEAR
##     IN THE <TITLE> TAGS OF ALL THE HTML PAGES GENERATED BY THE SCRIPT.

$your_page_title = "CGI City's Mail-A-File Demo" ;


##
##  5. SPECIFY THE REFERERS YOU WISH TO ALLOW USAGE OF THIS SCRIPT. OTHER REFERRERS OR IPs 
##     NOT IN THIS LIST WILL GET AN ERROR MESSAGE ONCE AN ATTEMPT TO USE THIS SCRIPT IS MADE.
##     ENCLOSE EACH IP/DOMAIN IN QUOTATION MARKS AND SEPARATE THEM WITH COMMAS.

@referers=("icthus.net/CGI-City", "216.28.69.155", "icthus.net");

################################################################
##  THAT'S IT.  GO NO FURTHER. YOU'LL ONLY BREAK SOMETHING.   ##
################################################################
##########        DO NOT EDIT BEYOND THIS LINE        ##########
################################################################

$bad_referer = "<FONT COLOR=\"#990000\" FACE=ARIAL><B>$ENV{'HTTP_REFERER'}</B></FONT><BR><FONT FACE=ARIAL>is not authorized to run this script.</FONT>";
&check_referer;


&Parse_Multi ;

$random_number = $$ ;
$message = "" ;
$found_err = "" ;
($newfilename) = $CGI{'file_attached'}->{'filename'} =~ /([^\\\/]+)$/ ;
($newfilename_B) = $CGI{'file_attached_B'}->{'filename'} =~ /([^\\\/]+)$/ ;
($newfilename_C) = $CGI{'file_attached_C'}->{'filename'} =~ /([^\\\/]+)$/ ;
($newfilename_D) = $CGI{'file_attached_D'}->{'filename'} =~ /([^\\\/]+)$/ ;
($newfilename_E) = $CGI{'file_attached_E'}->{'filename'} =~ /([^\\\/]+)$/ ;

##############################
### CHECK FOR EMPTY FIELDS ###
##############################
$errmsg = "<LI>Please specify the sender's name.\n" ;
if ($CGI{'name_sender'} eq "") {
	$message = $message.$errmsg ;
	$found_err = 1 ; }

$errmsg = "<LI>Please specify the sender's valid email address.\n" ;
if ($CGI{'email_sender'} !~ /.+\@.+\..+/) {
	$message = $message.$errmsg ;
	$found_err = 1 ; }

$errmsg = "<LI>Please specify a recipient.\n" ;
if ($CGI{'name_recipient'} eq "") {
	$message = $message.$errmsg ;
	$found_err = 1 ; }

$errmsg = "<LI>Please specify a valid email address for the recipient.\n" ;
if ($CGI{'email_recipient'} !~ /.+\@.+\..+/) {
	$message = $message.$errmsg ;
	$found_err = 1 ; }

$errmsg = "<LI>You did not indicate a subject.\n" ;
if ($CGI{'subject'} eq "") {
	$message = $message.$errmsg ;
	$found_err = 1 ; }

$errmsg = "<LI>The Message field was left blank.\n" ;
if ($CGI{'main_message'} eq "") {
	$message = $message.$errmsg ;
	$found_err = 1 ; }
if ($found_err) {
	&PrintError; }



#################################
## CHECK SIZE OF UPLOADED FILE ##
#################################
if ($ENV{'CONTENT_LENGTH'} > $max_upload_size) {

print<<"end_error_size";
<HTML><HEAD><TITLE>$your_page_title - Error Encountered</TITLE></HEAD>
<BODY $body_specs>
<CENTER>
<TABLE WIDTH=450 BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR=#000000><TR><TD>
<TABLE WIDTH=100% BORDER=0 CELLPADDING=5 CELLSPACING=2 BGCOLOR=#FFFFFF>
<TR><TD BGCOLOR=#336699>
<FONT FACE=ARIAL SIZE=+1 COLOR=#FFFFFF><B>Error Encountered</B></TD><TR>
<TR><TD><FONT FACE=ARIAL SIZE=-1><B>
The file you tried to send is larger than the allowable file size limit. Please check your file attachment and try again.
</B></FONT></TD></TR></TABLE></TD></TR></TABLE>

<BR><BR><HR NOSHADE WIDTH=600><FONT FACE=ARIAL SIZE=-1>
Mail-A-File &copy 1998-1999 <A HREF=http://icthus.net/CGI-City>CGI City</A>
</BODY></HTML>
end_error_size
die ;

############################################################################
## CLEAN UP THE TEMPORARY DIRECTORY BY REMOVING FILES OLDER THAN ONE DAY  ##
############################################################################
} else {
opendir (DIR, "$temp_directory/");
@FILES = grep(/.temp/,readdir(DIR));
closedir (DIR);

foreach $FILES (@FILES)
	{
	if (-M "$temp_directory/$FILES" > 1)
	{
	unlink("$temp_directory/$FILES");
	}
	}

if ($CGI{'file_attached'} ne "") {
open (FILE, ">$temp_directory/$newfilename$random_number.temp");
print FILE $CGI{'file_attached'}->{'Contents'};
close (FILE);
}

if ($CGI{'file_attached_B'} ne "") {
open (FILEB, ">$temp_directory/$newfilename_B$random_number.temp");
print FILEB $CGI{'file_attached_B'}->{'Contents'};
close (FILEB);
}

if ($CGI{'file_attached_C'} ne "") {
open (FILEC, ">$temp_directory/$newfilename_C$random_number.temp");
print FILEC $CGI{'file_attached_C'}->{'Contents'};
close (FILEC);
}

if ($CGI{'file_attached_D'} ne "") {
open (FILED, ">$temp_directory/$newfilename_D$random_number.temp");
print FILED $CGI{'file_attached_D'}->{'Contents'};
close (FILED);
}

if ($CGI{'file_attached_E'} ne "") {
open (FILEE, ">$temp_directory/$newfilename_E$random_number.temp");
print FILEE $CGI{'file_attached_E'}->{'Contents'};
close (FILEE);
}

#############################
## PRINT RESULTS TO SCREEN ##
#############################

$CGI{'main_message'} =~ s/\cM\n/<BR>/g;

print<<"end_results";
<HTML>
<HEAD>
<TITLE>$your_page_title Results</TITLE>
</HEAD>
<BODY $body_specs>
<CENTER>
<H2 ALIGN=CENTER><FONT FACE=ARIAL>$your_page_title Results</FONT></H2>

<TABLE WIDTH=600 BORDER=0><TR><TD ALIGN=MIDDLE>
<H5><FONT FACE=ARIAL COLOR=#990000>Your message was successfully sent. Here is the results summary.
</FONT></H5>
</TD></TR></TABLE>
<TABLE WIDTH=600 BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR=#000000><TR><TD>
<TABLE WIDTH=100% BORDER=0 CELLPADDING=5 CELLSPACING=1 BGCOLOR=#FFFFFF>
<TR>
<TD VALIGN=TOP COLSPAN=2 BGCOLOR=#336699 ALIGN=MIDDLE>
<FONT FACE=ARIAL SIZE=+1 COLOR=#FFFFFF>Results Summary</FONT></TD></TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>Sender's Name: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $CGI{'name_sender'} </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>Sender's Email: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $CGI{'email_sender'} </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>Recipient's Name: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $CGI{'name_recipient'} </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>Recipient's Email: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $CGI{'email_recipient'} </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>Cc: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $CGI{'cc'} </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>Bcc: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $CGI{'bcc'} </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>Subject: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $CGI{'subject'} </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>1st File Attached: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $newfilename </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>2nd File Attached: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $newfilename_B </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>3rd File Attached: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $newfilename_C </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>4th File Attached: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $newfilename_D </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>5th File Attached: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>- $newfilename_E </FONT></TD>
</TR>
<TR>
<TD WIDTH=30% BGCOLOR=#DDDDDD ALIGN=RIGHT><FONT FACE=ARIAL SIZE=-1><B>Message: </FONT></B></TD>
<TD><FONT FACE=ARIAL SIZE=-1>$CGI{'main_message'} </FONT></TD>
</TR>
</TD></TR></TABLE>
</TD></TR></TABLE>
<BR><HR NOSHADE WIDTH=600>
<FONT FACE=ARIAL SIZE=-1>Mail-A-File &copy 1998-1999 <A HREF=http://icthus.net/CGI-City>CGI City</A></FONT>
<BR><BR><BR><BR>
</BODY></HTML>
end_results

}


##################
## MAIL ROUTINE ##
##################
$CGI{'main_message'} =~ s/<BR>/\cM\n/g;

####################
## FORMAT MESSAGE ##
####################
$msg = build MIME::MIME
	From    =>"$CGI{'name_sender'} <$CGI{'email_sender'}>",
	To      =>"$CGI{'name_recipient'} <$CGI{'email_recipient'}>",
	Cc	=>"$CGI{'cc'}",
	Bcc	=>"$CGI{'bcc'}",
	Subject =>"$CGI{'subject'}",
	Type    =>'multipart/mixed';

if ($CGI{'file_attached'} ne "") {
attach $msg 
	Type     =>"$CGI{'file_attached'}->{'Content-Type'}",
	Encoding =>'base64',
	Path     =>"$temp_directory/$newfilename$random_number.temp",
	Filename =>"$newfilename";
}

if ($CGI{'file_attached_B'} ne "") {
attach $msg 
	Type     =>"$CGI{'file_attached_B'}->{'Content-Type'}",
	Encoding =>'base64',
	Path     =>"$temp_directory/$newfilename_B$random_number.temp",
	Filename =>"$newfilename_B";
}

if ($CGI{'file_attached_C'} ne "") {
attach $msg 
	Type     =>"$CGI{'file_attached_C'}->{'Content-Type'}",
	Encoding =>'base64',
	Path     =>"$temp_directory/$newfilename_C$random_number.temp",
	Filename =>"$newfilename_C";
}

if ($CGI{'file_attached_D'} ne "") {
attach $msg 
	Type     =>"$CGI{'file_attached_D'}->{'Content-Type'}",
	Encoding =>'base64',
	Path     =>"$temp_directory/$newfilename_D$random_number.temp",
	Filename =>"$newfilename_D";
}

if ($CGI{'file_attached_E'} ne "") {
attach $msg 
	Type     =>"$CGI{'file_attached_E'}->{'Content-Type'}",
	Encoding =>'base64',
	Path     =>"$temp_directory/$newfilename_E$random_number.temp",
	Filename =>"$newfilename_E";
}

attach $msg 
	Type     =>'TEXT',
	Data     =>"

====================================================================
MAIN MESSAGE:
====================================================================

$CGI{'main_message'}
 


--------------------------------------------------------------------
This email was processed using CGI City's Mail-A-File script
CGI-City - http://icthus.net/CGI-City/ 
--------------------------------------------------------------------

 
 ";  

$msg->send;


###########################
### PRINT ERROR MESSAGE ###
###########################
sub PrintError { 
print<<"end1";
<HTML><HEAD><TITLE>$your_page_title - Error Encountered</TITLE></HEAD>
<BODY BGCOLOR="#FFFFFF"  text="#000000" link="#000099" vlink="#990000">
<CENTER>
<TABLE WIDTH=450 BORDER=0 CELLPADDING=1 CELLSPACING=0 BGCOLOR=#000000><TR><TD>
<TABLE WIDTH=100% BORDER=0 CELLPADDING=5 CELLSPACING=2 BGCOLOR=#FFFFFF>
<TR><TD BGCOLOR=#336699>
<FONT FACE=ARIAL SIZE=+1 COLOR=#FFFFFF><B>Error(s) Encountered</B></TD><TR>
<TR><TD><FONT FACE=ARIAL SIZE=-1>
<BR>
end1
print $message ;

print "<BR><BR></TD></TR></TABLE></TD></TR></TABLE>\n\n";
print "<BR><BR><HR NOSHADE WIDTH=600><FONT FACE=ARIAL SIZE=-1> \n\n";
print "Mail-A-File &copy 1998-1999 <A HREF=http://icthus.net/CGI-City>CGI City</A>\n\n";
print "</BODY></HTML>\n\n";
exit 0 ;
return 1 ; 
}


################################
##  CHECK FOR VALID REFERRER  ##
################################
sub check_referer {
   if (@referers && $ENV{'HTTP_REFERER'}) {
      foreach $referer (@referers) {
	 if ($ENV{'HTTP_REFERER'} =~ /$referer/) {
	    $ref = 1;
	    last;
	 }
      }
   }

   else {
      $ref = 1;
   }

   if ($ref != 1) {
      print "<HTML><HEAD>";
      print "<TITLE>$your_page_title - Error!</TITLE>";
      print "</HEAD><BODY $body_specs><CENTER><H2>Error!</H2>";
      print "$bad_referer\n\n";
      print "</CENTER></BODY></HTML>";
	exit;
   }
}