####################################################################
#                                                                  #
#  CGI_LIB.PL (c) by Simon Tneoh Chee-Boon                         #
#  Email: tneohcb@pc.jaring.my                                     #
#  URL:   http://www.tneoh.zoneit.com/perl/CGI_LIB/                #
#  Please visit the above URL for the latest information on        #
#  CGI-LIB.pl.                                                     #
#                                                                  #
#  THIS LIBRARY/MODULE IS BEING DISTRIBUTED AS PART OF             #
#  CGI CITY's MAIL-A-FILE SCRIPT IN ACCORDANCE WITH THE            #
#  GNU GENERAL PUBLIC LICENSE.                                     #
#                                                                  #
#  CGI CITY'S MAIL-A-FILE                                          #
#  Copyright (c) 1998 - CGI City - All rights reserved             #
#  Author: Peter N. Go - cgicity@icthus.net                        #
#                                                                  #
####################################################################
#                                                                  #
#  DISCLAIMER:                                                     #
#  In no event will CGI City be liable to the user of this script  #
#  or any third party for any damages, including any lost profits, #
#  lost savings or other incidental, consequential or special      #
#  damages arising out of the operation of or inability to operate #
#  this script, even if user has been advised of the possibility   #
#  of such damages.                                                #
#                                                                  #
####################################################################

sub Parse_Data {
    local($raw_data,@items,$key,$value);

    $raw_data = &Parse_Method;

    # Split different "NAME" and their values.
    @items = split('&', $raw_data);

    # For each list of "NAME=its_value".
    for (@items) {

        $_ =~ tr/+/ /;
        ($key,$value) = split('=',$_,2);

        # The %xx hex numbers are converted to alphanumeric.
        $key   =~ s/%(..)/pack("C", hex($1))/eg;
        $value =~ s/%(..)/pack("C", hex($1))/eg;
        if (grep(/^$key$/, keys(%CGI))) {
	  if (@{$CGI{$key}} > 0) {
            push(@{$CGI{$key}}, "$value");
          }
	  else {
	    $arrvalue = $CGI{$key};
	    undef $CGI{$key};
            $CGI{$key}[0] = $arrvalue;
	    push(@{$CGI{$key}}, "$value");
          }
        }
        else {
          $CGI{$key} = $value;
        }
     }
}

sub Print_Head {
    print "Content-Type: text/html\n\n";
}

sub Parse_Multi {
    local($boundary,@pairs,$position);
    local($raw_data,$value,$name,$part);

    $raw_data = &Parse_Method;
    ($boundary = $ENV{CONTENT_TYPE}) =~ s/^.*boundary=(.*)$/\1/;
    @pairs = split(/--$boundary/, $raw_data);
    @pairs = splice(@pairs,1,$#pairs-1);

    for $part (@pairs) {
      $part =~ s/[\r]\n$//g;
      ($dump, $firstline, $datas) = split(/[\r]\n/, $part, 3);
      next if $firstline =~ /filename=\"\"/;
      $firstline =~ s/^Content-Disposition: form-data; //;
      (@columns) = split(/;\s+/, $firstline);
      ($name = $columns[0]) =~ s/^name="([^"]+)"$/\1/g;
      if ($#columns > 0) {
	if ($datas =~ /^Content-Type:/) {
	  ($CGI{"$name"}->{'Content-Type'}, $blankline, $datas) = split(/[\r]\n/, $datas, 3);
          $CGI{"$name"}->{'Content-Type'} =~ s/^Content-Type: ([^\s]+)$/\1/g;
	}
	else {
	  ($blankline, $datas) = split(/[\r]\n/, $datas, 2);
	  $CGI{"$name"}->{'Content-Type'} = "application/octet-stream";
	}
      }
      else {
	($blankline, $datas) = split(/[\r]\n/, $datas, 2);
        if (grep(/^$name$/, keys(%CGI))) {
          if (@{$CGI{$name}} > 0) {
            push(@{$CGI{$name}}, $datas);
          }
          else {
            $arrvalue = $CGI{$name};
            undef $CGI{$name};
            $CGI{$name}[0] = $arrvalue;
            push(@{$CGI{$name}}, $datas);
          }
        }
        else {
	  next if $datas =~ /^\s*$/;
          $CGI{"$name"} = $datas;
        }
        next;
      }
      for $currentColumn (@columns) {
        ($currentHeader, $currentValue) = $currentColumn =~ /^([^=]+)="([^"]+)"$/;
        $CGI{"$name"}->{"$currentHeader"} = $currentValue;
      }
      $CGI{"$name"}->{'Contents'} = $datas;
    }
}

sub Parse_Method {
    local($buffer);

    if ($ENV{'REQUEST_METHOD'} eq "POST") {
      read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
      return $buffer;
    }
    elsif ($ENV{'REQUEST_METHOD'} eq "GET") {
      return $ENV{'QUERY_STRING'};
    }
    else {
      return 0;
    }
}
#END of CGI_LIB.pl library.
1; 
__END__

