@echo off

   cls
   echo ---------------------------
   echo PX/Win V2.0 to V3.0 upgrade
   echo ---------------------------

   set _bpxw_=

   Choice /c:yn "Continue with PX/Win 3.0 update? "

   if errorlevel 255 goto end
   if errorlevel 2 goto end
   if errorlevel 1 goto ask_backup
   Echo Update Aborted!
   goto end

:--------------------------------------------------------
:ask_backup
:--------------------------------------------------------

   Choice /c:yn "Do you wish to backup your current PX/WIN v2.0 setup? "
   if errorlevel 255 goto end
   if errorlevel 2 goto start
   if errorlevel 1 set _bpxw_=Y
   if errorlevel 1 goto start
   Echo Update Aborted!
   goto end

:--------------------------------------------------------
:start
:--------------------------------------------------------

   if "%_bpxw_%" == "" goto :skip_backup

   echo Performing backup of current setup (using PKZIP)...
   pkzip -pr pxw20old -x*.zip -x*.log
   echo Backup complete. pxw20old.zip created

:--------------------------------------------------------
:skip_backup
:--------------------------------------------------------

   Echo Starting Upgrade......
   Goto begin_upgrade

:--------------------------------------------------------
:begin_upgrade
:--------------------------------------------------------
Echo Unzipping files.....

   if exist main.zip pkunzip -o main > update30.log
   if exist bonus.zip pkunzip -o bonus >> update30.log
   if exist help.zip pkunzip -o help >> update30.log
   if exist manual.zip pkunzip -o manual >> update30.log

   if not exist default.zip goto erase_zips
   pkunzip -o default system\ >> update30.log

   if exist admin.ini goto erase_zips
   pkunzip -o default admin.in_
   if exist admin.in_ rename admin.in_ admin.ini

:--------------------------------------------------------
:erase_zips
:--------------------------------------------------------
Echo Erasing zip files.....

   if exist main.zip erase main.zip
   if exist bonus.zip erase bonus.zip
   if exist default.zip erase default.zip
   if exist help.zip erase help.zip
   if exist manual.zip erase manual.zip

:--------------------------------------------------------
:repair_databases
:--------------------------------------------------------
Echo Running PXREPAIR to clean up current databases.....

   pxrepair /all >> update30.log
   goto success

:--------------------------------------------------------
:success
:--------------------------------------------------------

   Echo Update complete. If you have not done so, please read Readme.txt
   goto end

:--------------------------------------------------------
:end
:--------------------------------------------------------
set _bpxw_=

