// Version: 2.0
// Class name: TSpeedBitmap = class (TBitmap)
// Author: Practical Soft <practicalsoft@usa.net>
// Creation Date: 18 Mar 1998
// Description: TBitmap descendant that has a very fast way to access each pixel.
// Warning:	No range checking is performed for faster performance!
//          PixelFormat must be pf24bit
// History: 16 Apr 1998 - Corrected bug of 'byte alignment'
//          01 Nov 1998 - PixelFormat set to pf24bit automatically

unit speedBitmap;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

const
  REGISTERED_VERSION = TRUE;

type
  TSpeedBitmap = class (TBitmap)
  private
    { Private declarations }
    dataBits : pointer; //PRGBArray;
    realByteWidth : integer;
    procedure setPixel(x, y : integer; color : TRGBTriple);
    function getPixel(x, y : integer) : TRGBTriple;
  protected
    { Protected declarations }
    procedure Changed(Sender: TObject); override;
  public
    { Public declarations }
    constructor Create; override;

    // the pixels are accessed by this property
    // note that no range checking is performed for faster performance!
    property bits[x, y : integer] : TRGBTriple read getPixel write setPixel;
  end;


implementation


constructor TSpeedBitmap.Create;
begin
	inherited create;

	dataBits := nil;

  randomize;
  if not REGISTERED_VERSION then
    if random(15) = 1 then
      showMessage('Speed Bitmap By Practical Soft! practicalsoft@usa.net');
end;


procedure TSpeedBitmap.setPixel(x, y : integer; color : TRGBTriple);
var pRgbDeFacto: PRGBTriple;
    pMem: integer;
begin
  //uncomment if you wish range checking
	//if (x >= 0) and (x < width) and (y >= 0) and (y < height) then begin
    pMem := longint(databits) - (y * realByteWidth) + (x shl 1) + x;
		pRgbDeFacto:=Pointer(pMem);
		pRgbDeFacto^:=color;
  //end;
end;


function TSpeedBitmap.getPixel(x, y : integer) : TRGBTriple;
var pRgbDeFacto: PRGBTriple;
    pMem: integer;
begin
  //uncomment if you wish range checking
	//if (x >= 0) and (x < width) and (y >= 0) and (y < height) then begin
    pMem := longint(databits) - (y * realByteWidth) + (x shl 1) + x;
		pRgbDeFacto:=Pointer(pMem);
		getPixel := pRgbDeFacto^;
  //end;
end;


procedure TSpeedBitmap.Changed(Sender: TObject);
var frstLinePt : pointer;
    inverted : integer;
begin
	inherited changed(Sender);

  inverted := 1;

  realByteWidth := (((width * 24) + 31) and not 31 ) div 8;
  realByteWidth := realByteWidth*inverted;

  frstLinePt := ScanLine[0];
	dataBits := frstLinePt;

  PixelFormat := pf24bit;
end;


end.
