unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, AHMDialogClass, AHMTTipTrickDlg,Registry;

type
  TForm1 = class(TForm)
    AHMTipTricks1: TAHMTipTricks;
    MainMenu1: TMainMenu;
    Tips1: TMenuItem;
    Loadmoretips1: TMenuItem;
    N1: TMenuItem;
    HideCustomButtons1: TMenuItem;
    ShowTipDialogsonStartup1: TMenuItem;
    N2: TMenuItem;
    ShowTipsnow1: TMenuItem;
    N3: TMenuItem;
    QuitthisExample1: TMenuItem;
    OpenDialog1: TOpenDialog;
    procedure QuitthisExample1Click(Sender: TObject);
    procedure ShowTipsnow1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AHMTipTricks1NewTip(Sender: TObject; TipNo: Integer);
    procedure AHMTipTricks1Custom1(Sender: TObject);
    procedure HideCustomButtons1Click(Sender: TObject);
    procedure ShowTipDialogsonStartup1Click(Sender: TObject);
    procedure Loadmoretips1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure AHMTipTricks1CheckClick(Sender: TObject);
    procedure AHMTipTricks1Custom2(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  IsTips : Boolean;

implementation

{$R *.DFM}

procedure TForm1.QuitthisExample1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.ShowTipsnow1Click(Sender: TObject);
begin
  AHMTipTricks1.Execute;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  IsTips:=True;
  with TRegIniFile.Create('\Software\AHM\Dialogs\') do
  try
    RootKey := HKEY_CURRENT_USER;
    OpenKey('\Software\AHM\Dialogs\',True);
    if ReadBool('Example','Buttons',False) then HideCustomButtons1Click(Self);
    if not(ReadBool('Example','Tips',True)) then ShowTipDialogsonStartup1Click(Self);
    CloseKey;
  finally
    Free;
  end;
  AHMTipTricks1.Execute;
end;

procedure TForm1.AHMTipTricks1NewTip(Sender: TObject; TipNo: Integer);
begin
  with AHMTipTricks1 do
  if not(IsTips) then Custom1BitBtn.Enabled:=False else
  case TipNo of
    0,1,2 : Custom1BitBtn.Enabled:=True;
  else
    Custom1BitBtn.Enabled:=False;
  end;
end;

procedure TForm1.AHMTipTricks1Custom1(Sender: TObject);
begin
  with AHMTipTricks1 do
  if IsTips then
  case CurrentTip of
    0 : Loadmoretips1Click(Self);
    1 : if not(HideCustomButtons1.Checked) then HideCustomButtons1Click(Self);
    2 : ShowTipDialogsonStartup1Click(Self);
  end;
end;

procedure TForm1.HideCustomButtons1Click(Sender: TObject);
begin
  HideCustomButtons1.Checked:=not(HideCustomButtons1.Checked);
  with AHMTipTricks1 do
  begin
    Custom1BitBtn.Visible:=not(HideCustomButtons1.Checked);
    Custom2BitBtn.Visible:=not(HideCustomButtons1.Checked);
  end;
end;

procedure TForm1.ShowTipDialogsonStartup1Click(Sender: TObject);
begin
  ShowTipDialogsonStartup1.Checked:=not(ShowTipDialogsonStartup1.Checked);
  AHMTipTricks1.SetupCheckbox.Checked:=ShowTipDialogsonStartup1.Checked;
  ShowTipsNow1.Enabled:=ShowTipDialogsonStartup1.Checked;
end;

procedure TForm1.Loadmoretips1Click(Sender: TObject);
begin
  with opendialog1 do
  begin
    InitialDir:=ExtractFilePath(Application.ExeName);
    FileName:='';
    If Execute then
    begin
      IsTips:=False;
      AHMTipTricks1.Tips.LoadFromFile(FileName);
      AHMTipTricks1.NextTip;
    end;
  end;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  with TRegIniFile.Create('\Software\AHM\Dialogs\') do
  try
    RootKey := HKEY_CURRENT_USER;
    OpenKey('\Software\AHM\Dialogs\',True);
    WriteBool('Example','Tips',ShowTipDialogsonStartup1.Checked);
    WriteBool('Example','Buttons',HideCustomButtons1.Checked);
    CloseKey;
  finally
    Free;
  end;
end;

procedure TForm1.AHMTipTricks1CheckClick(Sender: TObject);
begin
 if ShowTipDialogsonStartup1.Checked<>AHMTipTricks1.SetupCheckbox.Checked then
 ShowTipDialogsonStartup1Click(Self);
end;

procedure TForm1.AHMTipTricks1Custom2(Sender: TObject);
begin
  AHMTiptricks1.CloseTips;
end;

end.
