unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AHMDialogClass, AHMTFolderBrowser, Buttons, StdCtrls;

type
  TForm1 = class(TForm)
    AHMFolderBrowser1: TAHMFolderBrowser;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    SpeedButton1: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure AHMFolderBrowser1Cancel(Sender: TObject);
    procedure AHMFolderBrowser1BeforeBrowse(Sender: TObject);
    procedure AHMFolderBrowser1IsValidPath(Sender: TObject;
      const NewPath: String; var ValidPath: Boolean);
    procedure AHMFolderBrowser1PathChanged(Sender: TObject;
      const NewPath: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  with AHMFolderBrowser1 do
  if Execute then Edit1.Text:=ReturnPath;
end;

procedure TForm1.AHMFolderBrowser1Cancel(Sender: TObject);
begin
  Edit1.Text:='';
end;

procedure TForm1.AHMFolderBrowser1BeforeBrowse(Sender: TObject);
begin
  AHMFolderBrowser1.ReturnPath := Edit1.text;
end;

procedure TForm1.AHMFolderBrowser1IsValidPath(Sender: TObject;
  const NewPath: String; var ValidPath: Boolean);
begin
  if FileExists(NewPath+'\AHMTFolderBrowser.dcu') then ValidPath:=True else ValidPath:=False;
end;

procedure TForm1.AHMFolderBrowser1PathChanged(Sender: TObject;
  const NewPath: String);
begin
  if FileExists(NewPath+'\AHMTFolderBrowser.dcu') then
  Edit1.Text:=NewPath else Edit1.Text:='';
end;

end.
