/*
 * Unattended
 * Copyright (c) 1999 Kirby Kuehl (vacuum@technotronic.com)
 * This code will insert the necessary unique information
 * in msbatch.inf (Windows 95) and unattend.txt (Windows NT) files
 * 
 * - Computername: Obviously NetBIOS computernames have to be unique
 * - Domain: If you are in a multi-domain environment having the ability
 *   to join different domains is nice.
 * - Timezone: Self Explanatory
 * - Username: Maybe you want unique information
 *
 * You must have unnattend.tpl and msbatch.tpl (the template files)
 * in the same working directory.
 * I suggest that you create your own .tpl templates to suit your
 * personal needs.
 * Windows 95 msbatch.inf creation.
 * Batch.exe can be found on the Windows 95 CD
 * under \Admin\Nettools\bsetup (readme.txt explains it)
 * 
 * Windows NT unattend.txt creation
 * Setupmgr.exe can be found on the Windows NT Server CD
 * under \Support\Deptools\i386
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define COMPANYNAME "Your Company Here"
#define VERSION "0.2"

int Config95(char *,char *,char *,char *);
int ConfigNT(char *,char *,char *,char *);

void main (void)
{

	char computername[20];
	char username[25];
	char domain[25];
	char tz[20];
	char platform[20];
	char correct[20];
	char *timezone;
	int length;

	printf("%s Unattended Installation %s\n",COMPANYNAME,VERSION);
	printf("vacuum@technotronic.com\n\n");
	
	// Platform
	printf("Choose Platform:\n");
	printf("Enter '95' for Windows 95\n");
	printf("Enter 'NT' for Windows NT\n");
	scanf("%s", platform);
	_strupr(platform);	

	if (strncmp(platform, "NT", 3)==0) 
	{
		printf("Launching NT Configuration.\n");
	}
	else
		if (strncmp(platform, "95", 3)==0) 
		{
			printf("Launching 95 Configuration.\n");
		}
		else
		{
			printf("Invalid Platform, you must enter 95 or NT.\n");
			exit(-1);
		}

       
	// NetBIOS Computername
    printf("Enter computername\n");
	scanf("%s", computername);
	
	length = strlen(computername);

	if (length > 16) 
	{
		printf("Invalid NetBIOS name. Must be less than 16 characters.\n");
		exit(-1);
	}
    // User Name

	printf("Enter user name\n");
	scanf("%s", username);
	
	// Domain Name
	printf("Enter domain name\n");
	scanf("%s", domain);
	_strupr(domain);
	
	printf("Domain: %s\n",domain);
   	

	printf("Timezone:\n");
	printf("Enter 'EST' for (GMT-05:00) Eastern Time (US & Canada)\n");
	printf("Enter 'CST' for (GMT-06:00) Central Time (US & Canada)\n");
	printf("Enter 'MST' for (GMT-07:00) Mountain Time (US & Canada)\n");
	printf("Enter 'PST' for (GMT-08:00) Pacific Time (US & Canada)\n");

	scanf("%s", tz);
  	_strupr(tz);

	// NT and 95 unattended configurations use different timezone fields
	if (strncmp(platform, "NT", 3)==0) 
	{
		if (strncmp(tz, "EST", 4)==0)
		timezone = "(GMT-05:00) Eastern Time (US & Canada)";
		else if (strncmp(tz, "CST", 4)==0)
			timezone = "(GMT-06:00) Central Time (US & Canada)";
		else if (strncmp(tz, "MST", 4)==0)
			timezone = "(GMT-07:00) Mountain Time (US & Canada)";
		else if (strncmp(tz, "PST", 4)==0)
			timezone = "(GMT-08:00) Pacific Time (US & Canada)";
		else
		{
			printf("Invalid Timezone, choose EST, CST, MST, or PST.\n");
			exit(-1);
		}
	}
	else
		if (strncmp(platform, "95", 3)==0) 
		{
			if (strncmp(tz, "EST", 4)==0)
				timezone = "Eastern";
			else if (strncmp(tz, "CST", 4)==0)
				timezone = "Central";
			else if (strncmp(tz, "MST", 4)==0)
				timezone = "Mountain";
			else if (strncmp(tz, "PST", 4)==0)
				timezone = "Pacific";
			else
			{
				printf("Invalid Timezone, choose EST, CST, MST, or PST.\n");
				exit(-1);
			}
		}
    
	

	printf("Parameters\n\n");
    printf("Platform    : %s\n", platform);
//	printf("Model       : %s\n", &model);
	printf("Computername: %s\n", computername);
	printf("User Name   : %s\n", username);
	printf("Domain Name : %s\n", domain);
	printf("Time Zone   : %s\n", tz);

	printf("Is the above correct? (Y/N)\n");
	scanf("%s",correct);
	_strupr(correct);

		if (strstr(correct, "Y"))
		{
			if (strstr(platform, "NT"))
				{
				ConfigNT(computername, username, domain, timezone);
				}
			else
				if (strstr(platform, "95"))
				{
				Config95(computername, username, domain, timezone);
				}
		}

			else
			exit(-1);
}
	
	
	
int Config95(char *computername, char *username, char *domain, char *timezone)

{
//	char model, computername,username,domain,timezone;
	FILE *stream, *stream2;
	int numclosed;
		char string[256];
		printf("Launching windows95 config\n");
		if( (stream  = fopen( "msbatch.tpl", "r" )) == NULL )
		{
			printf( "Could not open 'msbatch.tpl'\n" );
			exit(-1);
		}

		if( (stream2 = fopen( "msbatch.inf", "w" )) == NULL )
		{
			printf( "The file 'msbatch.inf' was not opened\n" );
		}


		while(fgets(string, sizeof(string), stream))
		// Username
		if (strncmp(string, "Name=", 5)==0)
		{
			fprintf(stream2, "Name= \"%s\" \n", username);
		}
		else
            // Computername
			if (strncmp(string, "ComputerName=", 13)==0)
			{
				fprintf(stream2, "ComputerName = \"%s\"\n", computername);
			}
			else
				// Domain
				if (strncmp(string, "LogonDomain=", 12)==0)
				{
					fprintf(stream2, "LogonDomain=\"%s\"\n", domain);
				}
				else
					if (strncmp(string, "TimeZone=", 9)==0)
					{
						fprintf(stream2, "TimeZone=\"%s\"\n", timezone);
					}
				
					else
						fputs(string,stream2);

 
if( fclose( stream ) )
      printf( "The file 'data' was not closed\n" );

   numclosed = _fcloseall( );


			exit(0);
}


int ConfigNT(char *computername, char *username, char *domain, char *timezone)

{
	// char model, computername,username,domain,timezone;	
	char string[256];
	FILE *stream, *stream2;
	int numclosed;
	printf("Creating UNATTEND.TXT\n");

		if( (stream  = fopen( "unattend.tpl", "r" )) == NULL )
		{
			printf( "Could not open 'unattend.tpl'\n" );
			exit(-1);
		}

		if( (stream2 = fopen( "unattend.txt", "w" )) == NULL )
		{
			printf( "The file 'unattend.txt' was not opened\n" );
		}


		while(fgets(string, sizeof(string), stream))

		if (strstr(string, "FullName = "))
		{
			fprintf(stream2, "FullName = %s\n", username);
		}
		else

			if (strstr(string, "ComputerName = "))
			{
				fprintf(stream2, "ComputerName = %s\n", computername);
			}
			else
				if (strstr(string, "JoinDomain = "))
				{
					fprintf(stream2, "JoinDomain = %s\n", domain);
				}

				else
					if (strncmp(string, "TimeZone=", 9)==0)
					{
						fprintf(stream2, "TimeZone = \"%s\"\n", timezone);
					}
				
					else
						fputs(string,stream2);
 
if( fclose( stream ) )
      printf( "The file 'data' was not closed\n" );

   numclosed = _fcloseall( );


			exit(0);
}

	   



   

