#!/usr/local/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation (formerly Madrona Park, Inc.), 1997, 1998.
#
#       ------------ cpanel3.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT redistribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Infopop Corporation (formerly Madrona Park, Inc.) offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "cookie-lib.pl";
require "mods.file";
require "UltBB.setup";
require "ubb_library.pl";
require "ubb_library2.pl";
require "Date.pl";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}


&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	
		if ($Name eq "Header") {
			$Header = $Value;
			$Header =~ s/"/\\"/g;
			$Header =~ s/\@/\\@/g;
			}
		if ($Name eq "Footer") {
			$Footer = $Value;
			$Footer =~ s/"/\\"/g;
			$Footer =~ s/\@/\\@/g;
			}
	
	
	if ($Name eq "number") {
			$number = $Value;
			}

	if ($Name eq "ForumsPath") {
			$ForumsPath = $Value;
			}
			if ($Name eq "MembersPath") {
			$MembersPath = $Value;
			}
			if ($Name eq "CGIPath") {
			$CGIPath = $Value;
			}
				if ($Name eq "VariablesPath") {
			$VariablesPath = $Value;
			}
	if ($Name eq "MembersCGIPath") {
			$MembersCGIPath = $Value;
			}
			if ($Name eq "NonCGIPath") {
			$NonCGIPath = $Value;
			}
			if ($Name eq "CGIURL") {
			$CGIURL = $Value;
			}
			if ($Name eq "NonCGIURL") {
			$NonCGIURL = $Value;
			}
		
		if ($Name eq "UserNameCheck") {
			$UserNameCheck = $Value;
			$UserNameCheckFile = $UserNameCheck;
			$UserNameCheckFile =~ s/ /_/g; #remove spaces
			}

		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserName = &UNHTMLIFY($UserName);
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
		}
			if ($Name eq "Password") {
			$Password = $Value;
			$Password = &UNHTMLIFY($Password);
			}
			if ($Name eq "PasswordCheck") {
			$PasswordCheck = $Value;
			}
				if ($Name eq "action") {
			$action = $Value;
			}
			
} #end foreach loop

if ($VariablesPath eq "") {
	$VariablesPath = "$CGIPath";
}

if ($action eq "misc") {
&Misc;
}

if ($action eq "ContinueRemoveHTML") {
#verify admin
&RemoveHTML;
}

if ($action eq "ContinueMemberUpdate") {
#verify admin
&DoRebuildMembers;
}
sub Misc {
#verify admin
$ProfileNumber = &GetUserNumber($in{'UserName'});

@theprofile = &OpenProfile("$ProfileNumber.cgi");

if ($in{'Password'} eq "$theprofile[1]") {
	$Status = "$theprofile[8]";
	   if ($Status eq "Administrator") {
			&DoMisc;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		} #end if adminstatus is true 
}  else {
&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}

}

sub DoMisc {
$Choice= $in{'Choice'};

if ($Choice eq "0") {
&StandardHTML("Sorry, but failed to provide a valid selection.  Please try again.  Use your Back button.");
}
elsif ($Choice eq "1") {
&RemoveHTML;
exit;
}  else {
&DoRebuildMembers;
exit;
} 

}


sub RemoveHTML {
#remove old HTML files left over from deleted multi-HTML page topics

#confirm identity
if ($action = "ContinueRemoveHTML") {
&get_cookie;  #retrieves all current cookies
if ($cookie{UserNameCP}) {
$CheckUserName = "$cookie{UserNameCP}";
$CheckPassword = "$cookie{PasswordCP}";
}
elsif ($in{'UserName'}) {
$CheckUserName = $in{'UserName'};
$CheckPassword = $in{'Password'};
}  else {
$PageTitle = "P R O F I L E &nbsp;&nbsp;&nbsp;&nbsp; V I E W";
$PageIntro = "In order to view this person's profile, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="action" VALUE="getbio4admin"><INPUT TYPE="HIDDEN" NAME="UserNumber" VALUE="$ProfileNum">
 );
&QueryForID;
exit;
}

#confirm permission to read forum data
&VerifyAdminCP($CheckUserName, $CheckPassword);
}

@sortforums = &OpenForumsFile;
$TotalForums = @sortforums;

if ($number eq "") {
$number = "1";
}

@thisforum = &GetForumRecord($number);
$x = "$thisforum[8]";
$ForumName = $thisforum[1];
if ($thisforum[6] eq "private") {
	$ExactPath = "Forum$x/private-$thisforum[7]";
	if ($thisforum[13] eq "yes") {
	$Ext  = "cgi";
	}  else {
	$Ext  = "html";
	}
} else {
	$ExactPath = "Forum$x";
	$Ext  = "html";
}


opendir (FORUMDIR, "$ForumsPath/$ExactPath/HTML"); 
    @HTMLfiles = readdir(FORUMDIR);
closedir (FORUMDIR);

@multipagers = grep(/-/, @HTMLfiles);

$RemoveCount = 0;

foreach $multi(@multipagers) {
chomp($multi);
	($topicnum, $junk) = split(/-/, $multi);
	$OrigTopic = ("$topicnum"  . "."  . "$Ext");
	unless (-e "$ForumsPath/$ExactPath/HTML/$OrigTopic") {
	$RemoveCount++;
			unlink("$ForumsPath/$ExactPath/HTML/$multi");
	}
	
}


if ($x < $TotalForums) {
$NextForum = $x + 1;
$ActionWording = qq(We are removing any unneccessary files from the HTML directories.  <P>We just finished processing <FONT FACE="Verdana" SIZE="2" COLOR="Navy">Forum$x - $ForumName </font>.<P> HTML Files deleted in that forum: <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$RemoveCount</FONT>.  <P>Please wait while we $RemoveCount unnecessary files were deleted. <P><b>Please wait as we continue processing!</B></FONT>);
$ForwardURL = "$CGIURL/cpanel4.cgi?action=ContinueRemoveHTML&number=$NextForum";
&ContinueThis($ForwardURL, $ActionWording);
}  else {
&StandardHTML("Thank you.  We have finished processing this request.");
}

}  #end RemoveHTML sr



sub CloseForums {
open(STATUS, ">$MembersPath/status.file");
print STATUS "closed";
close(STATUS);
chmod(0666, "$MembersPath/status.file");
}

sub OpenForums {
unlink("$MembersPath/memholder.cgi");
open(STATUS, ">$MembersPath/status.file");
print STATUS "open";
close(STATUS);
unlink("$MembersPath/status.file");
}

sub DoRebuildMembers {
$StartPoint = $in{'StartPoint'};

#confirm identity
if ($action = "ContinueMemberUpdate") {
&get_cookie;  #retrieves all current cookies
if ($cookie{UserNameCP}) {
$CheckUserName = "$cookie{UserNameCP}";
$CheckPassword = "$cookie{PasswordCP}";
}
elsif ($in{'UserName'}) {
$CheckUserName = $in{'UserName'};
$CheckPassword = $in{'Password'};
}  else {
$PageTitle = "P R O F I L E &nbsp;&nbsp;&nbsp;&nbsp; V I E W";
$PageIntro = "In order to view this person's profile, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="action" VALUE="getbio4admin"><INPUT TYPE="HIDDEN" NAME="UserNumber" VALUE="$ProfileNum">
 );
&QueryForID;
exit;
}

#confirm permission to read forum data
&VerifyAdminCP($CheckUserName, $CheckPassword);
}

if ($in{'Finalize'} eq "true") {
open (MEMFILE, "$MembersPath/memberslist2.cgi");
@memlist = <MEMFILE>;
close (MEMFILE);

open (EMAILFILE, "$MembersPath/emailfile2.cgi");
@emlist =<EMAILFILE>;
close (EMAILFILE);

&CloseForums;  #temporarily

open (MEMFILE, ">$MembersPath/memberslist.cgi");
foreach $member(@memlist) {
chomp($member);
print MEMFILE "$member\n";
}
close (MEMFILE);

open (EMAILFILE, ">$MembersPath/emailfile.cgi");
foreach $emfile(@emlist) {
chomp($emfile);
print EMAILFILE "$emfile\n";
}
close (EMAILFILE);

chmod (0666, "$MembersPath/emailfile.cgi");
chmod (0666, "$MembersPath/memberslist.cgi");
unlink("$MembersPath/emailfile2.cgi");
unlink("$MembersPath/memberslist2.cgi");

&OpenForums;
&StandardHTML("Thank you, we have finished reconciling your member records!");
exit;

}

if ($StartPoint eq "") {
opendir(MEMS , "$MembersPath");
@themems = readdir(MEMS);
closedir(MEMS);
@thesemems = grep(/\d\.cgi/, @themems);
@mems = sort (@thesemems);

open(MEMHOLDER, ">$MembersPath/memholder.cgi");
foreach $memo(@mems) {
chomp($memo);
print MEMHOLDER "$memo\n";
}
close(MEMHOLDER);
chmod(0666, "$MembersPath/memholder.cgi");

}  else {
#open temp file if it exists...
open(MEMHOLDER, "$MembersPath/memholder.cgi");
@thesemems = <MEMHOLDER>;
close(MEMHOLDER);
@mems = sort (@thesemems);
}

$TotalMembers = @mems;
#process member files in chunks of 5

my $MaxDisplay = 250;  
if ($StartPoint eq "") {
	$StartPoint = 1;
	if ($TotalMembers <= $MaxDisplay) {
		$EndPoint = $TotalMembers;
		$Done = "true";
	} else {
	$Done = "";
	$EndPoint = $MaxDisplay;
	}
	$EP = $EndPoint - 1;

} else {

$EndPoint = $StartPoint + $MaxDisplay;
$EndPoint = $EndPoint - 1;
	if ($TotalMembers <= $EndPoint) {
		$EndPoint = $TotalMembers;
		$Done = "true";
	}  else {
		$Done = "";
	}

}

$SP = $StartPoint - 1;
$EP = $EndPoint - 1;
@finalmems = @mems[$SP..$EP];

foreach $uno(@finalmems) {
chomp($uno);

my @memfile = &OpenFile("$MembersPath/$uno");
chomp($memfile[0]);
chomp($memfile[2]);

if (($memfile[0] ne "") && ($memfile[2] ne "")) {
($memnum, $junk) = split(/\./, $uno);

#append memberslist
$MemLine = ("$memfile[0]" . "|!!|" . "$memnum");
push(@memfile2, $MemLine);

#append emailfile
$EmailLine = ("$memfile[2]" . "||" . "$memnum");
push(@emailfile, $EmailLine);

}
}


if ($in{'action'} eq "ContinueMemberUpdate") {

open (MEM2, ">>$MembersPath/memberslist2.cgi");
foreach $mem5(@memfile2) {
print MEM2 "$mem5\n";
}
close (MEM2);

open (EM2, ">>$MembersPath/emailfile2.cgi");
foreach $emfile(@emailfile) {
print EM2 "$emfile\n";
}
close (EM2);

}  else {

open (MEMFILE, ">$MembersPath/memberslist2.cgi");
foreach $mem6(@memfile2) {
print MEMFILE "$mem6\n";
}
close (MEMFILE);

open (EMAILFILE, ">$MembersPath/emailfile2.cgi");
foreach $emfile(@emailfile) {
print EMAILFILE "$emfile\n";
}
close (EMAILFILE);

chmod (0777, "$MembersPath/emailfile2.cgi");
chmod (0777, "$MembersPath/memberslist2.cgi");
}


if ($Done ne "true") {
$NextStart = $EndPoint + 1;
$ActionWording = qq(We are econciling your registered member database.  Please wait as we continue procesing.  <P>We just finished processing members <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$StartPoint - $EndPoint</font>.<P><b>Please wait as we continue processing!</B></FONT>);
$ForwardURL = "$CGIURL/cpanel4.cgi?action=ContinueMemberUpdate&StartPoint=$NextStart";
&ContinueThis($ForwardURL, $ActionWording);
exit;
} else {
$NextStart = $EndPoint + 1;
$ActionWording = qq(We are econciling your registered member database.  Please wait as we continue procesing.  <P>We just finished processing members <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$StartPoint - $EndPoint</font>.<P><b>Please wait as we continue processing!</B></FONT>);
$ForwardURL = "$CGIURL/cpanel4.cgi?action=ContinueMemberUpdate&StartPoint=$NextStart&Finalize=true";
&ContinueThis($ForwardURL, $ActionWording);
exit;

}


} #end dorebuildmems
