#!/usr/local/bin/perl

#
### CONTROL PANEL UBB SCRIPT - EDIT/PRUNE FUNCTIONS ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation (formerly Madrona Park, Inc.), 1997, 1998, 1999.
#
#       ------------ edit.cgi -------------
#
#  This file contains most of the edit/prune functionality for the
#  UBB... used in the control panel.
#
# Infopop Corporation (formerly Madrona Park, Inc.) offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "Date.pl";
require "mods.file";
require "ubb_library.pl";
require "ubb_library2.pl";
require "cookie-lib.pl";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

print ("Content-type: text/html\n\n");

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "UserName") {
			$UserName = $Value;
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
			}
	
	if ($Name eq "Password") {
			$Password = $Value;
			}
}  ## END FOREACH $row


if ($in{'forum'} =~ /Forum\d/) {
	($junk, $number) = split(/orum/, $in{'forum'});
}

if ($in{'ForumNumber'} =~ /Forum\d/) {
	($junk, $number) = split(/orum/, $in{'ForumNumber'});
}


if (-e "$ForumsPath/Forum$number/forumstyles.file") {
require "$ForumsPath/Forum$number/forumstyles.file";
}  else {
require "$VariablesPath/Styles.file";
}

#create random numbers for headers/footers
$RandomNumber = &MakeRandomNumber;
$RandomNumber2 = $RandomNumber + 100074;

if (-e "$ForumsPath/Forum$number/forumstyles.file") {

if ($ForumHeader ne "") {
$Header = $ForumHeader;
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}
if ($ForumFooter ne "") {
$Footer = $ForumFooter;
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}
}  else {
if ($Header ne "") {
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}
if ($Footer ne "") {
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}

}

#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}
if ($in{'EditFunction'} eq "Prune") {
	&DoPrune(PruneByDate);
}

if ($in{'EditFunction'} eq "PruneUser") {
	&DoPrune(PruneByUser);
}
if ($in{'EditFunction'} eq "Delete") {
	&DoDelete;
}

if ($in{'EditFunction'} eq "ContinueIndexUpdate") {
	&UpdateTheIndex($in{'number'}, $in{'threadpoint'});
}
if ($in{'EditFunction'} eq "Edit") {
	&DoEdit;
}

if ($in{'EditFunction'} eq "AdminEditThisForum") {
	&AdminEditForum;
}
if ($in{'EditFunction'} eq "GetEditThreads") {
	&GetEditThreads;
}
if ($in{'EditFunction'} eq "GetExactEditMessage") {
	&GetExactEditMessage;
}
if ($in{'EditFunction'} eq "DoMessageEdit") {
	&DoMessageEdit;
}
if ($in{'EditFunction'} eq "PruneThisForum") {
	&PruneThisForum;
	}
if ($in{'EditFunction'} eq "SubmitPrune") {
	&SubmitPrune;
	}
if ($in{'EditFunction'} eq "DoSubjectEdit") {
	&DoSubjectEdit;
	}
if ($in{'EditFunction'} eq "DoDeleteThread") {
	&DoDeleteThread;
	}

sub SubmitPrune {

####

&get_cookie;  #retrieves all current cookies
if ($cookie{UserNameCP}) {
$CheckUserName = "$cookie{UserNameCP}";
$CheckPassword = "$cookie{PasswordCP}";
}
elsif ($in{'UserNameCheck'}) {
$CheckUserName = $in{'UserNameCheck'};
$CheckPassword = $in{'PasswordCheck'};
}  else {
$PageTitle = "F O R U M &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S";
$PageIntro = "In order to view this forum's settings, you must first identify yourself.  You will not have to do this each time if you allow cookies to be set from your browser.";
$HiddenFields = qq(<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="SubmitPrune">
<INPUT TYPE="HIDDEN" NAME="Style" VALUE="PruneByUser">
<INPUT TYPE="HIDDEN" NAME="ForumNumber" VALUE="$in{'ForumNumber'}">
<INPUT TYPE="HIDDEN" NAME="MatchUser" VALUE="$in{'MatchUser'}">
<INPUT TYPE="HIDDEN" NAME="RegName" VALUE="$in{'RegName'}">);
&QueryForEditID;
exit;
}

($trash, $number) = split(/orum/, $in{'ForumNumber'});
#confirm permission to read forum data
&VerifyAdminMod2($CheckUserName, $CheckPassword);

if ($Proceed eq "true") {
		&DoThePrune;
		}  else {
		&StandardHTML("Sorry, but you are not authorized to proceed.  Perhaps you mistyper your username and/or password.  Use your Back button to try again.");
	}
}  ## End SubmitPrune sr

	
sub DoPrune {
my $Type = shift;

#check to make sure we have enough parameters
if ($Type eq "PruneByUser") {
if (($in{'DeleteName'} eq "") || ($in{'DeleteRegName'} eq "")) {
&StandardHTML("You either forgot to enter the name of the user whose posts you wish to delete or you forgot to check whether the name was registered or not.");
$MissingData = "true";
exit;
}

}

if ($MissingData ne "true") {

$NameFound = "no";
## identify user-- moderator/administrator/neither
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$ProfileNumber.cgi");
	
	if ($Password eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	   if ($AdminStatus eq "true") {
	   &PruneThis(Admin, $Type);
	   } 
	    elsif ($ModStatus eq "true") {
	   &PruneThis(Mod, $Type);
	   }
	   else  {
	   &StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but no one is registered with the User Name you listed.  Please try again.  Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} #end if missing date ne true
}  ## END DoPrune

sub DoMessageEdit {
## confirm that user is authorized
$UNCheck = $in{'UserNameCheck'};

$ProfileNumber = &GetUserNumber($UNCheck);

@profilestats = &OpenProfile("$ProfileNumber.cgi");

if ($in{'PasswordCheck'} eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")){
			&PerformTheEdit;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
}

}  else {
&StandardHTML("Sorry, the password you supplied is incorrect.  Please use your back button to try again!");
} # END IF/ELSE
}  ## End DoMessageEdit sr


sub GetExactEditMessage {
$TopicNumber = substr($in{'topic'}, 0, 6);
($junk, $number) = split(/orum/, $in{'forum'});

@message = &OpenThread($in{'topic'});
@stats = split(/\|\|/, $message[0]);

	$ThreadSubject = $stats[4];
	chomp($ThreadSubject);
	$ThreadSubject =~ s/"/&quot;/g;

if (($in{'DeleteThread'} eq "yes") && ($in{'EditSubject'} eq "yes")) {
	&StandardHTML("You accidentally checked \"delete entire thread\" and \"edit subject\"... You can't do both.  Go back and try again.");
}

elsif ($in{'DeleteThread'} eq "yes") {

&JSEditMessageTopHTML;
			
print<<otherHTML;
<p><B>
<FONT COLOR="#008080">Thread Subject: $ThreadSubject</FONT>
<P>
<center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<FONT SIZE="2" FACE="Verdana, Arial">Clicking the button below will permanently delete this entire thread.<br>
</FONT>
<P>
<table border=0>
<TR><TD>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="TopicNumber" VALUE="$TopicNumber">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoDeleteThread">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Delete Entire Thread Now">
</form>
</CENTER>
<TD>
otherHTML
	}
	
	elsif ($in{'EditSubject'} eq "yes") {
	
&JSEditMessageTopHTML;
			
print<<otherHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<B><FONT SIZE="2" FACE="Verdana, Arial">Edit the subject, re-enter your UserName & Password, and then click Submit button.<br>
</FONT></B><BR>
<table width=600 border=0>
<TR>
<td>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000"><B>Thread Subject:</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="NewSubject" VALUE="$ThreadSubject" SIZE=40 MAXLENGTH=120>
</td>
<tr>
<td colspan=2><CENTER><B>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="TopicNumber" VALUE="$TopicNumber">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoSubjectEdit">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Edited Thread Subject">
</form>
</CENTER>
</td>
otherHTML
	} else {
	
&JSEditMessageTopHTML;

print<<otherHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<B><FONT SIZE="2" FACE="Verdana, Arial">Edit the message, re-enter your UserName and Password, and then click Submit button.<br>
To delete the message, check this box. <FONT FACE="Verdana, Arial" COLOR="#FF0000">--></FONT> <INPUT TYPE="CHECKBOX" NAME="DeleteMessage" VALUE="yes">
otherHTML

GETPOST: foreach $row(@message) {
	@row = split(/\|\|/, $row);
	if (($row[0] ne "A") && ($row[1] eq "$in{'EditMessageNumber'}")) {
	
	$message = $row[6];
	chomp($message);

	&UNHTMLIFY($message);

	$message =~ s/<p>/\n\r\n/isg;
	$message =~ s/<br>/\n/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/smile.gif">/:\)/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/frown.gif">/:\(/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/biggrin.gif">/\:D/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/wink.gif">/\;\)/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/redface.gif">/\:o/isg;		

#convert UBB Code
$UBBImages = "ON";
$OverrideImages = "no";
$message = &EditUBBConvert("$message");

	last GETPOST;
	}	
}

## if this is a topic, then warn that all replies will also be deleted
if ($in{'EditMessageNumber'} eq "000000") {
print ("<BR><font face=\"Verdana, Arial\" SIZE=\"2\" COLOR=\"\#800000\">Warning: This message is the topic.  If you delete this, all the replies to it will also be deleted!!</font>");
}

print<<FormBottom;
</FONT></B><BR>
<table width=100% border=0>
<TR bgcolor="#F1DBD6">
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000"><B>Author</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000"><B>Message</B></font>
</td>
</tr>
<tr bgcolor="#f7f7f7">
<td width=150 valign=top>
<FONT SIZE="2" face="Verdana, Arial" COLOR="#000000"><B>$row[2]</B></FONT>
</td>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<FONT SIZE="1" color="#008080" face="Verdana, Arial">posted $row[3] $row[4] $TimeZone</FONT>
<br>
<TEXTAREA NAME="MessageText" ROWS=10 COLS=45 WRAP="VIRTUAL">$message
</TEXTAREA>
</FONT>
</td></tr>
<tr>
<td colspan=3><CENTER><BR>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="MessageNumber" VALUE="$in{'EditMessageNumber'}">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$in{'topic'}">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoMessageEdit">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Edited Message">
</form>
</CENTER>
</td></tr>
FormBottom
}
&BOTTOMHTML;

}  ## End GetExactEdit Message

sub GetEditThreads {

#open thread file
($junk, $number) = split(/orum/, $in{'forum'});
@thread = &OpenThread("$in{'topic'}");
@stats = split(/\|\|/, $thread[0]);

$UNCoded = $stats[3];
$UNCoded =~ tr/ /+/;
$TopicSubject = $stats[4];
chomp($TopicSubject);
	$SubjectCoded = &HTMLIFY($TopicSubject);
			$SubjectCoded =~ tr/ /+/;

&EditMessageTopHTML;

print<<NearTopHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST">
<table border=1>
<tr>
<TD colspan=2 align=center>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Thread Subject: $TopicSubject  </B></FONT>
</td>
<tr>
<td>
<INPUT TYPE="CHECKBOX" NAME="EditSubject" VALUE="yes">
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Check here to edit the subject title.</B></FONT>
</td></tr>
<td>
<INPUT TYPE="CHECKBOX" NAME="DeleteThread" VALUE="yes">
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Check here to delete the entire thread.</B></FONT>
</td>
</tr>
<TR><TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Otherwise, select the message to be edited/deleted below.</B></font>
</td></tr>
</table>
<BR>
<B><FONT SIZE="2" FACE="Verdana, Arial">
<table width=100% border=0>
<TR bgcolor="#F1DBD6">
<td>&nbsp;
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000"><B>Author</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000"><B>Message</B></font>
</td>
</tr>
NearTopHTML

$AltColor = "#f7f7f7";

#Print each post in thread----
foreach $post(@thread) {
	unless ($post =~ m/^A/) {
		my @line = split(/\|\|/, $post);
				

#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $line[3]);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$line[3]";
}

#format time 
	if ($TimeFormat eq "24HR")  {
		@timearray = split(/ /, $line[4]);
		chomp($timearray[1]);
		($gethour, $getmin) = split(/:/, $timearray[0]);
		
		if ($timearray[1] eq "PM") {		
			if ($gethour < 12) {
			$gethour = ($gethour  + 12);
			}
		}
	if ($AMpm eq "AM") {		
		if ($gethour == 12) {
			$gethour = "0";
		}
	}
	$gethour = sprintf ("%2d", $gethour);
	$gethour =~tr/ /0/;
	$getmin = sprintf ("%2d", $getmin);
	$getmin =~tr/ /0/;
	
		$FormatTime = "$gethour:$getmin";
	} else {
		$FormatTime = "$line[4]";
	}
	chomp($line[6]);  
	
print<<gutsHTML;
<tr bgcolor="$AltColor">
<td valign=top>
<INPUT TYPE="RADIO" NAME="EditMessageNumber" VALUE="$line[1]" SELECTED>
</td>
<td width=150 valign=top>
<FONT SIZE="2" face="Verdana, Arial" COLOR="#000000"><b>$line[2]</b></FONT>
</td>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<FONT SIZE="1" color="#008080" face="Verdana, Arial">posted $ThisDate $FormatTime $TimeZone</FONT>
<br>$line[6]
</FONT>
</td>
</tr>
gutsHTML

if ($AltColor eq "#f7f7f7") {
$AltColor = "#dedfdf";
} else {
$AltColor = "#f7f7f7";
}
	} #end unless $post starts with A
} #End foreach $post


print<<FormBottom;
<tr>
<td colspan=3><CENTER><BR>

<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="GetExactEditMessage">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$in{'topic'}">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Retrieve Message to be Edited">
</form>
</CENTER>
</td>
</tr>
FormBottom

&BOTTOMHTML;
} ## END GetEditThreads sr


sub AdminEditForum {

&EditMessageTopHTML;

print<<MoreHTML;
<p><center>
<B><FONT SIZE="2" FACE="Verdana, Arial">Select the topic in which the post is located.</FONT></B>
<table border=0>
<tr bgcolor="#F1DBD6">
<td width=300>
<FONT SIZE="1" FACE="Verdana, Arial" color="#808080">Topic</FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" color="#808080">Originator</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial" color="#808080">
Replies
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial" color="#808080">
Last Post
</FONT>
</td>
MoreHTML

@finalarray = &DoPruneGathering("Edit"); 

@sortarray = sort(@finalarray);

foreach $keptthread(@sortarray) {

@threadfacts = split(/\|\|\|/, $keptthread);

chomp($threadfacts[5]); #Replies Total

if ($DateFormat eq "Euro") {
$Month = substr($threadfacts[0], 4, 2);
$Day = substr($threadfacts[0], 6, 2);
$Year = substr($threadfacts[0], 2, 2);
$TheDate = "$Day-$Month-$Year";
}  else {
$TheDate = "$threadfacts[2]";
}
	
print <<GUTS;
<TR>
<TD width=300><A HREF="edit.cgi?EditFunction=GetEditThreads&forum=$in{'ForumNumber'}&topic=$threadfacts[1]"><IMG SRC="$NonCGIURL/closed.gif" WIDTH=14 HEIGHT=11 BORDER=0></a>
<FONT SIZE="2" FACE="Verdana, Arial">
<A HREF="edit.cgi?EditFunction=GetEditThreads&forum=$in{'ForumNumber'}&topic=$threadfacts[1]">$threadfacts[3]</A>
</FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$threadfacts[4]</FONT>
</td>
<td align=center>
<FONT SIZE="2" FACE="Verdana, Arial">$threadfacts[5]</FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$TheDate</FONT>
</td>
GUTS
}  ## END FOREACH

&BOTTOMHTML;
}  ## END AdminEditForum sr


sub PruneThisForum {

&JSPruneMessageTopHTML;

if ($in{'Style'} eq "PruneByDate") {
print<<MoreHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="SubmitPrune">
<INPUT TYPE="HIDDEN" NAME="ForumNumber" VALUE="$in{'ForumNumber'}">
<INPUT TYPE="HIDDEN" NAME="Style" VALUE="$in{'Style'}">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$in{'DaysPrune'}">
<B>
<P>
To exclude a thread from being pruned, uncheck the box next to the thread on the left and then click the "Prune Me" button on the bottom.</FONT></B>
<table border=0>
<tr bgcolor="#FFFCEC">
<td width=300 valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial" color="#808080">Topic</FONT>
</td>
<td valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial" color="#808080">Originator</FONT>
</td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial" color="#808080">
Replies
</FONT>
</td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial" color="#808080">
Last Post
</FONT>
</td>
MoreHTML


@finalarray = &DoPruneGathering("Prune"); 

@sortarray = sort(@finalarray);

foreach $keptthread(@sortarray) {

@threadfacts = split(/\|\|\|/, $keptthread);

$RepliesFormat = $Replies + 0;
chomp($threadfacts[5]);

if ($DateFormat eq "Euro") {
$Month = substr($threadfacts[0], 4, 2);
$Day = substr($threadfacts[0], 6, 2);
$Year = substr($threadfacts[0], 2, 2);
$TheDate = "$Day-$Month-$Year";
}  else {
$TheDate = "$threadfacts[2]";
}

print <<GUTS;
<TR>
<TD width=300>
<INPUT TYPE="CHECKBOX" NAME="PruneThis:::$threadfacts[1]" VALUE="yes" CHECKED>
<IMG SRC="$NonCGIURL/closed.gif" WIDTH=14 HEIGHT=11 BORDER=0>
<FONT SIZE="2" FACE="Verdana, Arial">
$threadfacts[3]
</FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$threadfacts[4]</FONT>
</td>
<td align=center>
<FONT SIZE="2" FACE="Verdana, Arial">$threadfacts[5]</FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$TheDate</FONT>
</td>
GUTS
}  ## END FOREACH

print<<FORMbottom;
<tr>
<td colspan=4><CENTER>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT><p>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Prune Me!"></CENTER>
</form>
</td></tr>
FORMbottom
}  else {
#if style = prunebyuser---

if ($in{'ForumNumber'} eq "ALL") {
	$ForumWording = "ALL FORUMS";
} else {
	$ForumWording = $in{'ForumNumber'};
}

if ($in{'RegName'} eq "no") {
$RegWording = "(unregistered name)";
}  else {
$RegWording = "";
}
print<<MoreHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="SubmitPrune">
<INPUT TYPE="HIDDEN" NAME="Style" VALUE="$in{'Style'}">
<INPUT TYPE="HIDDEN" NAME="ForumNumber" VALUE="$in{'ForumNumber'}">
<INPUT TYPE="HIDDEN" NAME="MatchUser" VALUE="$in{'MatchUser'}">
<INPUT TYPE="HIDDEN" NAME="RegName" VALUE="$in{'RegName'}">
<P>

<table border=1>
<TR bgcolor="#C6CFA0">
<TD colspan=2 align=center>
<FONT SIZE="2" FACE="Verdana, Arial"><B>To delete all of the posts by $in{'MatchUser'} $RegWording in $ForumWording,<BR> press the SUBMIT button below.</B></FONT>
</TD></tr> 
<tr bgcolor="#8EA3B7">
<td colspan=2 align=center>
<FONT Size="2" FACE="Verdana, Arial"><B>For security reasons, re-enter your UserName & Password:</b></font></td></tr>
<tr bgcolor="#8EA3B7">
<TD width=150><FONT Size="1" FACE="Verdana, Arial">UserName:</FONT></td><td><INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25></td></tr>
<tr bgcolor="#8EA3B7">
<TD width=150><FONT Size="1" FACE="Verdana, Arial">Password</FONT></td><td><INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></td></tr>
<tr bgcolor="#C6CFA0">
<TD align=center colspan=2>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Prune!"></td></tr></form>
MoreHTML
}

&BOTTOMHTML;


}  ## END PruneThisForm sr

sub DoEdit {
## identify user-- moderator/administrator/neither
$NameFound = "no";

$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$ProfileNumber.cgi");
	
	if ($Password eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	   if ($AdminStatus eq "true") {
	   &EditThis(Admin);
	   } 
	    elsif ($ModStatus eq "true") {
	   &EditThis(Mod);
	   }
	   else  {
	   &StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but no one is registered with the User Name you listed.  Please try again.  Use your Back button.");

}  ##END IF/ELSE NAME CHECK BLOCK

}  ## END Do EDIT subroutine

sub EditThis {
$Type = shift;

&GetCookieInfo;

print<<EditHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";domain=$TheDomain;path=/$ThePath;";
		document.cookie = "PasswordCP=" + CookiePWCP + ";domain=$TheDomain;path=/$ThePath;";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
	
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>Edit BB Post</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<p>
<B>
You may edit posts from any of the forums listed below.  Please select one.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=0>
<TR>
<TD valign=top><FONT SIZE="2" FACE="Verdana, Arial"><B>
<SELECT NAME="ForumNumber" SIZE=1>
EditHTML


if ($Type eq "Mod") {
#Get List of All Forums
$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);
$ForumModerator = ("Forum" . "$x" . "Moderator");
$ForumModerator = $$ForumModerator;
@mods = split(/\|\|\^\|\|/, $ForumModerator);

$ModMatch = "";
foreach $unomod(@mods) {
if ($unomod eq "$UserName") {
	$ModMatch = "true";
}
}
	if ($ModMatch eq "true") {
print<<Forum1HTML;
<OPTION VALUE="Forum$x">$thisforum[1]
Forum1HTML
	}
} #End for $x--

} #end if Mod


if ($Type eq "Admin") {
$ForumTotal = &GetTotalForums;

for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);

print<<ForumHTML;
<OPTION VALUE="Forum$x">$thisforum[1]
ForumHTML

} #END for $x -------

}


print<<EDITbottomHTML;
</select></FONT></B>
</td>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial" color="#800000"><B>Search posts going back <INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="20" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="AdminEditThisForum">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">&copy; Infopop Corporation (formerly Madrona Park, Inc.), 1998-1999.
</FONT>
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  ## END EditThis sr

sub PruneThis {
my $Type = shift;
my $Style = shift;

if ($Style eq "PruneByDate") {
$matchfound = "true";
$Criteria = qq(<tr bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Prune threads with last post older than:</B></FONT></td>
<TD><FONT SIZE="2" FACE="Verdana, Arial"><B><INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="60" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td></tr>);
}  else {
&GetMemberListArray;  #returns members array
$Criteria = qq(<tr bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Prune all threads posted by:</B></FONT></td><td><SELECT NAME="MatchUser">);
$CheckAgainst = &decodeURL($in{'DeleteName'});
$CheckAgainst =~ s/([\^|\.|\$|\*\|\?|\(|\)|\{|\}|\[|\]|\\|\&|\%|\@|\+|\}|\{])/\\$1/isg;

if ($in{'DeleteRegName'} eq "yes") {

foreach $one(@members) {

if ($one =~ /$CheckAgainst/i) {
$matchfound = "true";
$Criteria .= qq(<OPTION value="$one">$one);
}
}

}  else {
$matchfound = "true";
$Criteria .= qq(<OPTION value="$CheckAgainst">$CheckAgainst - unregistered name);
}

$Criteria .= qq(</SELECT></td></tr>);
}

if ($matchfound eq "true") {
&GetCookieInfo;
print<<PruneHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<SCRIPT LANGUAGE="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";domain=$TheDomain;path=/$ThePath;";
		document.cookie = "PasswordCP=" + CookiePWCP + ";domain=$TheDomain;path=/$ThePath;";
	}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
	
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<br><center>

<FONT SIZE="5" FACE="Courier New"><B>Prune BB Posts</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">

<p><B>
You may prune posts from any of the forums listed below.  Please select one.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=1 width=95%>
<TR bgcolor="#C6CFA0">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Prune From Forums: </B></FONT>
</td>
<TD valign=top><SELECT NAME="ForumNumber" SIZE=1>
PruneHTML


if ($Type eq "Mod") {
#Get List of All Forums
$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);
$ForumModerator = ("Forum" . "$x" . "Moderator");
$ForumModerator = $$ForumModerator;
@mods = split(/\|\|\^\|\|/, $ForumModerator);

$ModMatch = "";
foreach $unomod(@mods) {
if ($unomod eq "$UserName") {
	$ModMatch = "true";
}
}
	if ($ModMatch eq "true") {
print<<Forum1HTML;
<OPTION VALUE="Forum$x">$thisforum[1]
Forum1HTML
	}
} #End for $x--

} #end if Mod


if ($Type eq "Admin") {
$ForumTotal = &GetTotalForums;
if ($Style eq "PruneByUser") {
print<<ForumHTML;
<OPTION VALUE="ALL">All Forums
ForumHTML
}
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);

print<<ForumHTML;
<OPTION VALUE="Forum$x">$thisforum[1]
ForumHTML

} #END for $x -------

}

print<<EDITbottomHTML;
</select>
</td>
$Criteria
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="PruneThisForum">
<INPUT TYPE="HIDDEN" NAME="RegName" VALUE="$in{'DeleteRegName'}">

<INPUT TYPE="HIDDEN" NAME="Style" VALUE="$Style">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Ultimate Bulletin Board<BR>&copy; Infopop Corporation (formerly Madrona Park, Inc.), 1998-1999.
</FONT>
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  else {
&StandardHTML("Sorry, we could not find any users that matched that name.  Please go back and try again.");
}
}  ## END  sr


sub PruneAsAdmin {
&GetCookieInfo;
print<<PruneHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";domain=$TheDomain;path=/$ThePath;";
		document.cookie = "PasswordCP=" + CookiePWCP + ";domain=$TheDomain;path=/$ThePath;";
	}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>Prune BB Posts</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<p><B>
As an administrator, you can prune posts by date in any forum.  Please select a forum below.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=0>
<TR>
<TD valign=top><FONT SIZE="2" FACE="Verdana, Arial"><B>
PruneHTML

$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);

if ($thisforum[3] eq "On") {
print<<ForumHTML;
<INPUT TYPE="RADIO" NAME="ForumNumber" VALUE="Forum$x">
$thisforum[1]<br>
ForumHTML
}
} #END for $x -------

print<<EDITbottomHTML;
</FONT></B>
</td>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial" color="#800000"><B>Prune threads with last post older than <INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="60" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="PruneThisForum">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">&copy; Infopop Corporation (formerly Madrona Park, Inc.), 1998-1999.
</FONT> 
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  ## END PruneAsAdmin sr


sub DoDeleteThread {
## confirm UN/password
$UNCheck = $in{'UserNameCheck'};
$ProfileNumber = &GetUserNumber($UNCheck);

@checkprofile = &OpenProfile("$ProfileNumber.cgi");
if ($in{'PasswordCheck'} eq "$checkprofile[1]") {
$Status = "$checkprofile[8]";
	&CheckTheStatus;
		$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")) {
			&PerformTheDelete;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		}

}  else {
&StandardHTML("Sorry, the password you supplied is incorrect.  Please use your back button to try again!");

} # END IF/ELSE
}


sub JSEditMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.Edit.UserNameCheck.value = getCookie("UserNameCP");
document.Edit.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.Edit.UserNameCheck.focus();
}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0 onLoad="SetCursor()">
<b><FONT SIZE="2" FACE="Verdana, Arial">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>Edit Message</B>
</FONT>
</center>
TOP
}  ## END JSEditMessageTopHTML


sub EditMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0>
<b><FONT SIZE="2" FACE="Verdana, Arial">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>Edit Message</B>
</FONT>
</center>
TOP
}  ## END EditMessageTopHTML

sub PruneMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0>
<b><FONT SIZE="2" FACE="Verdana, Arial">
<br><center>
<FONT SIZE="5" FACE="Courier New"><B>Prune Messages</B>
</FONT>
</center>
TOP
}  ## END PruneMessageTopHTML


sub JSPruneMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.Edit.UserNameCheck.value = getCookie("UserNameCP");
document.Edit.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.Edit.UserNameCheck.focus();
}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0 onLoad="SetCursor()">
<b><FONT SIZE="2" FACE="Verdana, Arial">
<center>
<FONT SIZE="5" FACE="Courier New" color="#000080"><B>Prune Messages</B>
</FONT>
</center>
TOP
}  ## END JSPruneMessageTopHTML

sub BOTTOMHTML {
print<<BOTTOM;
</table>
<center><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Powered by: Ultimate Bulletin Board<br>
&copy; Infopop Corporation (formerly Madrona Park, Inc.), 1998-1999.
</FONT>
</center>
</body></html>
BOTTOM
} ## END BottomHTML sr

sub DoPruneGathering {
my $type = shift;

#get Forum Messages
($trash, $number) = split(/orum/, $in{'ForumNumber'});
@thisforum = &GetForumRecord($number);

if ($thisforum[6] eq "private") {
	$ExactPath = "Forum$number/private-$thisforum[7]";
} else {
	$ExactPath = "Forum$number";
}

#gather topics in the forum using threads file
@alltopics = &OpenFile("$ForumsPath/$ExactPath/forum$number.threads");

## do date pruning 

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);

$mon++;

$year = $year + 1900;

#convert Closing and Current Dates to Julian Dates
$CurrentJulian = &jday($mon, $mday, $year);
$CloseJulian = $CurrentJulian - $in{'DaysPrune'};

@finalarray = @blank;

#configure memo date to Julian
		
foreach $item(@alltopics) {
my @topicline = split(/\|\^\|/, $item);
my $ThisJDate = $topicline[0];
($CheckJulian, $junk) = split(/\./, $ThisJDate);
$DateLine = $topicline[5];
$DateLine = substr($DateLine, 0, 8);

	if ($type eq "Prune") {
	if ($CheckJulian <= $CloseJulian) {
		my $Author = $topicline[4];
		my $Subject = $topicline[2];
		chomp($Subject);
		my $Replies = $topicline[3];
		
		# $dateline used for sorting only
		$ThisYear = substr($DateLine, 0, 4);
		$ThisMonth = substr($DateLine, 4, 2);
		$ThisDay = substr($DateLine, 6, 2);
		$DateHyph = "$ThisMonth-$ThisDay-$ThisYear";
		$EditLine = "$DateLine|||$topicline[1].cgi|||$DateHyph|||$Subject|||$Author|||$Replies";
		push (@finalarray, $EditLine);
	}  	
	}  else {
			if ($CheckJulian >= $CloseJulian) {
		my $Author = $topicline[4];
		my $Subject = $topicline[2];
		chomp($Subject);
		my $Replies = $topicline[3];		
		# $dateline used for sorting only
		$ThisYear = substr($DateLine, 0, 4);
		$ThisMonth = substr($DateLine, 4, 2);
		$ThisDay = substr($DateLine, 6, 2);
		$DateHyph = "$ThisMonth-$ThisDay-$ThisYear";
		$EditLine = "$DateLine|||$topicline[1].cgi|||$DateHyph|||$Subject|||$Author|||$Replies";
		push (@finalarray, $EditLine);
			}  	
	
	}
} #end FOREACH $item
return(@finalarray);
}  ## End DoPruneGathering


sub DoSubjectEdit {
## confirm UN/password
$UNCheck = $in{'UserNameCheck'};
$ProfileNumber = &GetUserNumber($UNCheck);

@checkprofile = &OpenProfile("$ProfileNumber.cgi");
if ($in{'PasswordCheck'} eq "$checkprofile[1]") {
$Status = "$checkprofile[8]";
	&CheckTheStatus;
	$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")) {
			&UpdateTheSubject;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		}

}  else {
&StandardHTML("Sorry, the password you supplied is incorrect.  Please use your back button to try again!");

} # END IF/ELSE
}  ## End DoSubjectEdit sr

sub PerformTheEdit {
($trash, $number) = split(/Forum/, $in{'forum'});
@thisforum = &GetForumRecord($number);

($ThreadNumber, $junk) = split(/\./, $in{'topic'});

@oldmessage = &OpenThread($in{'topic'});
@stats = split(/\|\|/, $oldmessage[0]);
$TopicSubject = $stats[4];
chomp($TopicSubject);
$TotReplies = $stats[2];

$Forum = $thisforum[1];
$ForumCoded = &HTMLIFY($Forum);
$ForumCoded =~ tr/ /+/;
$Status = $thisforum[3];
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
if ($LWA eq "private") {
	$ExactPath = "Forum$number/private-$thisforum[7]";
}  else {
	$ExactPath = "Forum$number";
}

if ($in{'DeleteMessage'} eq "yes") {
&EditMessageTopHTML;

if ($in{'MessageNumber'} ne "000000") {
#subtract one from reply total
$ReplyTotal = $stats[2];
$ReplyTotal--;

#create revised stat line for thread
$newstatline = "A||$stats[1]||$ReplyTotal||$stats[3]||$TopicSubject";
chomp($newstatline);

@newthread = @blank;
#loop thru thread, remove deleted post
foreach $uno(@oldmessage) {
	chomp($uno);
	if ($uno =~ m/^A/) {
		push(@newthread, $newstatline);
	} 
	elsif ($uno !~ m/^Z\|\|$in{'MessageNumber'}/) {
		push(@newthread, $uno);
	}
}

#write new thread to file
&Lock("lock.file");
open (NEWBIE, ">$ForumsPath/$ExactPath/$in{'topic'}");
for $theline(@newthread) {
chomp($theline);
print NEWBIE "$theline\n";
}
close(NEWBIE);
&Unlock("lock.file");

##CREATE HTML FILE FOR Revised THREAD
&CreateThreadHTML("$in{'forum'}", "$in{'topic'}", "0", "1");

#update forum summary file and threads file
&UpdateForumDetails($number);

#update total post total on lastnumber.file
&UpdateForumTotals("$number", 0, 1, "no");

print<<otherHTML;
<p><center>
<B><FONT SIZE="2" FACE="Verdana, Arial">The message has been successfully deleted!   Be sure to recreate your index after you have finished deleting all messages- otherwise your search engine will not be updated to reflect these changes.</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML

} else {

# DELETE ENTIRE THREAD, SINCE IT IS THE TOPIC POST BEING REMOVED

#delete UBB & HTML FILES
unlink "$ForumsPath/$ExactPath/$in{'topic'}";
unlink "$ForumsPath/$ExactPath/HTML/$ThreadNumber.html";
unlink "$ForumsPath/$ExactPath/HTML/$ThreadNumber.cgi";

#update forum summary file and lasttime file
&UpdateForumDetails($number);

#update lastnumber.file
$TotReplies = $TotReplies + 0;
$TotThreadPosts = $TotReplies + 1;
&UpdateForumTotals("$number", 1, $TotThreadPosts, "yes");

print<<otherHTML;
<p><center>
<B><FONT SIZE="2" FACE="Verdana, Arial">The topic and all of its replies have been successfully deleted!  Be sure to recreate your Index after you have finished deleting/editing all posts here.</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML
}
&BOTTOMHTML;

}  else  {

#  ELSE EDIT MESSAGE -------------

# @oldmessage contains thread array
# @stats contains stats array for thread
@updated = @blank;
foreach $row(@oldmessage) {
chomp($row);
@rowinfo = split(/\|\|/, $row);
	if (($rowinfo[0] ne "A") && ($rowinfo[1] eq "$in{'MessageNumber'}")) {
$oldmessage = $rowinfo[6];
chomp($oldmessage);

$MessageText = $in{'MessageText'};
$MessageText = &ConvertReturns($MessageText);
$MessageText = &Smilies($MessageText);
$UBBImages = "ON";
$OverrideImages = "no";
$MessageText = &UBBCode($MessageText);

$MessageText .= ("<p>[Note: This message has been edited by $in{'UserNameCheck'}]");
$postUserName = $rowinfo[2];
$postdate = $rowinfo[3];

$newrow = "Z||$rowinfo[1]||$postUserName||$postdate||$rowinfo[4]||$rowinfo[5]||$MessageText";
push(@updated, $newrow);
} else {
push(@updated, $row);
}
}  #end foreach $row

&Lock("lock.file");
open (FORUM, ">$ForumsPath/$ExactPath/$in{'topic'}"); 
foreach $printit(@updated) {
chomp($printit);
print FORUM ("$printit\n");
}
close (FORUM);
&Unlock("lock.file");
chmod(0666, "$ForumsPath/$ExactPath/$in{'topic'}");

#update the associated HTML FILE
&CreateThreadHTML("$in{'forum'}", "$in{'topic'}", "0", "1");

#Update forum summary file
&CurrentDate;
&ForumSummary($number);

&StandardHTML("Edit successfully completed!  Be sure to re-create your Index after you have finished editing/pruning posts.");
}
} #End PerformTheEdit sr

sub DoThePrune {

if ($in{'Style'} ne "PruneByUser") {

($trash, $number) = split(/orum/, $in{'ForumNumber'});
@thisforum = &GetForumRecord($number);
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);

if ($LWA eq "private") {
	$ExactPath = "Forum$number/private-$thisforum[7]";
}  else {
	$ExactPath = "Forum$number";
}

@DeleteList = @blank;
foreach $row(@in) {
		($Name2, $Value2) = split ("=", $row);
			$Name2 = &decodeURL($Name2);
			$Value2 = &decodeURL($Value2);
			
			$_ = "$Name2";
			if (/PruneThis/) {
				($Trash, $DeleteThread) = split(/:::/, $Name2);
 				push(@DeleteList, $DeleteThread);
			}
}
		
foreach $tobepruned(@DeleteList) {
	#delete ubb file
	unlink "$ForumsPath/$ExactPath/$tobepruned";
	
	($ThreadNum, $junk) = split(/\./, $tobepruned);
	unlink "$ForumsPath/$ExactPath/HTML/$ThreadNum.html";
	unlink "$ForumsPath/$ExactPath/HTML/$ThreadNum.cgi";
}
#update forum summary file and threads file
&UpdateForumDetails($number);

#update forumnumber.file
&SetForumNumbers($number);

$Status = $thisforum[3];
&StandardHTML("Thank you!  We have deleted the topics you requested.  Note that your search index has not been updated to reflect these deleted topics.  Thus, you should recreate your Index (click on the Index link in your control panel) after you have finished deleting topics.");
}  else {

&PruneUserRoutine;

} #end prune by user section
} #end DoThePrune sr

sub PruneUserRoutine {

#check to see if we are continuing...
if ($in{'ForumStart'} ne "") {
#import good array
if ($in{'Total'} ne "") {
@currentgood = &OpenFile("$NonCGIPath/currentgood.cgi");
$Total = $in{'Total'};
$ArrayStart = $in{'ArrayStart'};
$ArrayStart = $ArrayStart + 0;
$ForumStart = $in{'ForumStart'};
$ForumStart = $ForumStart + 0;
}  else {
$ForumStart = $in{'ForumStart'};
$ForumStart = $ForumStart + 0;
$ArrayStart = 0;
}
}  else {
$ArrayStart = 0;
}

@foruminfo = &OpenFile("$VariablesPath/forums.cgi");
$TotalForums = @foruminfo;

#open index file(s) to search for entries by user
if ($in{'ForumNumber'} eq "ALL") {

if ($IndexMethod ne "PERFORUM") {
#break up into smaller forum index for cycle through
@totalindex = &OpenFile("$NonCGIPath/forumindex.cgi");

if ($ForumStart) {
$thisnum = $ForumStart;
@getrecord = &GetForumRecord($thisnum);
$private = $getrecord[6];
}  else {
$FirstForum = $foruminfo[0];
chomp($FirstForum);
@thisforum = split(/\|/, $FirstForum);
$thisnum = $thisforum[8];
$private = $thisforum[6];
}

if ($private eq "private") {
@theindex = &OpenFile("$MembersPath/pindex/privateforumindex$thisnum.cgi");
}  else {
@theindex = grep(/^$thisnum\|/, @totalindex);
}


}  else {

#cycle through each index file
if ($in{'ForumStart'}) {
$thisnum = $in{'ForumStart'};
@getrecord = &GetForumRecord($thisnum);
$private = $getrecord[6];
}  else {
$FirstForum = $foruminfo[0];
chomp($FirstForum);
@thisforum = split(/\|/, $FirstForum);
$thisnum = $thisforum[8];
$private = $thisforum[6];
}

if ($private eq "private") {
@theindex = &OpenFile("$MembersPath/pindex/privateforumindex$thisnum.cgi");
} else {
@theindex = &OpenFile("$NonCGIPath/forumindex$thisnum.cgi");
}

}


}  else {
#prune in just one forum

($trash, $thisnum) = split(/orum/, $in{'ForumNumber'});
$number = $thisnum;
@thisforum = &GetForumRecord($thisnum);

if ($thisforum[6] eq "private") {
@theindex = &OpenFile("$MembersPath/pindex/privateforumindex$number.cgi");

}  else {

if ($IndexMethod ne "PERFORUM") {
@preindex = &OpenFile("$NonCGIPath/forumindex.cgi");
@theindex = grep(/^$thisnum\|/, @preindex);
}  else {
#get perforum index file
@theindex = &OpenFile("$NonCGIPath/forumindex$number.cgi");
}

} #end if/else private

} #end if/else one forum to prune or ALL

#search for matches
if (@currentgood) {
@good = @currentgood;
}  else {
@good = @blank;
$Total = 0;
}

if (@theindex) {
$PreTruncate = @theindex;
@sortindex = sort(@theindex);
$TotalForumArray = @sortindex;
$TotalForumArray = $TotalForumArray - 1;
@goodindex = @theindex[$ArrayStart..$TotalForumArray];
$PostTruncate = @goodindex;
}

&SearchForUserPosts;


# now we have array or threads containing posts by user
# delete currentgood array if it exists
if (-e "$NonCGIPath/currentgood.cgi") {
unlink("$NonCGIPath/currentgood.cgi");
}


if (@good) {
foreach $one(@good) {

@threadmatch = split(/\|/, $one);

@forumfacts = &GetForumRecord($threadmatch[0]);
if ($forumfacts[6] eq "private") {
	$ExactPath = "Forum$forumfacts[8]/private-$forumfacts[7]";
}  else {
	$ExactPath = "Forum$forumfacts[8]";
}

#delete from thread, recreate HTML page
@threadinfo = &OpenFile("$ForumsPath/$ExactPath/$threadmatch[1].cgi");
@tinfo = sort(@threadinfo);
@rinfo = reverse(@tinfo);

@revised = @blank;
$DeleteThread = "";
$Count = -1;
CHECKTHREAD: foreach $row(@rinfo) {

	@rowinfo = split(/\|\|/, $row);
if ($row =~ /^Z/) {
	if ($rowinfo[2] eq "$MatchUser") {
		if ($rowinfo[1] eq "000000") {
				$DeleteThread = "true";
			last CHECKTHREAD;
		}
	}  else {
			$Count++;
		push(@revised, $row);
		
	}
}  else {
	chomp($rowinfo[4]);
	$newline = "A||$rowinfo[1]||$Count||$rowinfo[3]||$rowinfo[4]";
	push(@revised, $newline);
}

} #end for each row of thread

	if ($DeleteThread eq "true") {
		unlink("$ForumsPath/$ExactPath/$threadmatch[1].cgi");
		unlink("$ForumsPath/$ExactPath/HTML/$threadmatch[1].html");
unlink("$ForumsPath/$ExactPath/HTML/$threadmatch[1].cgi");
	}  else {
	#revise ubb & HTML files
		@sortrevised = sort(@revised);
		&Lock("lock.file");
		open(NEWUBB, ">$ForumsPath/$ExactPath/$threadmatch[1].cgi");
		foreach $uno(@sortrevised) {
			chomp($uno);
			print NEWUBB "$uno\n";
		}
	close(NEWUBB);
	&Unlock("lock.file");
chmod(0666, "$ForumsPath/$ExactPath/$threadmatch[1].cgi");

	##CREATE HTML FILE FOR REVISED THREAD
	$Forum = $forumfacts[1];
	$ForumCoded = &HTMLIFY($Forum);
	$ForumCoded =~ tr/ /+/;
	$LWA = $forumfacts[6];
	$PrivateMax = $forumfacts[13];
	
$number = $threadmatch[0];
my $ThisForum = ("Forum" . "$threadmatch[0]");
my $ThisThread = ("$threadmatch[1]" . ".cgi");
&CreateThreadHTML($ThisForum, $ThisThread, "0", "1");

	}
	
}  # end foreach good array item

#reset threads, index, lasttimes, numbers, etc.

#update forum summary file and threads file
@theforum = &GetForumRecord($thisnum);
if ($theforum[6] eq "private") {
	$ExactPath = "Forum$thisnum/private-$theforum[7]";
}  else {
	$ExactPath = "Forum$thisnum";
}
&UpdateForumDetails($thisnum);

#update forumnumber.file
&SetForumNumbers($thisnum);

} #if good array is not empty

if (($in{'ForumNumber'} eq "ALL")  && ($NextForum <= $TotalForums)) {
    &ContinuePruneUserSearch2($NextForum);
	exit;
}

&StandardHTML("Thank you!  We have deleted the posts for that user in the forums that you requested.  Note that your search index has not been updated to reflect these deleted topics.  Thus, you should recreate your Index (click on the Index link in your control panel) after you have finished deleting topics.");


} #end prune routine

sub SearchForUserPosts {
$CountLines = 0;
if (@goodindex) {
SEARCHMATCHES: foreach $line(@goodindex) {
$CountLines++;
	$Bad = "no";
	@indie = split(/\|/, $line);

# Username Search Routine---
$MatchUser = &decodeURL($in{'MatchUser'});
$MatchUser = &UNHTMLIFY($MatchUser);

	unless ($indie[2] eq "$MatchUser") {
			$Bad = "yes";
		}

if ($Bad ne "yes") {
(@testit) = split(/\|/, $line);
$testit = ("$testit[0]" . "$testit[1]");
$Duplicate = "";

if (@good) {
	for $dupcheck(@good) {
(@testit2) = split(/\|/, $dupcheck);
$testit2 = ("$testit2[0]" . "$testit2[1]");
		if ($testit eq "$testit2") {
			$Duplicate = "true";
		}
	}
}

if ($Duplicate ne "true") {
push(@good, $line);
}
} #end if $Bad

if ($thisnum eq "") {
	$thisnum = "$in{'ForumNumber'}";
}
#cycle through limit of 9999 lines per process
if ($CountLines > 40) {
$ForumNumber = $thisnum;
if ($in{'ArrayStart'} eq "") {
	$ArrayStart = 0;
}  else {
	$ArrayStart = $in{'ArrayStart'};
}
$ArrayPoint = $ArrayStart + $CountLines;
&ContinuePruneUserSearch($ForumNumber, $ArrayPoint, $Total);
exit;
}
} #end foreach $line
}

$NextForum = $thisnum + 1;

}  # end searchforuserposts


sub ContinuePruneUserSearch {
my $ForumStart = shift;
my $ArrayStart = shift;
my $Total = shift;

#write good file to server
open(GOOD, ">$NonCGIPath/currentgood.cgi");
foreach $goodone(@good) {
chomp($goodone);
print GOOD "$goodone\n";
}
close(GOOD);
	chmod(0666, "$NonCGIPath/currentgood.cgi");
	
		$MatchUserCoded = $in{'MatchUser'};
		$MatchUserCoded = &HTMLIFY($MatchUserCoded);
		$MatchUserCoded =~ tr/ /+/;
			
&ForwardEdit("$CGIURL/edit.cgi?EditFunction=SubmitPrune&Style=$in{'Style'}&ForumNumber=$in{'ForumNumber'}&MatchUser=$MatchUserCoded&RegName=$in{'RegName'}&ForumStart=$ForumStart&ArrayStart=$ArrayStart&Total=$Total", "Please wait... we are processing... Currently pruning in Forum $thisnum...");


}


sub ContinuePruneUserSearch2 {
my $ForumStart = shift;

		$MatchUserCoded = $in{'MatchUser'};
		$MatchUserCoded = &HTMLIFY($MatchUserCoded);
		$MatchUserCoded =~ tr/ /+/;
		
&ForwardEdit("$CGIURL/edit.cgi?EditFunction=SubmitPrune&Style=$in{'Style'}&ForumNumber=$in{'ForumNumber'}&MatchUser=$MatchUserCoded&RegName=$in{'RegName'}&ForumStart=$ForumStart", "Please wait... we are processing... Currently pruning in Forum $thisnum<P>");
}
sub UpdateTheSubject {

($trash, $number) = split(/orum/, $in{'forum'});

@thisforum = &GetForumRecord($number);
$ForumStatus = $thisforum[3];
$LWA = $thisforum[6];
$PrivateMax = $thisforum[6];
chomp($PrivateMax);

$Status = $ForumStatus;
$Forum = "$thisforum[1]";
$ForumCoded = &HTMLIFY($Forum);
$ForumCoded =~ tr/ /+/;

	$in{'NewSubject'} =~ s/<.+?>//g;
	$in{'NewSubject'} =~ s/"/&quot;/g;
	$in{'NewSubject'} =~ s/\|/+/g;

$ThreadHead = $in{'TopicNumber'};

@subj = &OpenThread("$ThreadHead.cgi");
@newsubj = @blank;

foreach $row(@subj) {
	chomp($row);
	if ($row =~ m/^A/) {
	@rowstats = split(/\|\|/, $row);
	chomp($rowstats[7]);
	chomp($rowstats[6]);
	chomp($rowstats[5]);
	$newline = "A||$rowstats[1]||$rowstats[2]||$rowstats[3]||$in{'NewSubject'}||$rowstats[5]||$rowstats[6]||$rowstats[7]";
	chomp($newline);
	push(@newsubj, $newline);
	}  else {
		push(@newsubj, $row);
	}
}

&Lock("lock.file");
open(THREAD, ">$ForumsPath/$ExactPath/$ThreadHead.cgi");
foreach $one(@newsubj) {
chomp($one);
print THREAD ("$one\n");
}
close(THREAD);
&Unlock("lock.file");

## Update the HTML file for the thread now
&CreateThreadHTML("$in{'forum'}", "$ThreadHead.cgi", "0", "1");

#update forum summary file
&ForumSummary($number);
&StandardHTML("Subject successfully edited!  Be sure to re-create your Index after you have finished editing/pruning posts.");
} #end UpdateTheSubject sr


sub PerformTheDelete {
$TopicNumber = $in{'TopicNumber'};

### get $number and $Status variables for updating the index!
	($trash, $number) = split(/orum/, $in{'forum'});
	@thisforum = &GetForumRecord($number);
	$Status = $thisforum[3];
	$LWA = $thisforum[6];
	
### get current stats on thread
@oldmessage = &OpenThread("$TopicNumber.cgi");
@stats = split(/\|\|/, $oldmessage[0]);
$TotReplies = $stats[2];

#delete ubb and html files
unlink "$ForumsPath/$ExactPath/$TopicNumber.cgi"; 
unlink "$ForumsPath/$ExactPath/HTML/$TopicNumber.html";
unlink "$ForumsPath/$ExactPath/HTML/$TopicNumber.cgi";

&EditMessageTopHTML;

print<<otherHTML;
<p><center>
<B><FONT SIZE="2" FACE="Verdana, Arial">The topic and all of its replies have been successfully deleted!  Be sure to recreate your Index in order to synchronize your search engine with these changes.</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML

&BOTTOMHTML;

#update forum summary file and threads file
&UpdateForumDetails($number);

#update total post total on lastnumber.file
$TotThreadPosts = $TotReplies + 1;
&UpdateForumTotals("$number", 1, $TotThreadPosts, "yes");

} #end perform the delete sr


sub SetForumNumbers {
my $ForumNumber = shift;

opendir (FORUMDIR, "$ForumsPath/$ExactPath"); 
    my @theubbfiles = grep(/\.[cgi|ubb]/, readdir(FORUMDIR));
closedir (FORUMDIR);

my $topiccount = @theubbfiles;
#sort the ubb files
@theseubbfiles = sort(@theubbfiles);
#reverse array so that largest number is first
@ubbfiles = reverse(@theseubbfiles);
my $lastnumber = $ubbfiles[0];
($lastnumber, $junk) = split(/\./, $lastnumber);

##

$ThreadTotal = 0;
#determine number of total posts
foreach $threadfile(@ubbfiles) {
	@countit = &OpenFile("$ForumsPath/$ExactPath/$threadfile");
	@countit = grep(/^Z/, @countit);
	$ThisTotal = @countit;
	$ThreadTotal = $ThreadTotal + $ThisTotal;
}


#print number to lastnumber.file
open (UBB, ">$ForumsPath/$ExactPath/lastnumber.file");
print UBB ("$lastnumber\n");
print UBB ("$topiccount\n");
print UBB ("$ThreadTotal\n");
close (UBB);

chmod (0666, "$ForumsPath/$ExactPath/lastnumber.file");

} #end SetLastThreadNums sr (new in 5.10)


sub QueryForEditID {
print<<ForumLoginHTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.Edit.UserNameCheck.value = getCookie("UserNameCP");
document.Edit.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.Edit.UserNameCheck.focus();
}
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="2" FACE="Verdana, Arial">$PageTitle</FONT>
</center><P><FONT SIZE="1" FACE="Verdana, Arial">
<center>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">You must be an administrator or moderator to edit or delete posts.</FONT>
<P><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000">
$PageIntro</font>
<P>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit" onSubmit="return Check(this)">
ForumLoginHTML

&IDEditTable;

print<<ENDIT;
<P></font>
$HiddenFields
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial">Copyright, Infopop Corporation (formerly Madrona Park, Inc.), 1998-1999.
</FONT>
</CENTER></BODY></HTML>
ENDIT
}

sub IDEditTable {
print<<LOGIN;
<table border=0 cellpadding=0 cellspacing=0 width="65%"><TR><td bgcolor="#000000">

<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
<tr bgcolor="#C7C6BA">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>
</td>
<TR bgcolor="#C7C6BA">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13>
</td>
</table>
</td></tr></table>
LOGIN
}


sub ForwardEdit {
my $ForwardURL = shift;
my $ForwardText = shift;

print<<ForwardHTML;
<HTML><HEAD>
<title>$BBName</title>
<meta http-equiv="Refresh" content="0; URL=$ForwardURL">
$HeaderInsert
</HEAD>
 <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor">
<br><br>
<center>
$BorderTop
<table border=0 cellpadding=4 border=0 cellspacing=1 width=$TableWidth2>
<TR $AltColumnColor1>
<TD>
<FONT SIZE="$TextSize" FACE="$FontFace">
<B>$ForwardText  Please wait...
<P>
</font>
<FONT SIZE="1" FACE="$FontFace">
<A HREF="$ForwardURL">Click here if you do not want to wait any longer (or if your browser does not automatically forward you).</A>
</B><br><br>
</FONT>
</td></tr>
</table>
$BorderBottom
</center>
</body></html>
ForwardHTML
} #end Forward sr