unit wpchange_editor;

interface

uses
  dialogs, wpchange, DsgnIntf ;

type
  TGLWallpaperChangerEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(Index : integer) : string ; override ;
     procedure ExecuteVerb(Index : integer) ; override ;
  end ;

  TGLWallpaperFilenameEditor = class(TStringProperty)
    function  GetAttributes : TPropertyAttributes; override;
    procedure Edit ; override;
  end;

procedure Register;

implementation

function TGLWallpaperChangerEditor.GetVerbCount : integer ;
begin
     Result := 2 ;
end ;

function TGLWallpaperChangerEditor.GetVerb(Index : integer) : string ;
begin
     case Index of
        0 : Result := '&Execute' ;
        1 : Result := 'Reset &Windows Path' ;
     end ;
end ;

procedure TGLWallpaperChangerEditor.ExecuteVerb(Index : integer) ;
begin
     case Index of
       0: (Component as TGLWallpaperChanger).Execute ;
       1: begin
             (Component as TGLWallpaperChanger).ResetWindowsDir ;
             Designer.Modified ;  { update Object Inspector display }
          end ;
    end ;
end ;

{ begin FileName property editor logic }

function TGLWallpaperFilenameEditor.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] ;
end;

procedure TGLWallpaperFilenameEditor.Edit ;
var
   d : TOpenDialog ;
begin
  d := TOpenDialog.Create( nil ) ;
  d.Title := 'Select Bitmap File' ;
  d.Filter := 'Bitmap files|*.bmp' ;
  d.FileName := GetStrValue ;
  if d.Execute then
     SetStrValue(d.FileName) ;
  d.Free ;
end;

{ end FileName property editor logic }

procedure Register;
begin
  RegisterComponentEditor(TGLWallpaperChanger, TGLWallpaperChangerEditor) ;
  RegisterPropertyEditor( TypeInfo(TGLWallpaperFilename), TGLWallpaperChanger,
                          'Filename', TGLWallpaperFilenameEditor );
end;

end.
