unit wpchange;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}
  Dialogs, Messages, SysUtils, Classes ;

type
  TGLWallpaperFilename = string ;

  TGLWallpaperChanger = class(TComponent)
  private
     FFileName : TGLWallpaperFilename ;
     FFileDir : string ;
     procedure SetFileDir(s : string) ;
     procedure SetFileName(s : TGLWallpaperFilename) ;
  public
     procedure ResetWindowsDir ;
     constructor Create(AOwner : TComponent) ; override ;
     procedure Execute ; virtual ;
  published
     property FileDir : string read FFileDir write SetFileDir ;
     property FileName : TGLWallpaperFilename read FFileName write SetFileName ;
  end;

procedure Register;

implementation

const
   Wildcard = '\*.bmp' ;

constructor TGLWallpaperChanger.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
{$IFDEF SHOW_COPYRIGHT}
     ShowCopyright(self,True) ;
{$ENDIF}
     ResetWindowsDir ;
end ;

procedure TGLWallpaperChanger.ResetWindowsDir ;
var
   p : PChar ;
begin
     p := StrAlloc(255) ;
     GetWindowsDirectory(p, 255) ;
     {$IFDEF WIN32}
     FFileDir := string(p) ;
     {$ELSE}
     FFileDir := StrPas(p) ;
     {$ENDIF}
     StrDispose(p) ;
end ;

procedure TGLWallpaperChanger.SetFileName(s : TGLWallpaperFilename) ;
begin
     if FileExists(s) and (UpperCase(ExtractFileExt(s)) = '.BMP') then
        FFileName := s ;
end ;

procedure TGLWallpaperChanger.SetFileDir(s : string) ;
var
   SearchRec: TSearchRec;
begin
     { make sure there are actually BMP files in target directory }
     if FindFirst(s + Wildcard, faAnyFile, SearchRec) = 0 then
        FFileDir := s ;
     FindClose(SearchRec) ;
end ;

procedure TGLWallpaperChanger.Execute ;
var
   BMPFile : string ;
   SearchRec: TSearchRec;
   Files : TStringList ;
   {$IFNDEF WIN32}
   temp : array[0..255] of char ;
   {$ENDIF}
begin
     if FFileName <> '' then
{$IFDEF WIN32}
        SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, PChar(FFileName),
                             SPIF_UPDATEINIFILE or SPIF_SENDWININICHANGE)
{$ELSE}
     begin
        StrPCopy(temp, FFileName) ;
        SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, @temp,
                             SPIF_UPDATEINIFILE or SPIF_SENDWININICHANGE)
     end
{$ENDIF}
     else begin
        Files := TStringList.Create ;
        if FindFirst(FFileDir + Wildcard, faAnyFile, SearchRec) = 0 then begin
           Files.Add(SearchRec.Name) ;
           while FindNext(SearchRec) = 0 do
              Files.Add(SearchRec.Name) ;
        end ;
        FindClose(SearchRec) ;
        if Files.Count > 0 then begin
           Randomize ;
           BMPFile := Files[ Trunc(Random(Files.Count - 1)) ] ;
{$IFDEF WIN32}
           SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, PChar(BMPFile),
                                SPIF_UPDATEINIFILE or SPIF_SENDWININICHANGE) ;
{$ELSE}
           FillChar(temp, SizeOf(temp), 0) ;
           StrPCopy(temp, BMPFile) ;
           SystemParametersInfo(SPI_SETDESKWALLPAPER, 0, @temp,
                                SPIF_UPDATEINIFILE or SPIF_SENDWININICHANGE) ;
{$ENDIF}
        end ;
        Files.Free ;
     end ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Misc.', [TGLWallpaperChanger]);
end;

end.
