unit wpaper_editor ;

interface

uses
  Dialogs, DsgnIntf, wpaper ;

type
  TGLWallpaperEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(i : integer) : string ; override ;
     procedure ExecuteVerb(i : integer) ; override ;
  end ;

  TWallpaperFileNameEditor = class(TStringProperty)
    function  GetAttributes : TPropertyAttributes; override;
    procedure Edit ; override;
  end;

procedure Register;

implementation

function TWallpaperFileNameEditor.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] ;
end;

procedure TWallpaperFileNameEditor.Edit ;
var
   d : TOpenDialog ;
begin
  d := TOpenDialog.Create(nil) ;
  d.Title := 'Select Bitmap File' ;
{$IFDEF JPEG_SUPPORT}
  d.Filter := 'Bitmap files|*.bmp|JPEG files|*.jpg;*.jpeg' ;
{$ELSE}
  d.Filter := 'Bitmap files|*.bmp' ;
{$ENDIF}
  d.FileName := GetStrValue ;
  if d.Execute then
     SetStrValue(d.FileName) ;
  d.Free ;
end;

{ begin component editor logic }

function TGLWallpaperEditor.GetVerbCount : integer ;
begin
     if (Component as TGLWallpaper).Bitmap.Handle <> 0 then
        Result := 1
     else
        Result := 0 ;
end ;

function TGLWallpaperEditor.GetVerb(i : integer) : string ;
begin
     Result := '&Preview' ;
end ;

procedure TGLWallpaperEditor.ExecuteVerb(i : integer) ;
begin
     (Component as TGLWallpaper).DoPreview ;
end ;

{ end component editor logic }

procedure Register;
begin
  RegisterComponentEditor(TGLWallpaper, TGLWallpaperEditor) ;
  RegisterPropertyEditor( TypeInfo(TWallpaperFilename), TGLWallpaper,
                          'FileName', TWallpaperFileNameEditor );
end;

end.
