unit timed_ev_editor ;

interface

uses
  Controls, Forms, SysUtils, timed_ev, ComCtrls, DsgnIntf ;  // both of these are necessary for the property editors

type
  TGLDateEditor = class(TStringProperty)
     function GetAttributes : TPropertyAttributes ; override ;
     procedure Edit ; override ;
  end ;

  TGLTimeEditor = class(TStringProperty)
     function GetAttributes : TPropertyAttributes ; override ;
     procedure Edit ; override ;
  end ;

procedure Register;

implementation

uses Timed_Ev_Dlg ;

// begin property editor logic

function TGLDateEditor.GetAttributes : TPropertyAttributes ;
begin
     Result := inherited GetAttributes + [paDialog] ;
end ;

procedure TGLDateEditor.Edit ;
begin
     with TfrmDateTimeEditor.Create(nil) do
        try
           DateTimePicker.Kind := dtkDate ;
           if GetStrValue <> '' then
              DateTimePicker.Date := StrToDate(GetStrValue)
           else
              DateTimePicker.Date := Date ;
           if ShowModal = mrOK then
              SetStrValue( DateToStr(DateTimePicker.Date) ) ;
        finally
           Release ;
        end ;
end ;

function TGLTimeEditor.GetAttributes : TPropertyAttributes ;
begin
     Result := inherited GetAttributes + [paDialog] ;
end ;

procedure TGLTimeEditor.Edit ;
begin
     with TfrmDateTimeEditor.Create(nil) do
        try
           DateTimePicker.Kind := dtkTime ;
           if GetStrValue <> '' then
              DateTimePicker.Time := StrToTime(GetStrValue)
           else
              DateTimePicker.Time := Time ;
           if ShowModal = mrOK then
              SetStrValue( TimeToStr(DateTimePicker.Time) ) ;
        finally
           Release ;
        end ;
end ;

// end property editor logic

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string),      // data type of property
                         {$IFDEF VER130}
                         TGLEvent,              // component class
                         {$ELSE}
                         TGLTimedEvents,        // component class
                         {$ENDIF}
                         'TheDate',             // property name
                         TGLDateEditor) ;       // property editor class

  RegisterPropertyEditor(TypeInfo(string),      // data type of property
                         {$IFDEF VER130}
                         TGLEvent,              // component class
                         {$ELSE}
                         TGLTimedEvents,        // component class
                         {$ENDIF}
                         'TheTime',             // property name
                         TGLTimeEditor) ;       // property editor class
end;

end.
