unit swatch ;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes, WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TGLStopwatch = class(TComponent)
  private
     FActive : boolean ;
     {$IFDEF VER130}
     FElapsed : DWord ;
     FStartTime : DWord ;
     {$ELSE}
     FElapsed : integer ;
     FStartTime : integer ;
     {$ENDIF}
     function GetSeconds : string ;
     procedure SetActive(b : boolean) ;
  public
     constructor Create(AOwner : TComponent) ; override ;
     procedure Start ;
     procedure Stop ;
     {$IFDEF VER130}
     property Elapsed : DWord read FElapsed ;
     {$ELSE}
     property Elapsed : integer read FElapsed ;
     {$ENDIF}
     property Seconds : string read GetSeconds ;
  published
     property Active : boolean read FActive write SetActive default False ;
  end;

procedure Register;

implementation

constructor TGLStopwatch.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
{$IFDEF SHOW_COPYRIGHT}
     ShowCopyright(self,True) ;
{$ENDIF}
end ;

procedure TGLStopwatch.Start ;
begin
     SetActive(True) ;
end ;

procedure TGLStopwatch.Stop ;
begin
     SetActive(False) ;
end ;

procedure TGLStopwatch.SetActive(b : boolean) ;
begin
     FActive := b ;
     if b then
        FStartTime := GetTickCount
     else
        FElapsed := GetTickCount - FStartTime ;
end ;

function TGLStopwatch.GetSeconds : string ;
var
   i : real ;
begin
     if FActive then
        i := ( GetTickCount - FStartTime ) / 1000
     else
        i := FElapsed / 1000 ;
     Result := Format('%7.2f', [i] ) ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Misc.', [TGLStopwatch]);
end;

end.
