unit srchedit_editor;

interface

uses
  Classes,
  DsgnIntf,
  SrchEdit ;

type
  TMyFieldNameEditor = Class(TStringProperty)
    function  GetAttributes : TPropertyAttributes; override;
    procedure GetValues(Proc : TGetStrProc) ;      override;
  end;

procedure Register;

implementation

function TMyFieldNameEditor.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paValueList,paSortList] ;
end;

procedure TMyFieldNameEditor.GetValues(Proc: TGetStrProc);
var
  x : integer ;
begin
     with (GetComponent(0) as TGLSearchEdit).DataSet do begin
        FieldDefs.Update ;
        for x := 0 to FieldDefs.Count - 1 do
           Proc(FieldDefs[x].Name) ;
     end ;
end;

procedure Register;
begin
  RegisterPropertyEditor( TypeInfo(TMyFieldName), TGLSearchEdit, 'FieldName', TMyFieldNameEditor);
end;

end.
