unit srchedit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  DBTables,
  {$IFDEF VER130}
  DB      { necessary in Delphi 4 and 5 for TLocateOption settings }
  {$ENDIF}
  ;

type
  TMyFieldName = string[100] ;

  TGLSearchEdit = class(TEdit)
  private
     FBeepOnBadKey : boolean ;
     FDataSet : TDataSet ;
     FFieldName : TMyFieldName ;
     FFilterActive : boolean ;
  protected
     procedure Change ; override ;
     procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent) ; override ;
  published
     property BeepOnBadKey : boolean read FBeepOnBadKey write FBeepOnBadKey default False ;
     property DataSet : TDataSet read FDataSet write FDataSet ;
     property FieldName : TMyFieldName read FFieldName write FFieldName ;
     property FilterActive : boolean read FFilterActive
                                     write FFilterActive default False ;
  end;

procedure Register;

implementation

constructor TGLSearchEdit.Create(AOwner: TComponent);
begin
     inherited ;
{$IFDEF SHOW_COPYRIGHT}
     ShowCopyright(self,True) ;
{$ENDIF}
end;

procedure TGLSearchEdit.Notification(AComponent: TComponent; Operation: TOperation);
begin
   if (Operation = opRemove) and (AComponent = FDataSet) then
      FFieldName := '' ;
end ;

procedure TGLSearchEdit.Change ;
var
   NoFind : boolean ;
begin
     inherited ;
     if (FDataSet <> nil) and (FDataSet.Active) and (FFieldName <> '') then begin
        with FDataSet do
           if Text = '' then begin
              NoFind := False ;
              First ;
           end
           else if FFilterActive then begin
              FilterOptions := [foCaseInsensitive] ;
              Filter := FFieldName + '=' + QuotedStr(Text + '*') ;
              Filtered := ( Text <> '' ) ;
              NoFind := FDataSet.EOF ;
           end
           else
              NoFind := not Locate(FFieldName, Text,
                            [loCaseInsensitive, loPartialKey]) ;
        if NoFind then begin
           if FBeepOnBadKey then MessageBeep(0) ;
           Text := Copy(Text, 1, Length(Text) - 1) ;
           SelStart := Length(Text) ;
        end ;
     end ;
end ;

procedure Register;
begin
  RegisterComponents('GLAD: Database', [TGLSearchEdit]);
end;

end.
