{
    TGLScrollDBGrid
    "True" scrolling grid (instead of top/center/bottom)
    Copyright  1998 Greg Lief
    http://www.greglief.com

    VERY IMPORTANT CAVEATS:

    (a) If you are planning to use a controlling index, the scrollbar
        will work properly ONLY with Paradox tables!!!

    (b) Don't expect good results with an active filter... sorry.
}

unit sgrid;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids,
  StdCtrls { added manually... for TScrollBar },
  DB { added manually... for TField }
  {$IFNDEF WIN32}
  , DBIProcs, DBITypes, DBConsts { added manually for RecordNumber method }
  {$ENDIF}
  ;

type
  TGLScrollDBGrid = class(TDBGrid)
  private
    FScrollBar : TScrollBar ;
    FOldOnDataChange : TDataChangeEvent ;
    {$IFNDEF WIN32}
    function RecordNumber : longint;
    {$ENDIF}
  protected
    procedure CMVisibleChanged(var Msg : TMessage) ; message CM_VISIBLECHANGED ;
    procedure Loaded ; override ;
    procedure ScrollBarEvent(Sender : TObject;
              ScrollCode: TScrollCode; var ScrollPos : Integer);
    procedure DataChange(Sender : TObject ; Field : TField) ;
  public
    constructor Create(AOwner : TComponent) ; override ;
    destructor Destroy ; override ;
  end;

procedure Register;

implementation

constructor TGLScrollDBGrid.Create(AOwner : TComponent) ;
begin
     inherited Create(AOwner) ;
     FScrollBar := TScrollBar.Create(self) ;
     FScrollBar.Kind := sbVertical ;
     FScrollBar.OnScroll := ScrollBarEvent ;
{$IFDEF SHOW_COPYRIGHT}
     ShowCopyright(self,True) ;
{$ENDIF}
end ;

procedure TGLScrollDBGrid.Loaded ;
begin
     inherited Loaded ;
     FScrollBar.Top := Top + 1 ;
     FScrollBar.Height := Height - 16 ;
     FScrollBar.Left := Left + Width - FScrollBar.Width - 1 ;
     FScrollBar.Parent := TWinControl(Owner) ;
     if DataSource <> nil then begin
        FOldOnDataChange := DataSource.OnDataChange ;
        DataSource.OnDataChange := DataChange ;
     end ;
end ;

destructor TGLScrollDBGrid.Destroy ;
begin
     FScrollBar := nil ;
     if Assigned(FOldOnDataChange) then
        DataSource.OnDataChange := FOldOnDataChange ;
     inherited Destroy ;
end ;

procedure TGLScrollDBGrid.CMVisibleChanged(var Msg : TMessage) ;
begin
     inherited ;
     FScrollBar.Visible := Visible ;
end ;

procedure TGLScrollDBGrid.DataChange(Sender : TObject ; Field : TField) ;
begin
     if Field = nil then begin
        with FScrollBar do begin
           Min := 1;
           Max := DataSource.DataSet.RecordCount;
           {$IFDEF WIN32}
           Position := DataSource.DataSet.RecNo
           {$ELSE}
           Position := RecordNumber ;
           {$ENDIF}
        end;
        if Assigned(FOldOnDataChange) then
           FOldOnDataChange(Sender, Field) ;
     end ;
end ;

procedure TGLScrollDBGrid.ScrollBarEvent(Sender : TObject ; ScrollCode: TScrollCode;
                               var ScrollPos : Integer);
var
    nrec : integer;
begin
    nrec := 0;
    with FScrollbar do
       case ScrollCode of
          scLineUp  :  nrec := -SmallChange;
          scLineDown:  nrec := +SmallChange;
          scPageUp  :  nrec := -LargeChange;
          scPageDown:  nrec := +LargeChange;
          {$IFDEF WIN32}
          scPosition:  nrec := ScrollPos - DataSource.DataSet.RecNo ;
          scTrack:     nrec := ScrollPos - DataSource.DataSet.RecNo ;
          {$ELSE}
          scPosition:  nrec := ScrollPos - RecordNumber ;
          scTrack:     nrec := ScrollPos - RecordNumber ;
          {$ENDIF}
          scTop:       nrec := ScrollPos - Position - 1;
          scBottom:    nrec := ScrollPos - Position + 1;
          scEndScroll: nrec := 0;
       end;
    if nrec <> 0 then
       DataSource.DataSet.MoveBy(nrec);
    SetFocus ; 
end;

{$IFNDEF WIN32}
function TGLScrollDBGrid.RecordNumber : Longint ;
var
    cursorprops : curprops;
    recordprops : recprops;
begin
    Result:=0;
    with DataSource.Dataset do begin
       if State = dsInactive then
          DBError(SDataSetClosed);
       Check(DbiGetCursorProps(Handle,CursorProps));
       UpdateCursorPos;
       Check(DbiGetRecord(Handle,dbiNOLOCK,nil,@recordprops));
       case cursorprops.iseqnums of
          0 : Result := recordprops.iPhyRecNum;
          1 : Result := recordprops.iSeqNum;
       end;
    end;
end;
{$ENDIF}

procedure Register;
begin
  RegisterComponents('GLAD: DBGrids', [TGLScrollDBGrid]);
end;

end.
