unit rec_repl_editor ;

interface

uses
  Dialogs,
  DsgnIntf,
  rec_repl,
  SysUtils ;

type
  TGLRecordReplaceEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(i : integer) : string ; override ;
     procedure ExecuteVerb(i : integer) ; override ;
  end ;

procedure Register;

implementation

uses FD_Form ;  // for TGLFieldSelectionDialog

{ begin component editor logic }

function TGLRecordReplaceEditor.GetVerbCount : integer ;
begin
     if ((Component as TGLRecordReplace).DataSet <> nil) and
        ((Component as TGLRecordReplace).Fields.Count > 0) and
        ((Component as TGLRecordReplace).SearchText <> '') then
        Result := 1
     else
        Result := 0 ;
end ;

function TGLRecordReplaceEditor.GetVerb(i : integer) : string ;
begin
     if i = 0 then
        Result := 'E&xecute' ;
end ;

procedure TGLRecordReplaceEditor.ExecuteVerb(i : integer) ;
begin
     if i = 0 then
        MessageDlg(IntToStr((Component as TGLRecordReplace).Execute) +
                   ' records updated', mtInformation, [mbOK], 0) ;
end ;

{ end component editor logic }


procedure Register;
begin
  RegisterComponentEditor(TGLRecordReplace, TGLRecordReplaceEditor)
end;

end.
