(*
   Special thanks to Joe Booth for the LineNumbers property
*)

unit prnfile_editor ;

interface

uses dialogs, prnfile, DsgnIntf ;

type
  TGLPrintTextFileEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(i : integer) : string ; override ;
     procedure ExecuteVerb(i : integer) ; override ;
  end ;

  TMyFileNameEditor = class(TStringProperty)
    function  GetAttributes : TPropertyAttributes; override;
    procedure Edit ; override;
  end;

procedure Register ;

implementation

{ begin component editor logic }

function TGLPrintTextFileEditor.GetVerbCount : integer ;
begin
     if ((Component as TGLPrintTextFile).FileName <> '') then
        Result := 1    // # of items to add to the pop-up menu
     else
        Result := 0 ;
end ;

function TGLPrintTextFileEditor.GetVerb(i : integer) : string ;
begin
     if i = 0 then
        Result := '&Print' ;
end ;

procedure TGLPrintTextFileEditor.ExecuteVerb(i : integer) ;
begin
     if i = 0 then
        (Component as TGLPrintTextFile).Print ;
end ;

{ end component editor logic }


{ begin FileName property editor logic }

function TMyFileNameEditor.GetAttributes : TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] ;
end;

procedure TMyFileNameEditor.Edit ;
var
   d : TOpenDialog ;
begin
  d := TOpenDialog.Create( nil ) ;
  d.Title := 'Select Text File' ;
  d.Filter := 'Text files|*.txt' ;
  if d.Execute then
     SetStrValue(d.FileName) ;
  d.Free ;
end;

{ end FileName property editor logic }


procedure Register ;
begin
   RegisterPropertyEditor( TypeInfo(TMyFilename), TGLPrintTextFile,
                           'Filename', TMyFileNameEditor );
   RegisterComponentEditor(TGLPrintTextFile, TGLPrintTextFileEditor)
end ;

end.
