unit msgdlg_editor ;

interface

uses
  msgdlg, DsgnIntf ;

type
  TGLMessageDlgEditor = class(TComponentEditor)
     function GetVerbCount : integer ; override ;
     function GetVerb(i : integer) : string ; override ;
     procedure ExecuteVerb(i : integer) ; override ;
  end ;

procedure Register;

implementation

{ begin component editor logic }

function TGLMessageDlgEditor.GetVerbCount : integer ;
begin
     if (Component as TGLMessageDlg).ButtonNames.Count > 0 then 
        Result := 1     { # of items to add to the pop-up menu }
     else 
        Result := 0 ;   
end ;

function TGLMessageDlgEditor.GetVerb(i : integer) : string ;
begin
     if i = 0 then
        Result := 'E&xecute' ;
end ;

procedure TGLMessageDlgEditor.ExecuteVerb(i : integer) ;
begin
     if i = 0 then
        (Component as TGLMessageDlg).Execute ;
end ;

{ end component editor logic }

procedure Register;
begin
  RegisterComponentEditor(TGLMessageDlg, TGLMessageDlgEditor)
end;

end.
